# Copyright 2021-2022 VMware, Inc.
# All rights reserved. -- VMware Confidential

from com.vmware.esx.settings_daemon_client import (ComplianceImpact,
   ComplianceStatus, Notification)

INFO = Notification.Type.INFO
WARNING = Notification.Type.WARNING
ERROR = Notification.Type.ERROR

COMPLIANT = ComplianceStatus.COMPLIANT
NON_COMPLIANT = ComplianceStatus.NON_COMPLIANT
INCOMPATIBLE = ComplianceStatus.INCOMPATIBLE
UNAVAILABLE = ComplianceStatus.UNAVAILABLE

RESOLUTION_SUFFIX = ".Resolution"

DPU_PREFIX = "com.vmware.vcIntegrity.lifecycle.DPUOperation."

# Error notification
DPUInfoError = 'DPUInfoError'
TaskStartError = 'TaskStartError'
TaskUpdateError = 'TaskUpdateError'
TaskStateTransitionEror = 'TaskStateTransitionEror'

# State info notification
TaskStarted = 'TaskStarted'
TaskSucceeded = 'TaskSucceeded'
TaskMaxRetry = 'TaskMaxRetry'
TaskTimeout = 'TaskTimeout'
TaskRetry = 'TaskRetry'
TaskFailed = 'TaskFailed'
DPUOperationStart = 'DPUOperationStart'
UnavailableDpuTaskFailed = 'UnavailableDpuTaskFailed'

NOTIFICATION_MSG = {
   DPUInfoError: "An error occurred when get data processing unit info.",
   TaskStartError: "Failed to start vAPI task '{1}' on data processing "
                   "unit '{2}'.",
   TaskUpdateError: "Failed to update vAPI task '{1}' on data processing"
                    " unit '{2}'.",
   TaskStarted: "VAPI task '{1}' started on data processing unit '{2}'.",
   TaskRetry: "Retry vAPI task '{1}' on data processing unit '{2}'.",
   TaskTimeout: "VAPI task '{1}' on data processing unit '{2}' timeed out.",
   TaskStateTransitionEror: "An error occurred when transitioning state of "
                            "vAPI task '{1}' on data processing unit '{2}'.",
   TaskSucceeded: "VAPI task '{1}' on data processing unit '{2}' succeeded.",
   TaskFailed: "VAPI task '{1}' on data processing unit '{2}' failed.",
   TaskMaxRetry: "VAPI task '{1}' on data processing unit '{2}' failed to "
                 "the maximum runs {3}.",
   DPUOperationStart: "Starting operation on {1} data processing units",
   UnavailableDpuTaskFailed: "VAPI task '{1}' failed on data processing unit "
                             "'{2}' at UNAVAILABLE state.",
}

RESOLUTION_MSG = {
   DPUInfoError: "Check logs for details and check dpu states.",
   TaskStartError: "Check network connection of data processing unit '{1}'.",
   TaskUpdateError: "Check network connection of data processing unit '{1}'.",
   TaskStateTransitionEror: "Check logs on data processing unit vAPI task "
                            "'{1}' of data processing unit '{2}'.",
}
