########################################################################
# Copyright (C) 2010-2018, 2020  VMWare, Inc.                                 #
# All Rights Reserved                                                  #
########################################################################

"""This module provides the gzip interface for ESXi"""

import gzip

class GzipFile(gzip.GzipFile):
   def _write_gzip_header(self, compresslevel = 9):
      # Static header for ESX gzip format: 2-byte gzip magic + compression
      # method (8, "deflate") + flags (0) + 4-byte timestamp (0's) + extra
      # flags (2, max compression) + OS (255, unknown). All optional fields are
      # intentionally omitted. This enables re-compressing data and getting
      # consistent output that can be matched against a digest.
      self.fileobj.write(b"\037\213\010\000\000\000\000\000\002\377")
