//
//  AppSettings.h
//  Radio
//
//  Created by kek on 12/22/19.
//  Copyright © 2019 kek. All rights reserved.
//

#ifndef AppSettings_h
#define AppSettings_h

#define API_URL @"https://r-a-d.io/api/"
#define DJIMAGE_URL @"https://r-a-d.io/api/dj-image/%@"
#define NEWS_URL @"https://r-a-d.io/api/news/"
#define SEARCH_URL @"https://r-a-d.io/api/search"

#define API_UPDATE_INTERVAL 10000
#define SONG_UPDATE_INTERVAL 500

#define IRC_URL @"irc.rizon.net"
#define IRC_CHANNEL @"#r/a/dio"



@interface RadioConfig : NSObject
{
    NSUserDefaults *defaults;
    
}

//app settings
@property int themeID;
@property (nonatomic) float volume;
@property bool timestamps;
@property bool forceSystemTheme;

@property bool enableDebug;

//irc settings
@property NSString *nickname;

+(NSURL *)getAPIurl;
+(int)getSongUpdateInterval;
+(int)getAPIupdateInterval;

-(id)init;

-(void)setVolume:(float)volume;

@end

#endif /* AppSettings_h */
