//
//  PlayerViewController.h
//  Radio
//
//  Created by kek on 12/23/19.
//  Copyright © 2019 kek. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AVKit/AVKit.h>
#import <AVFoundation/AVFoundation.h>
#import "../API/API.h"
#import "../objs/Track.h"
#import "../objs/DJ.h"
#import "../objs/RadioConfig.h"
#import "../objs/Queue.h"
#import "../objs/LastPlayed.h"
#import "../API/APIHandler.h"
#import "QueueCell.h"
#import "../objs/Player.h"

NS_ASSUME_NONNULL_BEGIN

@interface PlayerViewController : UIViewController <AVPlayerItemMetadataOutputPushDelegate, UITableViewDataSource, UITableViewDelegate>

{
    Player *player;
    mainData *mData;
    DJ *currentDJ;
    Track *nowPlaying;
    RadioConfig *radioSettings;
    Queue *queue;
    LastPlayed *lp;
    NSURL *streamURL;
    BOOL isPlaying;
    AVPlayer *streamPlayer;
    AVPlayerItem *streamItem;
    AVPlayerLayer *streamLayer;
    AVPlayerItemMetadataOutput *metadataOutput;
    
    int masterTimer;
    

    
}

// UI Elements
@property (strong, nonatomic) IBOutlet UILabel *npSongName;
@property (strong, nonatomic) IBOutlet UILabel *songTime;
@property (strong, nonatomic) IBOutlet UILabel *djName;
@property (strong, nonatomic) IBOutlet UILabel *listenerCount;
@property (strong, nonatomic) IBOutlet UIImageView *djImage;
@property (strong, nonatomic) IBOutlet UIButton *playStream;
@property (strong, nonatomic) IBOutlet UISlider *volumeSlider;
@property (strong, nonatomic) IBOutlet UIProgressView *progressBar;
@property (strong, nonatomic) IBOutlet UIView *queueDisplay;
@property (strong, nonatomic) IBOutlet UITableView *queueTable;

@property (strong, nonatomic) IBOutlet UIView *lastPlayingDisplay;
@property (strong, nonatomic) IBOutlet UITableView *lastPlayedTable;
@property (strong, nonatomic) IBOutlet UILabel *threadLink;


// UI Actions
- (IBAction)playStreamAction:(id)sender;
- (IBAction)volumeChange:(id)sender;

// Functions
- (void)updateUI;
- (void)setCurrentDJ;
- (void)setCurrentTrack;
-(void)setCurrentTrackProgress;
- (void)onTimerIncrement;


- (void)initPlayer;
//metadata
- (void)metadataOutput:(AVPlayerItemMetadataOutput *)output didOutputTimedMetadataGroups:(NSArray<AVTimedMetadataGroup *> *)groups fromPlayerItemTrack:(nullable AVPlayerItemTrack *)track;

//table view
- (NSInteger)tableView:(UITableView *)tableView
numberOfRowsInSection:(NSInteger)section;

- (UITableViewCell *)tableView:(UITableView *)tableView
cellForRowAtIndexPath:(NSIndexPath *)indexPath;



@end

NS_ASSUME_NONNULL_END
