//
//  API.h
//  Radio
//
//  Created by kek on 12/22/19.
//  Copyright © 2019 kek. All rights reserved.
//

#import "../objs/RadioConfig.h"

#ifndef API_h
#define API_h


@interface API : NSObject
{
    NSURL *apiURL;
    NSURLSessionConfiguration *sessionConfig;
}
    
//- (void) initWithSettings;

- (NSURL *)getURL;
- (NSURLSessionConfiguration *)getSessionConfig;
//main GET - /
- (NSDictionary *)requestMain;
//last played GET - /last-played{?limit}{?offset}

//queue GET - /queue

//news
// view all GET - /news{?limit}{?offset}

//view post GET - /news/{?id}{?commments}

//search

//request


@end

@interface mainData : NSObject
{
    NSDictionary *apiData;

}

@property NSString *nowPlaying;
@property int listeners;
@property BOOL isAFKstream;
@property long startTime;
@property long endTime;
@property int trackID;
@property NSString *thread;
@property BOOL canRequest;
@property NSString *djName;
@property long currentTime;


- (void)fetchData;
- (NSDictionary *)getDJdata;
- (NSArray *)getQueueData;
- (NSArray *)getLastPlayedData;
- (NSString *)getSongName;
- (int)getListenerCount;

@end



#endif /* API_h */
