//
//  APIHandler.h
//  Radio
//
//  Created by spiky on 12/22/19.
//  Copyright © 2019 spiky. All rights reserved.
//

#import "../objs/RadioConfig.h"
#ifndef APIHandler_h
#define APIHandler_h

@interface APIHandler : NSObject
{
    NSURL *apiBaseUrl;
    NSURLSession *apiSession;
    
}

// Initialize API Handler
- (id) initWithSettings;

//generic get function
-(NSDictionary *)apiGET:(NSURL *)url
               callback:(id)callback
               selector:(SEL)selector;
// Main | GET - /

-(void)getMain:(id)callback
      selector:(SEL)selector;

// Last Played | GET - /last-played{?limit}{?offset}
-(NSArray *)getLastPlayed:(int)limit offset:(int)offset;

// Queue | GET - /queue
-(NSArray *)getQueue;

// News
// View All | GET - /news{?limit}{?offset}
-(NSArray *)getAllNews:(int)limit offset:(int)offset;

// View Post | GET - /news/{?id}{?commments}
-(NSDictionary *)getNewsPost:(int)id comments:(BOOL)comments;

// Search | GET - ../search/{songname}

// Request | POST - ../request/{id}{token}


@end

#endif /* APIHandler_h */
