//
//  APIHandler.m
//  Radio
//
//  Created by spiky on 12/22/19.
//  Copyright © 2019 spiky. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APIHandler.h"

@implementation APIHandler

-(id)initWithSettings
{
    self = [super init];
    apiBaseUrl = [RadioConfig getAPIurl];
    apiSession = [NSURLSession sessionWithConfiguration:[NSURLSessionConfiguration defaultSessionConfiguration]];
    NSLog(@"API Handler Initialized");
    return self;
}

-(NSDictionary *)apiGET:(NSURL *)url
               callback:(id)callback
               selector:(SEL)selector
{
    NSLog(@"Getting new data");
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    NSDictionary *responseDictionary;
    NSURLSessionDataTask *task = [apiSession dataTaskWithRequest:request completionHandler:^(NSData *data, NSURLResponse *response, NSError *error)
    {
        NSHTTPURLResponse *httpRes = (NSHTTPURLResponse *)response;
        if(httpRes.statusCode == 200)
        {
            NSError *parseErr = nil;
            NSDictionary *resDict = [NSJSONSerialization JSONObjectWithData:data options:0 error:&parseErr];
            //*responseDictionary = resDict;
            NSLog(@"testapi - %@",resDict);
            [callback performSelector:selector withObject:resDict];
        }
        else
        {
            NSLog(@"somebody fucked up");
        }
        
    }];
    [task resume];
    return responseDictionary;
}





-(void)getMain:(id)callback
      selector:(SEL)selector
{
    NSDictionary *responseDictionary;
    responseDictionary = [self apiGET:apiBaseUrl callback:callback selector:selector];
    
}

@end
