//
//  Player.h
//  Radio
//
//  Created by kek on 8/10/20.
//  Copyright © 2020 kek. All rights reserved.
//

#ifndef Player_h
#define Player_h
#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>
#import <AVKit/AVKit.h>
#import "../API/APIHandler.h"
#import "Track.h"
#import "DJ.h"
#import "Queue.h"
#import "LastPlayed.h"



// radio information

@interface Player : NSObject <AVPlayerItemMetadataOutputPushDelegate>
{
    //internal vars
    NSDictionary *apiData;

    APIHandler *apiHandler;
    //media player(dumpster fire)
    
    AVPlayer *streamPlayer;
    AVPlayerItem *streamItem;
    AVPlayerLayer *streamLayer;
    AVPlayerItemMetadataOutput *metadataOutput;
    
    //THE DELEGATEs DAHNALD
    //id delegate;
    
}

-(id)init;

//delegates
//@property id <UIPageViewControllerDelegate> playerView;
//- (void)setSkelegate:(id)skelegate;

// info from api
@property NSString *nowPlaying;
@property int listeners;
@property BOOL isAFKstream;
@property long startTime;
@property long endTime;
@property int trackID;
@property NSString *thread;
@property BOOL canRequest;
@property NSString *djName;
@property long currentTime;
@property DJ *currentDJ;
@property Track *currentTrack;
@property Queue *queue;
@property LastPlayed *lp;

//player vars
@property BOOL isPlaying;




// api
- (void)fetchData;
//- (NSDictionary *)getDJdata;
//- (NSArray *)getQueueData;
//- (NSArray *)getLastPlayedData;
//- (NSString *)getSongName;

- (void)receiveData:(id)sender
               data:(NSDictionary *)data;

// timer for api and ui refresh



// shitty ass ios built in dumpster fire media player
-(void)initMediaPlayer; // todo - find replacement
-(void)playStream;
-(void)stopStream;
-(void)setStreamVolume:(float)volume;


// metadata shit
- (void)metadataOutput:(AVPlayerItemMetadataOutput *)output didOutputTimedMetadataGroups:(NSArray<AVTimedMetadataGroup *> *)groups fromPlayerItemTrack:(nullable AVPlayerItemTrack *)track;

@end
#endif /* Player_h */
