//
//  Track.m
//  Radio
//
//  Created by kek on 12/21/19.
//  Copyright © 2019 kek. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Track.h"


@implementation Track

//used for nowplaying track only
-(void) setTrackData:(NSString *)name
trackID:(int)id
startTime:(long)start
endTime:(long)end
{
    _trackName = name;
    _trackID = id;
    _startTime = start;
    _endTime = end;
    _type = 0;
    _trackLength = [self getTrackTime];
    

}

-(int) getTrackTime
{
    return _endTime - _startTime;
}

-(NSArray *)formatMetadata
{
    NSArray *formattedMetadata = [_trackName componentsSeparatedByString:@" - "];
    return formattedMetadata;
}

-(NSString *)formatTrackTimestamp:(long)currentTime
{
    NSString *formattedTime = @"error";
    long timeAgo = _startTime - currentTime;
    
    if(timeAgo > -1)
    { //queue objects
        if(timeAgo >= 3600)
        {
            int formattedHours = timeAgo / 3600;
            formattedTime = [NSString stringWithFormat:@"in %d hours", formattedHours];
        } else if(timeAgo >= 60)
        {
            int formattedMinutes = timeAgo / 60;
            formattedTime = [NSString stringWithFormat:@"in %d minutes", formattedMinutes];
        } else if(timeAgo < 60)
        {
            formattedTime = @"in less than a minute";
        } else
        {
            formattedTime = @"??????????????";
        }

    }
    else
    { //last played objects
        if(timeAgo > 0){
            formattedTime = @"HOW DOES THIS EVEN HAPPEN";
        } else if(timeAgo > -60)
        {
            formattedTime = @"less than a minute ago";
        } else if (timeAgo > -3600)
        {
            int formattedMinutes = timeAgo / -60;
            formattedTime = [NSString stringWithFormat:@"%d minutes ago", formattedMinutes];
        } else if (timeAgo > -86400)
        {
            int formattedHours = timeAgo / -3600;
            formattedTime = [NSString stringWithFormat:@"%d hours ago", formattedHours];
        } else
        {
            int formattedDays = timeAgo / -86400;
            formattedTime = [NSString stringWithFormat:@"%d days ago", formattedDays];
        }
        
        // % hours ago
        // % minutes ago
        //less than a minute ago
        //wtf happened
        
    }
    
    return formattedTime;
}

@end


