//
//  PlayerViewController.m
//  Radio
//
//  Created by kek on 12/23/19.
//  Copyright © 2019 kek. All rights reserved.
//

#import "PlayerViewController.h"

@implementation PlayerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    masterTimer = 0;
    
    //load user preferences
    radioSettings = [[RadioConfig alloc] init];
    
    //todo - settings init func - theme etc
    
    self.volumeSlider.value = radioSettings.volume;
    
    //new player init
    player = [[Player alloc] init];

   
    
    _queueTable.dataSource = self;
    _queueTable.delegate = self;
    //player.playerView = self;
    
    _lastPlayedTable.dataSource = self;
    _lastPlayedTable.delegate = self;
    
    //call updateUI on first load
       [player fetchData];
       [self updateUI];
    
    //[self initPlayer];

    NSLog(@"Player View Loaded");
    
    //maybe this is better
    NSTimer *timer = [NSTimer timerWithTimeInterval:1 target:self selector:@selector(onTimerIncrement) userInfo:nil repeats:YES];
    [[NSRunLoop mainRunLoop] addTimer:timer forMode:NSRunLoopCommonModes];
    

}

- (void)updateUI
{
    
    //check dj change
    if(player.currentDJ.djName != _djName.text)
    {
        //[player.currentDJ setDJdata:mData];
        [self setCurrentDJ];
        NSLog(@"DJ data updated");
    }
    //add check for image change here <---------------------
    
    //check song change
    if(self.npSongName.text != player.nowPlaying)
    //if(player.currentTrack.startTime != mData.startTime)
    {
        //[player.currentTrack setTrackData:mData]; //delete with new player
        
        [self setCurrentTrack];
        NSLog(@"Track data updated");
        
        //update queue if afk stream
        //[player.queue updateQueue:mData.getQueueData];
        [_queueTable performSelectorOnMainThread:@selector(reloadData)
           withObject:nil
        waitUntilDone:NO];

        //update last played
        //[player.lp updateLastPlayed:mData.getLastPlayedData];
        [_lastPlayedTable performSelectorOnMainThread:@selector(reloadData)
           withObject:nil
        waitUntilDone:NO];
        
    }
    
    //update thread link if not afk stream
           if(!player.canRequest)
           {
               self.queueDisplay.hidden = true;
               self.threadLink.hidden = false;
               if([player.thread isEqualToString:@"none"])
               {
                   self.threadLink.text = @"There is currently no thread up.";
               }
               else
               {
                   self.threadLink.text = @"Thread up!";
                   // add clickable thread link/button
               }
           }
           else
           {
               self.queueDisplay.hidden = false;
               self.threadLink.hidden = true;
           }
    
    //update listeners
    self.listenerCount.text = [NSString stringWithFormat:@"Listeners: %d", player.listeners];
    
    NSLog(@"UI data updated");
}

// rewrite to create and destroy player on start and stop
- (IBAction)playStreamAction:(id)sender {
    if(!player.isPlaying)
    {
        NSLog(@"[PLAYER VIEW] stream play action");
        
        //[player initPlayer];
        
        //[self->streamPlayer play];
        [player playStream];
        //player.isPlaying = TRUE;
        
        [self.playStream setTitle:@"Stop Stream" forState:UIControlStateNormal];
    } else {
        NSLog(@"[PLAYER VIEW] stream stop action");
        //[self->streamPlayer pause];
        
        //player.isPlaying = FALSE;
        [player stopStream];
        
        [self.playStream setTitle:@"Play Stream" forState:UIControlStateNormal];
    }
}

- (IBAction)volumeChange:(id)sender {
    [player setStreamVolume:self.volumeSlider.value];
    //self->streamPlayer.volume = self.volumeSlider.value;
    
    //save volume setting
    [radioSettings setVolume:self.volumeSlider.value];
}

- (void)setCurrentDJ
{
    NSURL *djImageURL = [NSURL URLWithString:[NSString stringWithFormat:@"https://r-a-d.io/api/dj-image/%@",player.currentDJ.djImage]];
    NSLog(@"dj image url %@", [djImageURL absoluteString]);
    NSData *imgData = [NSData dataWithContentsOfURL:djImageURL];
    UIImage *djImg = [UIImage imageWithData:imgData];
    
    self.djName.text = player.currentDJ.djName;
    self.djImage.image = djImg;
}

-(void)setCurrentTrack
{
    // [nowPlaying setTrackData:player];
    //_npSongName.text = player.currentTrack.trackName;

    _npSongName.text = player.nowPlaying;
    double trackCurrentTime;
    
    trackCurrentTime = player.currentTime - player.currentTrack.startTime;
    
    //trackCurrentTime = mData.currentTime - currentTrack.startTime;
    
    NSDateComponentsFormatter *formatter = [[NSDateComponentsFormatter alloc] init];
    formatter.zeroFormattingBehavior = NSDateComponentsFormatterZeroFormattingBehaviorNone;
    formatter.allowedUnits = NSCalendarUnitMinute | NSCalendarUnitSecond;
    formatter.unitsStyle = NSDateComponentsFormatterUnitsStylePositional;
    
    _songTime.text = [NSString stringWithFormat:@"%@/%@", [formatter stringFromTimeInterval:trackCurrentTime], [formatter stringFromTimeInterval:player.currentTrack.trackLength]];
    _progressBar.progress = trackCurrentTime / player.currentTrack.trackLength;
}

-(void)setCurrentTrackProgress
{
    double trackCurrentTime;
    
    //using api current time
    trackCurrentTime = player.currentTime - player.currentTrack.startTime;
    //rackCurrentTime = mData.currentTime - currentTrack.startTime;
    
    NSDateComponentsFormatter *formatter = [[NSDateComponentsFormatter alloc] init];
    formatter.zeroFormattingBehavior = NSDateComponentsFormatterZeroFormattingBehaviorNone;
    formatter.allowedUnits = NSCalendarUnitMinute | NSCalendarUnitSecond;
    formatter.unitsStyle = NSDateComponentsFormatterUnitsStylePositional;
    
    _songTime.text = [NSString stringWithFormat:@"%@/%@", [formatter stringFromTimeInterval:trackCurrentTime], [formatter stringFromTimeInterval:player.currentTrack.trackLength]];
    _progressBar.progress = trackCurrentTime / player.currentTrack.trackLength;
}

-(void)onTimerIncrement
{
    if(masterTimer % 2 == 0)
    {
        [self updateUI];
    }
    
    if(masterTimer > 30)
    {
        [player fetchData];
        NSLog(@"test api refresh intervals");
        masterTimer = 0;
    }
    
    
    
    //mData.currentTime++;
    player.currentTime++;
    masterTimer++;
    
    [self setCurrentTrackProgress];
}


-(void)initPlayer
{
    NSLog(@"this should not be executing");
    isPlaying = FALSE;
    //streamURL = [NSURL URLWithString:@"https://stream.r-a-d.io/main.mp3"];
    //streamPlayer = [AVPlayer playerWithURL:self->streamURL];
    streamItem = [AVPlayerItem playerItemWithURL:[NSURL URLWithString:@"https://stream.r-a-d.io/main.mp3"]];
    metadataOutput = [[AVPlayerItemMetadataOutput alloc] init];
    [metadataOutput setDelegate:self queue:dispatch_get_main_queue()];
    [streamItem addOutput:metadataOutput];
    
    streamPlayer = [AVPlayer playerWithPlayerItem:streamItem];
    streamPlayer.currentItem.preferredForwardBufferDuration = 1;
    
    streamLayer = [AVPlayerLayer playerLayerWithPlayer:self->streamPlayer];
    [self.view.layer addSublayer:streamLayer];
    streamPlayer.allowsExternalPlayback = TRUE;
}

//meta
- (void)metadataOutput:(AVPlayerItemMetadataOutput *)output didOutputTimedMetadataGroups:(NSArray<AVTimedMetadataGroup *> *)groups fromPlayerItemTrack:(nullable AVPlayerItemTrack *)track
{
    AVMetadataItem *meta = groups.firstObject.items.firstObject;
    NSLog(@"item meta: %@", meta.stringValue);
    [self updateUI];
    if ([meta.stringValue  isEqual: @"ed"] || [meta.stringValue  isEqual: @"early"])
    {
        // somebody fucked up
        self.djName.text = @"SOMEBODY FUCKED UP";
        //self.djName.textColor = UIColor *redColor;
    }
}
//table
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    int count = 1;
    if(tableView == self.queueTable)
    {
        count = 5;
    }
    if(tableView == self.lastPlayedTable)
    {
        count = 5;
    }
    return count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    //Track *track;
    QueueCell *cell;
    
    if(tableView == self.queueTable)
    {
        
        //NSDictionary *trackDataTest = [queue objectAtIndex:indexPath.row];
        Track *qTrack = [player.queue.array objectAtIndex:indexPath.row];
        NSArray *trackMeta = [qTrack formatMetadata];
        
        cell = [_queueTable dequeueReusableCellWithIdentifier:@"queueCell" forIndexPath:indexPath];
        
        cell.trackName.text = [trackMeta objectAtIndex:1];
        cell.artist.text = [trackMeta objectAtIndex:0];
        
        cell.timestamp.text = [qTrack formatTrackTimestamp:player.currentTime];
        if(qTrack.type == 1){
            cell.trackName.textColor = UIColor.blueColor;
            cell.artist.textColor = UIColor.blueColor;
            cell.timestamp.textColor = UIColor.blueColor;
        } else
        {
            cell.trackName.textColor = UIColor.blackColor;
            cell.artist.textColor = UIColor.blackColor;
            cell.timestamp.textColor = UIColor.blackColor;
        }
    }
    if(tableView == self.lastPlayedTable)
    {
        Track *lpTrack = [player.lp.array objectAtIndex:indexPath.row];
        NSArray *trackMeta = [lpTrack formatMetadata];
        cell = [_lastPlayedTable dequeueReusableCellWithIdentifier:@"lpCell" forIndexPath:indexPath];
        
        if(trackMeta.count == 1)
        {
            cell.trackName.text = lpTrack.trackName;
        } else {
            cell.trackName.text = [trackMeta objectAtIndex:1];
            cell.artist.text = [trackMeta objectAtIndex:0];
        }
        
        
        cell.timestamp.text = [lpTrack formatTrackTimestamp:player.currentTime];
    }
    return cell;
}


#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}


@end
