-- This file needs to run after IR2 data.lua but before IR2 data-updates.lua
-- because it accesses IR2 "DIR" inferface and sets up recipes for procedural
-- tech tree generation. All prerequisites and item unlocks should also be
-- set up here.

-- IR2 is now a dependency, so data.lua is guaranteed to run after IR2's.

if not mods.IndustrialRevolution then return end
if not DIR then
	error("Industrial Revolution is active but it does not provide the DIR interface. This should not happen, please report the issue on Earendel's discord.")
end

require("prototypes/technology/technology-update")

require("prototypes/compatibility/industrial-revolution/component")
require("prototypes/compatibility/industrial-revolution/burner-assembling-machine")
require("prototypes/compatibility/industrial-revolution/native")
require("prototypes/compatibility/industrial-revolution/recipe")
require("prototypes/compatibility/industrial-revolution/technology")

-- Add basic-crafting category to all assembling machines
for _,name in pairs{"assembling-machine-1", "assembling-machine-2", "assembling-machine-3"} do
	local categories = data.raw["assembling-machine"][name].crafting_categories
	table.insert(categories, "basic-crafting")
	table.insert(categories, "basic-crafting-0")
	table.insert(categories, "crafting-0")
end

-- Revert AAI mining time changes because the ratio is not 1:1 in IR2
for _, name in pairs{"coal", "copper-ore", "iron-ore", "stone"} do
	data.raw.resource[name].mining_time = 1
end
