local util = require("data-util")

local function remove_from_tech(tech, category, unlocks)
	for _,unlock in pairs(unlocks) do
		DIR.technologies[tech][category] = DIR.remove_from_list(unlock, DIR.technologies[tech][category])
	end
end

local function add_new_minimal_tech(name, unlocks, prerequisites)
	DIR.add_new_minimal_tech(name, "", false, unlocks, prerequisites or {})
	DIR.disable_recipes(unlocks)
end

DIR.vanilla_techs["toolbelt"] = false -- Fix toolbelt technology costs being removed by IR2

-- Lock steam items behind research
util.tech_lock_recipes("automation", {"pipe-inserter", "long-handed-pipe-inserter"})

add_new_minimal_tech("basic-fluid-handling", {"copper-pipe", "copper-pipe-to-ground", "copper-pump", "copper-valve"})
data.raw.technology["basic-fluid-handling"].icons = {
	{
		icon = "__IndustrialRevolution__/graphics/entities/pipes/pipe-copper-vs.png",
		scale = 0.8,
		shift = {-22, -4},
		icon_size = 120,
	},
	{
		icon = "__IndustrialRevolution__/graphics/icons/64/water.png",
		scale = 0.5,
		shift = {32, 24},
		icon_size = 64,
		icon_mimaps = 4,
	}
}

add_new_minimal_tech("steam-handling", {"copper-boiler", "steam-pipe", "steam-pipe-to-ground", "steam-valve", "small-tank-steam"})
data.raw.technology["steam-handling"].icons = {
	{
		icon = "__IndustrialRevolution__/graphics/entities/pipes/pipe-steam-vs.png",
		scale = 0.8,
		shift = {-24, -4},
		icon_size = 120,
	},
	{
		icon = "__IndustrialRevolution__/graphics/icons/64/steam.png",
		scale = 0.5,
		shift = {32, 24},
		icon_size = 64,
		icon_mimaps = 4,
	}
}

add_new_minimal_tech("steam-mining", {"steam-drill"})
data.raw.technology["steam-mining"].icons = {
	{
		icon = "__IndustrialRevolution__/graphics/icons/256/electric-mining-drill.png",
		icon_mimaps = 4,
		icon_size = 256,
		tint = {r = 0.8, g = 0.38, b = 0.29, a = 1},
	},
	{
		icon = "__IndustrialRevolution__/graphics/icons/64/steam.png",
		icon_mimaps = 4,
		icon_size = 64,
		scale = 1.75,
		shift = {-84, -84},
	},
}

add_new_minimal_tech("steam-research", {"copper-lab"})
data.raw.technology["steam-research"].icons = {
	{
		icon = "__IndustrialRevolution__/graphics/entities/machines/labs/copper-lab-base.png",
		icon_size = 238,
	},
	{
		icon = "__IndustrialRevolution__/graphics/entities/machines/labs/copper-lab-orrery.png",
		shift = {0, -46},
		icon_size = 192,
	},
	{
		icon = "__IndustrialRevolution__/graphics/entities/pipes/pipe-steam-cs.png",
		shift = {-30, 63},
		icon_size = 120,
	},
}

-- Remove copper-cable and small-electric-pole from ir2-steam-power (they are in AAII electricity)
DIR.technologies["ir2-steam-power"].unlocks.copper = DIR.remove_from_list("cable", DIR.technologies["ir2-steam-power"].unlocks.copper)
remove_from_tech("ir2-steam-power", "machines", {"small-electric-pole", "small-bronze-pole", "small-iron-pole"})

-- Electricity technology will be re-created by IR2
DIR.technologies.electricity = {
	machines = {"burner-turbine"},
	unlocks = {
		["copper"] = {"cable"},
	},
	additional_unlocks = {"small-electric-pole", "small-bronze-pole", "small-iron-pole"},
	icon = "", -- icon will be fixed in data-updates
	packs = {"automation", "logistics"},
	prerequisites = {"ir2-iron-milestone"},
}
if settings.startup["aai-fuel-processor"].value then
	table.insert(DIR.technologies.electricity.prerequisites, "fuel-processing")
end

-- Move offshore pump to ir2-stem-power which creates a big mess in the technology tree
-- This is to allow electric motors in offshore pumps
remove_from_tech("ir2-iron-milestone", "additional_unlocks", {"offshore-pump"})
table.insert(DIR.technologies["ir2-steam-power"].additional_unlocks, "offshore-pump")
DIR.technologies["ir2-electronics-1"].prerequisites = {"electricity"}
DIR.technologies["ir2-furnaces-2"].prerequisites = {"electricity"}
DIR.technologies["ir2-mining-1"].prerequisites = {"electricity"}

-- Make ir2-iron-motor a backbone technology to be able to adjust its prerequisites
DIR.technologies["ir2-iron-motor"] = {
	machines = {},
	unlocks = {},
	additional_unlocks = {"iron-motor"},
	icon = "iron-motor",
	packs = {"automation", "logistics"},
	prerequisites = {"electricity"},
}

-- Adjust technology costs
DIR.technology_costs = {10, 20, 30, 35, 40, 50, 75, 100, 125, 150, 175, 200, 225, 250, 300, 350, 400, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000}
