if not script.active_mods.IndustrialRevolution then
	return {
		prepare = function() end,
		get = function() end,
	}
end

local util = require("util")
local steam_kit = require("__IndustrialRevolution__/code/data/kits").kits.stone
local starting_items = {}

return {
	prepare = function()
		local kits = {
			burner = {
				["burner-assembling-machine"] = 6,
				["burner-inserter"] = 32,
				["burner-mining-drill"] = 12,
				["burner-lab"] = 4,
				["stone-furnace"] = 12,
				
				-- basic_weapons
				["shotgun"] = 1,
				["shotgun-shell"] = 50,
				
				-- basic_resources, modified
				["wood"] = 100,
				["rubber-wood"] = 50,
				["coal"] = 300,
				["copper-ingot"] = 150,
				["tin-ingot"] = 250,
				["stone-brick"] = 250,
				
				-- basic_building
				["burner-generator-equipment"] = 1,
				["copper-roboport-equipment"] = 1,
				["light-armor"] = 1,
				["steambot"] = 10,
				
				-- basic_belts
				["transport-belt"] = 300,
				["underground-belt"] = 50,
				["splitter"] = 20,
			},
			steam = steam_kit,
		}
		
		local age = settings.global["ir2-starting-age"].value
		if settings.global["ir2-starting-kit"].value and kits[age] then
			remote.call("ir2-world", "set-crate-items", kits[age])
		end
		
		if remote.interfaces["freeplay"] then
			local crash_sequence = settings.global["crash-sequence"].value
			
			starting_items = remote.call("freeplay", "get_created_items")
			for k,v in pairs(remote.call("ir2-world", "get-crate-items")) do
				starting_items[k] = v
			end
			remote.call("freeplay", "set_created_items", {})
			remote.call("ir2-world", "set-crate-items", crash_sequence and {} or starting_items)
			
			if crash_sequence then
				remote.call("freeplay", "set_disable_crashsite", false)
				remote.call("freeplay", "set_debris_items", {["tin-plate"] = 8})
				remote.call("freeplay", "set_ship_items", {})
			end
		end
	end,
	get = function(container)
		for item_type, item_count in pairs(starting_items) do
			util.signal_container_add(container, {type="item", name=item_type}, item_count)
		end
	end,
}
