local arty40 = {
  name = "arty40",
  center = {x = 0, y = 0},
  force_name = "conquest",
  entities = { -- not blueprintable
    ["car"] = {
      {x = 6, y = 5, orientation = 0.225}
    },
    ["tank"] = {
      {x = 19, y = 0, orientation = 0.75},
      {x = 19, y = 2, orientation = 0.75},
    },
  },
  clear_entity_areas = {
    {{-29,-22},{32,22}},
  },
  clear_decorative_areas = {
    {{-29,-22},{32,22}},
  },
  prebuild = function(surface, ruin_position, ruin)
    local conquest_force = game.forces["conquest"]
    util.safe_research_tech(conquest_force, "artillery")
    util.safe_research_tech(conquest_force, "tank")
    util.safe_research_tech(conquest_force, "radar")
    util.safe_research_tech(conquest_force, "kr-radar")
    util.safe_research_tech(conquest_force, "electronics")
    util.safe_research_tech(conquest_force, "sulfur-processing")
    util.safe_research_tech(conquest_force, "explosives")
    util.safe_research_tech(conquest_force, "electricity")
    util.safe_research_tech(conquest_force, "fuel-processing")

    for i=1,10 do -- Works even for the infinite tech (lvl10)
      util.safe_research_tech(conquest_force, "worker-robots-speed-"..i)
    end
    for i=1,3 do
      util.safe_research_tech(conquest_force, "worker-robots-storage-"..i)
    end
    for i=1,7 do
      util.safe_research_tech(conquest_force, "laser-shooting-speed-"..i)
    end
    for i=1,10 do
      util.safe_research_tech(conquest_force, "energy-weapons-damage-"..i)
    end
    for i=1,6 do
      util.safe_research_tech(conquest_force, "artillery-shell-range-"..i)
      util.safe_research_tech(conquest_force, "artillery-shell-speed-"..i)
    end
  end,
  postbuild = function(surface, ruin_position, ruin)
    local ruin_position_center_offset = Util.vectors_delta(ruin.center, ruin_position)
    local area = Util.area_add_position({{-29,-22},{32,22}}, ruin_position_center_offset)
    local entities = surface.find_entities_filtered{name="logistic-chest-storage", area = area}
    local arcospheres_to_add = 8
    local zone = Zone.from_surface(surface)
    if zone and zone.looted_items and zone.looted_items["se-arcosphere"] then
      arcospheres_to_add = arcospheres_to_add - zone.looted_items["se-arcosphere"]
    end
    if arcospheres_to_add > 0 then
      for i = 1, arcospheres_to_add do
        entities[math.random(1, #entities)].insert({name="se-arcosphere", count=1})
      end
    end
    local entities = surface.find_entities(area)
    for _, entity in pairs(entities) do
      if entity.name == "logistic-chest-storage" then
        local r = math.random(1,10)
        if r == 1 then
          entity.insert({name="coal", count=10000})
        elseif r == 2 then
          entity.insert({name="iron-ore", count=10000})
        elseif r == 3 then
          entity.insert({name="copper-ore", count=10000})
        elseif r == 4 then
          entity.insert({name="stone", count=10000})
        elseif r == 5 then
          entity.insert({name="wood", count=10000})
        elseif r == 6 then
          entity.insert({name="processed-fuel", count=10000})
        elseif r == 7 then
          entity.insert({name="iron-plate", count=10000})
        elseif r == 8 then
          entity.insert({name="copper-plate", count=10000})
        elseif r == 9 then
          entity.insert({name="stone-brick", count=10000})
        elseif r == 10 then
          entity.insert({name="plastic-bar", count=10000})
        end
      end
      if entity.type == "accumulator" then
        entity.energy = 1000000000
      end
      if entity.name == "roboport" then
        entity.backer_name = "ARTY40"
        entity.insert({name="repair-pack", count=100})
        entity.insert({name="logistic-robot", count=100})
        entity.insert({name="construction-robot", count=100})
      end
      if entity.type == "burner-generator" then
        entity.insert({name="processed-fuel", count=10000})
      end
      if entity.name == "artillery-turret" then
        entity.insert({name="artillery-shell", count=10})
      end
      if entity.type == "car" then
        entity.insert({name="processed-fuel", count=50})
      end
    end
    local petrol_tank =  surface.find_entity("storage-tank", Util.vectors_add(ruin_position_center_offset, {x = 11, y = 1}))
    petrol_tank.fluidbox[1] = {name = "petroleum-gas", amount = 15000}
  end,
  on_nth_tick_3600 = function(ruin, ruin_location, surface)
    local ruin_position_center_offset = Util.vectors_delta(ruin.center, ruin_location.position)
    local petrol_tank =  surface.find_entity("storage-tank", Util.vectors_add(ruin_position_center_offset, {x = 11, y = 1}))
    if petrol_tank and petrol_tank.valid and petrol_tank.force.name == "conquest" then petrol_tank.fluidbox[1] = {name = "petroleum-gas", amount = 5000} end
    local buffers = surface.find_entities_filtered{name="logistic-chest-buffer", force="conquest"}
    for _, buffer in pairs(buffers) do
      local request = buffer.get_request_slot(1)
      local inv = buffer.get_inventory(defines.inventory.chest)
      if inv.is_empty() then
        buffer.insert(request)
      end
    end
    local burners = surface.find_entities_filtered{name="burner-turbine-generator", force="conquest"}
    for _, burner in pairs(burners) do burner.insert({name = "processed-fuel", count = 500}) end
    local accumulators = surface.find_entities_filtered{type="accumulator", force="conquest"}
    for _, accumulator in pairs(accumulators) do accumulator.energy = 1000000000 end
  end,
  tiles = {
    ["water-shallow"] = {{-42,3}, {-42,4}, {-42,5}, {-42,6}, {-41,3}, {-41,4}, {-41,5}, {-41,6}, {-41,7}, {-40,4}, {-40,5}, {-40,6}, {-40,8}, {-40,9}, {-39,1}, {-39,2}, {-39,3}, {-39,4}, {-39,5}, {-39,6}, {-39,7}, {-39,8}, {-39,9}, {-39,10}, {-38,-3}, {-38,-2}, {-38,-1}, {-38,0}, {-38,1}, {-38,7}, {-38,8}, {-38,9}, {-38,10}, {-37,-3}, {-37,-2}, {-37,-1}, {-37,0}, {-37,1}, {-37,8}, {-37,9}, {-37,10}, {-37,11}, {-37,12}, {-37,13}, {-36,-5}, {-36,-4}, {-36,-3}, {-36,-2}, {-36,12}, {-36,13}, {-36,14}, {-35,-5}, {-35,-4}, {-35,-3}, {-35,12}, {-35,13}, {-35,14}, {-35,15}, {-34,-6}, {-34,-5}, {-34,-4}, {-34,13}, {-34,14}, {-34,15}, {-34,16}, {-33,-7}, {-33,-6}, {-33,-5}, {-33,-4}, {-33,15}, {-33,16}, {-32,-7}, {-32,-6}, {-32,-5}, {-32,16}, {-32,18}, {-31,-7}, {-31,-6}, {-31,17}, {-31,18}, {-31,19}, {-30,-9}, {-30,-8}, {-30,-7}, {-30,-6}, {-30,17}, {-30,18}, {-30,19}, {-29,18}, {-29,19}, {-29,20}, {-28,-10}, {-28,18}, {-28,19}, {-28,20}, {-27,-11}, {-27,-10}, {-27,19}, {-27,20}, {-26,-11}, {-26,20}, {-26,22}, {-25,-13}, {-25,-12}, {-25,19}, {-25,20}, {-25,22}, {-24,-14}, {-24,-13}, {-24,20}, {-24,21}, {-24,22}, {-23,-16}, {-23,-15}, {-23,-14}, {-23,21}, {-23,22}, {-22,-17}, {-22,-16}, {-22,-15}, {-22,22}, {-22,23}, {-22,24}, {-21,-18}, {-21,-17}, {-21,22}, {-21,23}, {-21,24}, {-20,-19}, {-20,-18}, {-20,22}, {-20,23}, {-19,-21}, {-19,-20}, {-19,-19}, {-19,21}, {-19,22}, {-19,23}, {-18,-21}, {-18,-20}, {-18,21}, {-18,22}, {-17,-22}, {-17,-21}, {-17,-20}, {-17,-19}, {-17,21}, {-16,-23}, {-16,-21}, {-16,-20}, {-15,-23}, {-15,-22}, {-15,-21}, {-15,21}, {-14,-23}, {-14,-22}, {-14,-21}, {-14,21}, {-13,-22}, {-13,-21}, {-13,21}, {-12,-24}, {-12,-23}, {-12,-22}, {-12,21}, {-11,-23}, {-11,-22}, {-11,-21}, {-10,-23}, {-10,-22}, {-9,-23}, {-9,-22}, {-8,-23}, {-8,-22}, {-8,24}, {-7,-24}, {-7,-23}, {-7,-22}, {-7,23}, {-7,24}, {-7,25}, {-6,-22}, {-6,-21}, {-6,23}, {-6,24}, {-6,25}, {-5,-21}, {-5,25}, {-5,26}, {-5,27}, {-4,-22}, {-4,-21}, {-4,26}, {-4,27}, {-3,-21}, {-3,-20}, {-3,26}, {-3,27}, {-3,28}, {-2,-20}, {-2,27}, {-2,28}, {-1,-20}, {-1,-19}, {-1,28}, {-1,29}, {0,-18}, {0,-17}, {0,-16}, {0,28}, {0,29}, {1,-18}, {1,-17}, {1,-16}, {1,-15}, {1,28}, {2,-16}, {2,-15}, {2,-14}, {2,-13}, {3,-14}, {3,-13}, {3,-12}, {3,28}, {4,-14}, {4,-13}, {4,-12}, {4,-11}, {4,28}, {5,-12}, {5,-11}, {5,25}, {5,26}, {5,27}, {6,-12}, {6,-11}, {6,25}, {6,26}, {7,-23}, {7,-22}, {7,-21}, {7,-12}, {7,-11}, {7,-10}, {7,25}, {7,26}, {7,27}, {8,-23}, {8,-22}, {8,-21}, {8,-11}, {8,-10}, {8,-9}, {8,25}, {8,26}, {8,27}, {9,-25}, {9,-24}, {9,-21}, {9,-19}, {9,-18}, {9,-11}, {9,-10}, {9,-9}, {9,26}, {9,27}, {10,-26}, {10,-25}, {10,-24}, {10,-18}, {10,-17}, {10,-8}, {10,27}, {11,-27}, {11,-26}, {11,-25}, {11,-22}, {11,-21}, {11,-20}, {11,-17}, {11,-8}, {11,-7}, {11,28}, {12,-28}, {12,-27}, {12,-26}, {12,-20}, {12,-19}, {12,-16}, {12,28}, {13,-28}, {13,-27}, {13,-16}, {13,28}, {13,29}, {14,-29}, {14,-28}, {14,-27}, {14,-15}, {14,29}, {14,30}, {15,-30}, {15,-29}, {15,-15}, {15,29}, {15,30}, {16,-31}, {16,-30}, {16,28}, {16,30}, {17,-31}, {17,-30}, {17,27}, {17,28}, {17,29}, {17,30}, {18,-30}, {18,27}, {18,28}, {18,29}, {19,-30}, {19,26}, {19,27}, {19,28}, {19,29}, {20,-30}, {20,27}, {20,28}, {21,-30}, {21,-29}, {21,26}, {21,27}, {21,28}, {22,-30}, {22,-29}, {22,27}, {23,27}, {24,-28}, {24,25}, {24,26}, {25,-28}, {25,24}, {25,25}, {26,-29}, {26,-28}, {26,-27}, {27,-29}, {27,-28}, {27,-27}, {28,-27}, {28,-26}, {29,-26}, {29,-25}, {30,-26}, {31,-26}, {31,-25}, {31,-24}, {31,-23}, {31,20}, {31,21}, {31,22}, {31,23}, {32,-25}, {32,-24}, {32,-23}, {32,-22}, {32,19}, {32,20}, {32,21}, {32,22}, {33,-24}, {33,-23}, {33,-22}, {33,-21}, {33,16}, {33,17}, {33,18}, {33,19}, {33,20}, {33,21}, {33,22}, {34,-23}, {34,-22}, {34,-20}, {34,-19}, {34,14}, {34,15}, {34,16}, {34,17}, {34,18}, {34,19}, {34,20}, {34,21}, {35,-22}, {35,-20}, {35,13}, {35,14}, {35,15}, {35,16}, {35,17}, {35,18}, {35,19}, {36,-20}, {36,-19}, {36,7}, {36,8}, {36,10}, {36,11}, {36,12}, {36,13}, {36,14}, {36,15}, {36,16}, {36,18}, {37,-20}, {37,-19}, {37,-18}, {37,-17}, {37,6}, {37,7}, {37,8}, {37,9}, {37,10}, {37,11}, {37,12}, {37,13}, {37,14}, {38,-19}, {38,-16}, {38,-15}, {38,-14}, {38,-13}, {38,-12}, {38,-11}, {38,-10}, {38,-9}, {38,5}, {38,6}, {38,7}, {38,8}, {38,9}, {38,10}, {38,11}, {38,12}, {38,13}, {39,-18}, {39,-17}, {39,-12}, {39,-11}, {39,-10}, {39,-9}, {39,4}, {39,5}, {39,6}, {39,7}, {39,8}, {39,9}, {39,10}, {39,11}, {40,-17}, {40,-16}, {40,-15}, {40,-14}, {40,-13}, {40,-12}, {40,-11}, {40,-10}, {40,-9}, {40,-4}, {40,-3}, {40,-2}, {40,-1}, {40,0}, {40,4}, {40,5}, {40,6}, {40,7}, {40,8}, {40,9}, {41,-13}, {41,-12}, {41,-11}, {41,-10}, {41,-8}, {41,-7}, {41,-6}, {41,-5}, {41,-4}, {41,-2}, {41,-1}, {41,0}, {41,1}, {41,2}, {41,3}, {41,4}, {41,5}, {41,6}, {42,-6}, {42,-5}, {42,-4}, {42,-3}, {42,-2}, {42,-1}, {42,0}, {42,1}, {42,2}, {42,3}, {42,4}, {42,5}, {43,-4}, {43,-3}, {43,-2}, {43,-1}, {43,0}, {43,1}, {43,2}, {43,4}, },
    ["mineral-beige-dirt-4"] = {{-42,11}, {-42,12}, {-41,2}, {-41,9}, {-41,10}, {-41,11}, {-41,12}, {-41,13}, {-41,14}, {-40,0}, {-40,1}, {-40,2}, {-40,3}, {-40,10}, {-40,11}, {-40,12}, {-40,13}, {-40,14}, {-39,-2}, {-39,-1}, {-39,0}, {-39,11}, {-39,12}, {-39,13}, {-37,-5}, {-37,-4}, {-35,16}, {-35,17}, {-35,18}, {-34,17}, {-34,18}, {-34,19}, {-33,17}, {-33,18}, {-33,19}, {-33,20}, {-32,17}, {-32,19}, {-32,20}, {-32,21}, {-31,20}, {-30,20}, {-19,24}, {-18,23}, {-18,24}, {-17,22}, {-17,23}, {-9,26}, {-8,26}, {-7,26}, {-6,-24}, {-6,-23}, {-6,26}, {-6,27}, {-6,28}, {-5,-23}, {-5,28}, {-5,29}, {-5,30}, {-4,-26}, {-4,-23}, {-4,28}, {-4,29}, {-4,30}, {-3,-26}, {-3,-25}, {-3,-22}, {-3,29}, {-2,-28}, {-2,-27}, {-2,-26}, {-1,-27}, {-1,-26}, {0,-27}, {0,-26}, {0,-25}, {0,-20}, {1,-28}, {1,-27}, {1,-25}, {1,-19}, {2,-27}, {2,-23}, {2,-22}, {2,-18}, {2,-17}, {3,-27}, {3,-24}, {3,-17}, {3,-16}, {3,-15}, {4,-16}, {4,-15}, {5,-15}, {5,-14}, {5,-13}, {6,-28}, {6,-27}, {6,-26}, {6,-25}, {6,-24}, {6,-23}, {6,-22}, {6,-21}, {6,-20}, {6,-19}, {6,-14}, {6,-13}, {7,-26}, {7,-25}, {7,-24}, {7,-19}, {7,-18}, {7,-13}, {8,-26}, {8,-25}, {8,-19}, {8,-18}, {8,-17}, {8,-12}, {9,-26}, {9,-17}, {9,-12}, {10,-16}, {10,-11}, {10,-10}, {11,-31}, {11,-30}, {11,-16}, {11,-10}, {11,-9}, {12,-31}, {12,-30}, {12,-29}, {12,-15}, {12,-10}, {12,-9}, {12,-8}, {12,-7}, {12,-6}, {13,-31}, {13,-30}, {13,-29}, {13,-15}, {13,-14}, {13,-6}, {14,-32}, {14,-31}, {14,-30}, {14,-14}, {14,-13}, {15,-31}, {15,-13}, {15,-12}, {15,31}, {15,32}, {16,-13}, {16,-12}, {16,-11}, {16,-10}, {16,-9}, {16,-8}, {16,31}, {16,32}, {17,-10}, {17,-9}, {17,-8}, {17,-7}, {17,-6}, {17,31}, {17,32}, {18,-8}, {18,-7}, {18,31}, {18,32}, {19,31}, {20,29}, {20,30}, {20,31}, {21,29}, {21,30}, {21,31}, {27,-30}, {28,-30}, {28,-29}, {28,-28}, {29,-30}, {29,-29}, {29,-28}, {29,-27}, {30,-29}, {30,-28}, {30,-27}, {35,-24}, {35,-23}, {36,-23}, {36,-22}, {36,-21}, {36,17}, {36,19}, {36,20}, {37,-21}, {37,15}, {37,16}, {37,17}, {37,18}, {37,19}, {38,14}, {38,15}, {38,16}, {38,17}, {38,18}, {39,12}, {39,13}, {39,14}, {39,15}, {39,16}, {40,10}, {40,13}, {40,14}, {41,-9}, {41,7}, {41,8}, {41,9}, {41,10}, {41,11}, {41,12}, {42,-9}, {42,-8}, {42,-7}, {42,6}, {42,7}, {42,8}, {43,-8}, {43,-7}, {43,-6}, {43,-5}, {44,-8}, {44,-7}, {44,-6}, {44,-5}, {44,-4}, {44,-3}, {44,-2}, {44,-1}, {45,-5}, {45,-4}, {45,-3}, },
    ["water"] = {{-38,2}, {-38,3}, {-38,4}, {-38,5}, {-38,6}, {-37,2}, {-37,3}, {-37,4}, {-37,5}, {-37,6}, {-37,7}, {-36,-1}, {-36,0}, {-36,1}, {-36,2}, {-36,3}, {-36,4}, {-36,5}, {-36,6}, {-36,7}, {-36,8}, {-36,9}, {-36,10}, {-36,11}, {-35,-2}, {-35,-1}, {-35,0}, {-35,3}, {-35,4}, {-35,5}, {-35,6}, {-35,11}, {-34,-3}, {-34,-2}, {-34,-1}, {-33,-3}, {-33,-2}, {-33,13}, {-33,14}, {-32,-4}, {-32,-3}, {-32,-2}, {-32,-1}, {-32,14}, {-31,-5}, {-31,-4}, {-31,-3}, {-31,-2}, {-30,-5}, {-30,-4}, {-30,16}, {-29,-7}, {-29,-6}, {-29,-5}, {-29,-4}, {-29,15}, {-29,16}, {-29,17}, {-28,-9}, {-28,-8}, {-28,-7}, {-28,-6}, {-28,-5}, {-28,16}, {-28,17}, {-27,-9}, {-27,-8}, {-27,-7}, {-27,17}, {-27,18}, {-26,-10}, {-26,-9}, {-26,-8}, {-26,-7}, {-26,17}, {-26,18}, {-26,19}, {-25,-10}, {-25,-9}, {-25,-8}, {-25,17}, {-25,18}, {-24,-11}, {-24,-10}, {-24,-9}, {-24,17}, {-24,18}, {-24,19}, {-23,-13}, {-23,-12}, {-23,-11}, {-23,-10}, {-23,17}, {-23,18}, {-23,19}, {-23,20}, {-22,-14}, {-22,-13}, {-22,-12}, {-22,-11}, {-22,-10}, {-22,-9}, {-22,18}, {-22,19}, {-22,20}, {-22,21}, {-21,-16}, {-21,-15}, {-21,-14}, {-21,-13}, {-21,-12}, {-21,-11}, {-21,-10}, {-21,-9}, {-21,19}, {-21,20}, {-21,21}, {-20,-17}, {-20,-16}, {-20,-15}, {-20,-14}, {-20,-11}, {-20,-10}, {-20,-9}, {-20,18}, {-20,19}, {-20,20}, {-20,21}, {-19,-18}, {-19,-17}, {-19,-16}, {-19,-10}, {-19,19}, {-19,20}, {-18,-19}, {-18,-18}, {-18,-17}, {-18,20}, {-17,-18}, {-17,-17}, {-17,19}, {-17,20}, {-16,-22}, {-16,-19}, {-16,-18}, {-16,18}, {-16,19}, {-16,20}, {-15,-20}, {-15,-19}, {-15,18}, {-15,19}, {-15,20}, {-14,-20}, {-14,18}, {-14,19}, {-14,20}, {-13,18}, {-13,19}, {-13,20}, {-12,-21}, {-12,-20}, {-12,18}, {-12,19}, {-12,20}, {-11,-20}, {-11,19}, {-11,20}, {-11,21}, {-11,22}, {-10,-21}, {-10,-20}, {-10,19}, {-10,20}, {-10,21}, {-10,22}, {-10,23}, {-9,-21}, {-9,-20}, {-9,20}, {-9,21}, {-9,22}, {-9,23}, {-8,-21}, {-8,-20}, {-8,-19}, {-8,21}, {-8,22}, {-8,23}, {-7,-21}, {-7,-20}, {-7,-19}, {-7,21}, {-7,22}, {-6,-20}, {-6,-19}, {-6,21}, {-6,22}, {-5,-22}, {-5,-20}, {-5,-19}, {-5,-18}, {-5,22}, {-5,23}, {-5,24}, {-4,-20}, {-4,-19}, {-4,-18}, {-4,21}, {-4,22}, {-4,23}, {-4,24}, {-4,25}, {-3,-19}, {-3,-18}, {-3,-17}, {-3,20}, {-3,21}, {-3,22}, {-3,23}, {-3,24}, {-3,25}, {-2,-19}, {-2,-18}, {-2,-17}, {-2,-16}, {-2,-15}, {-2,21}, {-2,22}, {-2,23}, {-2,24}, {-2,25}, {-2,26}, {-1,-18}, {-1,-17}, {-1,-16}, {-1,-15}, {-1,-14}, {-1,22}, {-1,23}, {-1,24}, {-1,25}, {-1,26}, {-1,27}, {0,-15}, {0,-14}, {0,-13}, {0,22}, {0,23}, {0,24}, {0,25}, {0,26}, {0,27}, {1,-14}, {1,-13}, {1,23}, {1,24}, {1,25}, {1,26}, {1,27}, {1,29}, {1,30}, {2,-12}, {2,23}, {2,24}, {2,25}, {2,26}, {2,27}, {2,28}, {2,29}, {3,-11}, {3,22}, {3,23}, {3,24}, {3,25}, {3,26}, {3,27}, {4,21}, {4,22}, {4,23}, {4,24}, {4,25}, {4,26}, {5,-10}, {5,22}, {5,23}, {5,24}, {6,-10}, {6,23}, {6,24}, {7,-20}, {7,23}, {7,24}, {8,-20}, {8,24}, {9,-23}, {9,-22}, {9,-20}, {9,24}, {9,25}, {10,-23}, {10,-22}, {10,-21}, {10,-20}, {10,-19}, {10,25}, {10,26}, {11,-24}, {11,-23}, {11,-19}, {11,-18}, {11,26}, {11,27}, {12,-25}, {12,-24}, {12,-23}, {12,-22}, {12,-21}, {12,-18}, {12,-17}, {12,26}, {12,27}, {12,29}, {13,-26}, {13,-25}, {13,-24}, {13,-23}, {13,-22}, {13,-21}, {13,27}, {14,-26}, {14,-25}, {14,-24}, {14,-23}, {14,-22}, {14,27}, {14,28}, {15,-28}, {15,-27}, {15,-26}, {15,-25}, {15,-24}, {15,-23}, {15,27}, {15,28}, {16,-29}, {16,-28}, {16,-27}, {16,-26}, {16,-25}, {16,-24}, {16,-23}, {16,-22}, {16,26}, {16,27}, {16,29}, {17,-29}, {17,-28}, {17,-27}, {17,-26}, {17,-25}, {17,-24}, {17,-23}, {17,26}, {18,-29}, {18,-28}, {18,-27}, {18,-26}, {18,-25}, {18,-24}, {18,25}, {18,26}, {18,30}, {19,-29}, {19,-28}, {19,-27}, {19,-26}, {19,-25}, {19,-24}, {19,25}, {19,30}, {20,-29}, {20,-28}, {20,-27}, {20,-26}, {20,-25}, {20,-24}, {20,25}, {20,26}, {21,-28}, {21,-27}, {21,-26}, {21,-25}, {21,-24}, {21,22}, {21,23}, {21,24}, {21,25}, {22,-28}, {22,-27}, {22,-26}, {22,-25}, {22,-24}, {22,17}, {22,18}, {22,19}, {22,20}, {22,21}, {22,22}, {22,23}, {22,24}, {22,25}, {22,26}, {23,-29}, {23,-28}, {23,-27}, {23,-26}, {23,-25}, {23,-24}, {23,15}, {23,16}, {23,17}, {23,18}, {23,19}, {23,20}, {23,21}, {23,22}, {23,23}, {23,24}, {23,25}, {23,26}, {24,-29}, {24,-27}, {24,-26}, {24,-25}, {24,-24}, {24,14}, {24,15}, {24,16}, {24,17}, {24,18}, {24,19}, {24,20}, {24,21}, {24,22}, {24,23}, {24,24}, {25,-27}, {25,-26}, {25,-25}, {25,12}, {25,13}, {25,14}, {25,15}, {25,16}, {25,17}, {25,18}, {25,19}, {25,20}, {25,21}, {25,22}, {25,23}, {26,-26}, {26,-25}, {26,-24}, {26,11}, {26,12}, {26,13}, {26,14}, {26,15}, {26,16}, {26,17}, {26,18}, {26,19}, {26,20}, {26,21}, {26,22}, {26,23}, {26,24}, {27,-26}, {27,-25}, {27,-24}, {27,11}, {27,12}, {27,13}, {27,14}, {27,15}, {27,16}, {27,17}, {27,18}, {27,19}, {27,20}, {27,21}, {27,22}, {27,23}, {27,24}, {27,25}, {28,-25}, {28,-24}, {28,-23}, {28,11}, {28,12}, {28,13}, {28,14}, {28,15}, {28,16}, {28,17}, {28,18}, {28,19}, {28,20}, {28,21}, {28,22}, {28,23}, {28,24}, {29,-24}, {29,-23}, {29,-22}, {29,11}, {29,12}, {29,13}, {29,14}, {29,15}, {29,16}, {29,17}, {29,18}, {29,19}, {29,20}, {29,21}, {29,22}, {29,23}, {30,-25}, {30,-24}, {30,-23}, {30,-22}, {30,-21}, {30,12}, {30,13}, {30,14}, {30,15}, {30,16}, {30,17}, {30,18}, {30,19}, {30,20}, {30,21}, {30,22}, {31,-22}, {31,-21}, {31,-20}, {31,-19}, {31,-18}, {31,-15}, {31,-14}, {31,-13}, {31,9}, {31,10}, {31,11}, {31,12}, {31,13}, {31,14}, {31,15}, {31,16}, {31,17}, {31,18}, {31,19}, {32,-21}, {32,-20}, {32,-19}, {32,-18}, {32,-17}, {32,-16}, {32,-15}, {32,-14}, {32,-13}, {32,-12}, {32,-11}, {32,-8}, {32,-7}, {32,-6}, {32,-5}, {32,-4}, {32,-3}, {32,7}, {32,8}, {32,9}, {32,10}, {32,11}, {32,12}, {32,13}, {32,14}, {32,15}, {32,16}, {32,17}, {32,18}, {33,-20}, {33,-19}, {33,-18}, {33,-17}, {33,-16}, {33,-15}, {33,-14}, {33,-13}, {33,-12}, {33,-11}, {33,-10}, {33,-9}, {33,-8}, {33,-7}, {33,-6}, {33,-5}, {33,-4}, {33,-3}, {33,-2}, {33,-1}, {33,0}, {33,1}, {33,2}, {33,3}, {33,4}, {33,5}, {33,6}, {33,7}, {33,8}, {33,9}, {33,10}, {33,11}, {33,12}, {33,13}, {33,14}, {33,15}, {34,-21}, {34,-18}, {34,-17}, {34,-16}, {34,-15}, {34,-14}, {34,-13}, {34,-12}, {34,-11}, {34,-10}, {34,-9}, {34,-8}, {34,-7}, {34,-6}, {34,-5}, {34,-4}, {34,-3}, {34,-2}, {34,-1}, {34,0}, {34,1}, {34,2}, {34,3}, {34,4}, {34,5}, {34,6}, {34,7}, {34,8}, {34,9}, {34,10}, {34,11}, {34,12}, {34,13}, {35,-21}, {35,-19}, {35,-18}, {35,-17}, {35,-16}, {35,-15}, {35,-14}, {35,-13}, {35,-12}, {35,-11}, {35,-10}, {35,-9}, {35,-8}, {35,-7}, {35,-6}, {35,-5}, {35,-4}, {35,-3}, {35,-2}, {35,-1}, {35,0}, {35,1}, {35,2}, {35,3}, {35,4}, {35,5}, {35,6}, {35,7}, {35,8}, {35,9}, {35,10}, {35,11}, {35,12}, {36,-18}, {36,-17}, {36,-16}, {36,-15}, {36,-14}, {36,-13}, {36,-12}, {36,-11}, {36,-10}, {36,-9}, {36,-8}, {36,-7}, {36,-6}, {36,-5}, {36,-4}, {36,-3}, {36,-2}, {36,-1}, {36,0}, {36,1}, {36,2}, {36,3}, {36,4}, {36,5}, {36,6}, {36,9}, {37,-16}, {37,-15}, {37,-14}, {37,-13}, {37,-12}, {37,-11}, {37,-10}, {37,-9}, {37,-8}, {37,-7}, {37,-6}, {37,-5}, {37,-4}, {37,-3}, {37,-2}, {37,-1}, {37,0}, {37,1}, {37,2}, {37,3}, {37,4}, {37,5}, {38,-18}, {38,-17}, {38,-8}, {38,-7}, {38,-6}, {38,-5}, {38,-4}, {38,-3}, {38,-2}, {38,-1}, {38,0}, {38,1}, {38,2}, {38,3}, {38,4}, {39,-16}, {39,-15}, {39,-14}, {39,-13}, {39,-8}, {39,-7}, {39,-6}, {39,-5}, {39,-4}, {39,-3}, {39,-2}, {39,-1}, {39,0}, {39,1}, {39,2}, {39,3}, {40,-8}, {40,-7}, {40,-6}, {40,-5}, {40,1}, {40,2}, {40,3}, {41,-3}, },
    ["deepwater"] = {{-35,1}, {-35,2}, {-35,7}, {-35,8}, {-35,9}, {-35,10}, {-34,0}, {-34,1}, {-34,2}, {-34,3}, {-34,4}, {-34,5}, {-34,6}, {-34,7}, {-34,8}, {-34,9}, {-34,10}, {-34,11}, {-34,12}, {-33,-1}, {-33,0}, {-33,1}, {-33,2}, {-33,3}, {-33,4}, {-33,5}, {-33,6}, {-33,7}, {-33,8}, {-33,9}, {-33,10}, {-33,11}, {-33,12}, {-32,0}, {-32,1}, {-32,2}, {-32,3}, {-32,4}, {-32,5}, {-32,6}, {-32,7}, {-32,8}, {-32,9}, {-32,10}, {-32,11}, {-32,12}, {-32,13}, {-32,15}, {-31,-1}, {-31,0}, {-31,1}, {-31,2}, {-31,3}, {-31,4}, {-31,5}, {-31,6}, {-31,7}, {-31,8}, {-31,9}, {-31,10}, {-31,11}, {-31,12}, {-31,13}, {-31,14}, {-31,15}, {-31,16}, {-30,-3}, {-30,-2}, {-30,-1}, {-30,0}, {-30,1}, {-30,2}, {-30,3}, {-30,4}, {-30,5}, {-30,6}, {-30,7}, {-30,8}, {-30,9}, {-30,10}, {-30,11}, {-30,12}, {-30,13}, {-30,14}, {-30,15}, {-29,-3}, {-29,-2}, {-29,-1}, {-29,0}, {-29,1}, {-29,2}, {-29,3}, {-29,4}, {-29,10}, {-29,11}, {-29,12}, {-29,13}, {-29,14}, {-28,-4}, {-28,-3}, {-28,-2}, {-28,-1}, {-28,0}, {-28,1}, {-28,2}, {-28,12}, {-28,13}, {-28,14}, {-28,15}, {-27,-6}, {-27,-5}, {-27,-4}, {-27,-3}, {-27,-2}, {-27,-1}, {-27,0}, {-27,14}, {-27,15}, {-27,16}, {-26,-6}, {-26,-5}, {-26,-4}, {-26,-3}, {-26,-2}, {-26,-1}, {-26,0}, {-26,14}, {-26,15}, {-26,16}, {-25,-7}, {-25,-6}, {-25,-5}, {-25,-4}, {-25,-3}, {-25,-2}, {-25,-1}, {-25,15}, {-25,16}, {-24,-8}, {-24,-7}, {-24,-6}, {-24,-5}, {-24,-4}, {-24,-3}, {-24,-2}, {-24,-1}, {-24,15}, {-24,16}, {-23,-9}, {-23,-8}, {-23,-7}, {-23,-6}, {-23,-5}, {-23,-4}, {-23,-3}, {-23,-2}, {-23,16}, {-22,-8}, {-22,-7}, {-22,-6}, {-22,-5}, {-22,-4}, {-22,-3}, {-22,-2}, {-22,16}, {-22,17}, {-21,-8}, {-21,-7}, {-21,-6}, {-21,-5}, {-21,-4}, {-21,-3}, {-21,-2}, {-21,16}, {-21,17}, {-21,18}, {-20,-13}, {-20,-12}, {-20,-8}, {-20,-7}, {-20,-6}, {-20,-5}, {-20,-4}, {-20,-3}, {-20,-2}, {-20,16}, {-20,17}, {-19,-15}, {-19,-14}, {-19,-13}, {-19,-12}, {-19,-11}, {-19,-9}, {-19,-8}, {-19,-7}, {-19,-6}, {-19,-5}, {-19,-4}, {-19,-3}, {-19,16}, {-19,17}, {-19,18}, {-18,-16}, {-18,-15}, {-18,-14}, {-18,-13}, {-18,-12}, {-18,-11}, {-18,-10}, {-18,-9}, {-18,-8}, {-18,-7}, {-18,-6}, {-18,-5}, {-18,-4}, {-18,-3}, {-18,15}, {-18,16}, {-18,17}, {-18,18}, {-18,19}, {-17,-16}, {-17,-15}, {-17,-14}, {-17,-13}, {-17,-12}, {-17,-11}, {-17,-10}, {-17,-9}, {-17,-8}, {-17,-7}, {-17,-6}, {-17,-5}, {-17,-4}, {-17,-3}, {-17,15}, {-17,16}, {-17,17}, {-17,18}, {-16,-17}, {-16,-16}, {-16,-15}, {-16,-14}, {-16,-13}, {-16,-12}, {-16,-11}, {-16,-10}, {-16,-9}, {-16,-8}, {-16,-7}, {-16,-6}, {-16,-5}, {-16,-4}, {-16,14}, {-16,15}, {-16,16}, {-16,17}, {-15,-18}, {-15,-17}, {-15,-16}, {-15,-15}, {-15,-14}, {-15,-13}, {-15,-12}, {-15,-11}, {-15,-10}, {-15,-9}, {-15,-8}, {-15,-7}, {-15,-6}, {-15,-5}, {-15,14}, {-15,15}, {-15,16}, {-15,17}, {-14,-19}, {-14,-18}, {-14,-17}, {-14,-16}, {-14,-15}, {-14,-14}, {-14,-13}, {-14,-12}, {-14,-11}, {-14,-10}, {-14,-9}, {-14,-8}, {-14,-7}, {-14,-6}, {-14,14}, {-14,15}, {-14,16}, {-14,17}, {-13,-20}, {-13,-19}, {-13,-18}, {-13,-17}, {-13,-16}, {-13,-15}, {-13,-14}, {-13,-10}, {-13,-9}, {-13,-8}, {-13,-7}, {-13,14}, {-13,15}, {-13,16}, {-13,17}, {-12,-19}, {-12,-18}, {-12,-17}, {-12,-16}, {-12,14}, {-12,15}, {-12,16}, {-12,17}, {-11,-19}, {-11,-18}, {-11,-17}, {-11,-16}, {-11,14}, {-11,15}, {-11,16}, {-11,17}, {-11,18}, {-10,-19}, {-10,-18}, {-10,-17}, {-10,14}, {-10,15}, {-10,16}, {-10,17}, {-10,18}, {-9,-19}, {-9,-18}, {-9,-17}, {-9,14}, {-9,15}, {-9,16}, {-9,17}, {-9,18}, {-9,19}, {-8,-18}, {-8,-17}, {-8,15}, {-8,16}, {-8,17}, {-8,18}, {-8,19}, {-8,20}, {-7,-18}, {-7,-17}, {-7,-16}, {-7,18}, {-7,19}, {-7,20}, {-6,-18}, {-6,-17}, {-6,-16}, {-6,18}, {-6,19}, {-6,20}, {-5,-17}, {-5,-16}, {-5,-15}, {-5,-14}, {-5,18}, {-5,19}, {-5,20}, {-5,21}, {-4,-17}, {-4,-16}, {-4,-15}, {-4,-14}, {-4,-13}, {-4,-12}, {-4,-11}, {-4,18}, {-4,19}, {-4,20}, {-3,-16}, {-3,-15}, {-3,-14}, {-3,-13}, {-3,-12}, {-3,-11}, {-3,18}, {-3,19}, {-2,-14}, {-2,-13}, {-2,-12}, {-2,-11}, {-2,-10}, {-2,-9}, {-2,18}, {-2,19}, {-2,20}, {-1,-13}, {-1,-12}, {-1,-11}, {-1,-10}, {-1,-9}, {-1,-8}, {-1,18}, {-1,19}, {-1,20}, {-1,21}, {0,-12}, {0,-11}, {0,-10}, {0,-9}, {0,-8}, {0,18}, {0,19}, {0,20}, {0,21}, {1,-12}, {1,-11}, {1,-10}, {1,-9}, {1,-8}, {1,18}, {1,19}, {1,20}, {1,21}, {1,22}, {2,-11}, {2,-10}, {2,-9}, {2,-8}, {2,18}, {2,19}, {2,20}, {2,21}, {2,22}, {3,-10}, {3,-9}, {3,-8}, {3,16}, {3,17}, {3,18}, {3,19}, {3,20}, {3,21}, {4,-10}, {4,-9}, {4,-8}, {4,16}, {4,17}, {4,18}, {4,19}, {4,20}, {5,-9}, {5,-8}, {5,16}, {5,17}, {5,18}, {5,19}, {5,20}, {5,21}, {6,-9}, {6,16}, {6,17}, {6,18}, {6,19}, {6,20}, {6,21}, {6,22}, {7,-9}, {7,16}, {7,17}, {7,18}, {7,19}, {7,20}, {7,21}, {7,22}, {8,16}, {8,17}, {8,18}, {8,19}, {8,20}, {8,21}, {8,22}, {8,23}, {9,-8}, {9,16}, {9,17}, {9,18}, {9,19}, {9,20}, {9,21}, {9,22}, {9,23}, {10,16}, {10,17}, {10,18}, {10,19}, {10,20}, {10,21}, {10,22}, {10,23}, {10,24}, {11,16}, {11,19}, {11,20}, {11,21}, {11,22}, {11,23}, {11,24}, {11,25}, {12,21}, {12,22}, {12,23}, {12,24}, {12,25}, {13,-20}, {13,-19}, {13,-18}, {13,-17}, {13,21}, {13,22}, {13,23}, {13,24}, {13,25}, {13,26}, {14,-21}, {14,-20}, {14,-19}, {14,-18}, {14,-17}, {14,-16}, {14,22}, {14,23}, {14,24}, {14,25}, {14,26}, {15,-22}, {15,-21}, {15,-20}, {15,-19}, {15,-18}, {15,-17}, {15,-16}, {15,22}, {15,23}, {15,24}, {15,25}, {15,26}, {16,-21}, {16,-20}, {16,-19}, {16,-18}, {16,-17}, {16,21}, {16,22}, {16,23}, {16,24}, {16,25}, {17,-22}, {17,-21}, {17,-20}, {17,-19}, {17,21}, {17,22}, {17,23}, {17,24}, {17,25}, {18,-23}, {18,-22}, {18,-21}, {18,-20}, {18,13}, {18,14}, {18,15}, {18,16}, {18,19}, {18,20}, {18,21}, {18,22}, {18,23}, {18,24}, {19,-23}, {19,-22}, {19,-21}, {19,12}, {19,13}, {19,14}, {19,15}, {19,16}, {19,17}, {19,18}, {19,19}, {19,20}, {19,21}, {19,22}, {19,23}, {19,24}, {20,-23}, {20,-22}, {20,-21}, {20,11}, {20,12}, {20,13}, {20,14}, {20,15}, {20,16}, {20,17}, {20,18}, {20,19}, {20,20}, {20,21}, {20,22}, {20,23}, {20,24}, {21,-23}, {21,-22}, {21,10}, {21,11}, {21,12}, {21,13}, {21,14}, {21,15}, {21,16}, {21,17}, {21,18}, {21,19}, {21,20}, {21,21}, {22,-23}, {22,-22}, {22,9}, {22,10}, {22,11}, {22,12}, {22,13}, {22,14}, {22,15}, {22,16}, {23,-23}, {23,-22}, {23,8}, {23,9}, {23,10}, {23,11}, {23,12}, {23,13}, {23,14}, {24,-23}, {24,-22}, {24,-21}, {24,7}, {24,8}, {24,9}, {24,10}, {24,11}, {24,12}, {24,13}, {25,-24}, {25,-23}, {25,-22}, {25,-21}, {25,-9}, {25,-8}, {25,-7}, {25,-6}, {25,-5}, {25,-4}, {25,-3}, {25,-2}, {25,-1}, {25,0}, {25,7}, {25,8}, {25,9}, {25,10}, {25,11}, {26,-23}, {26,-22}, {26,-21}, {26,-20}, {26,-10}, {26,-9}, {26,-8}, {26,-7}, {26,-6}, {26,-5}, {26,-4}, {26,-3}, {26,-2}, {26,-1}, {26,8}, {26,9}, {26,10}, {27,-23}, {27,-22}, {27,-21}, {27,-20}, {27,-19}, {27,-11}, {27,-10}, {27,-9}, {27,-8}, {27,-7}, {27,-6}, {27,-5}, {27,-4}, {27,-3}, {27,-2}, {27,-1}, {27,8}, {27,9}, {27,10}, {28,-22}, {28,-21}, {28,-20}, {28,-19}, {28,-18}, {28,-17}, {28,-13}, {28,-12}, {28,-11}, {28,-10}, {28,-9}, {28,-8}, {28,-7}, {28,-6}, {28,-5}, {28,-4}, {28,-3}, {28,-2}, {28,-1}, {28,0}, {28,7}, {28,8}, {28,9}, {28,10}, {29,-21}, {29,-20}, {29,-19}, {29,-18}, {29,-17}, {29,-16}, {29,-15}, {29,-14}, {29,-13}, {29,-12}, {29,-11}, {29,-10}, {29,-9}, {29,-8}, {29,-7}, {29,-6}, {29,-5}, {29,-4}, {29,-3}, {29,-2}, {29,-1}, {29,0}, {29,7}, {29,8}, {29,9}, {29,10}, {30,-20}, {30,-19}, {30,-18}, {30,-17}, {30,-16}, {30,-15}, {30,-14}, {30,-13}, {30,-12}, {30,-11}, {30,-10}, {30,-9}, {30,-8}, {30,-7}, {30,-6}, {30,-5}, {30,-4}, {30,-3}, {30,-2}, {30,-1}, {30,0}, {30,1}, {30,2}, {30,5}, {30,6}, {30,7}, {30,8}, {30,9}, {30,10}, {30,11}, {31,-17}, {31,-16}, {31,-12}, {31,-11}, {31,-10}, {31,-9}, {31,-8}, {31,-7}, {31,-6}, {31,-5}, {31,-4}, {31,-3}, {31,-2}, {31,-1}, {31,0}, {31,1}, {31,2}, {31,3}, {31,4}, {31,5}, {31,6}, {31,7}, {31,8}, {32,-10}, {32,-9}, {32,-2}, {32,-1}, {32,0}, {32,1}, {32,2}, {32,3}, {32,4}, {32,5}, {32,6},
    {-3,-10}, {-3,-9}, {-3,-8}, {-2,-8},
    },
    ["refined-concrete"] = {{-29,5}, {-29,6}, {-29,7}, {-29,8}, {-29,9}, {-28,3}, {-28,4}, {-28,5}, {-28,6}, {-28,7}, {-28,8}, {-28,9}, {-28,10}, {-28,11}, {-27,1}, {-27,2}, {-27,3}, {-27,4}, {-27,5}, {-27,6}, {-27,7}, {-27,8}, {-27,9}, {-27,10}, {-27,11}, {-27,12}, {-27,13}, {-26,1}, {-26,2}, {-26,3}, {-26,4}, {-26,5}, {-26,6}, {-26,7}, {-26,8}, {-26,9}, {-26,10}, {-26,11}, {-26,12}, {-26,13}, {-25,0}, {-25,1}, {-25,2}, {-25,3}, {-25,4}, {-25,5}, {-25,6}, {-25,7}, {-25,8}, {-25,9}, {-25,10}, {-25,11}, {-25,12}, {-25,13}, {-25,14}, {-24,0}, {-24,1}, {-24,2}, {-24,3}, {-24,4}, {-24,5}, {-24,6}, {-24,7}, {-24,8}, {-24,9}, {-24,10}, {-24,11}, {-24,12}, {-24,13}, {-24,14}, {-23,-1}, {-23,0}, {-23,1}, {-23,2}, {-23,3}, {-23,4}, {-23,5}, {-23,6}, {-23,7}, {-23,8}, {-23,9}, {-23,10}, {-23,11}, {-23,12}, {-23,13}, {-23,14}, {-23,15}, {-22,-1}, {-22,0}, {-22,1}, {-22,2}, {-22,3}, {-22,4}, {-22,5}, {-22,6}, {-22,7}, {-22,8}, {-22,9}, {-22,10}, {-22,11}, {-22,12}, {-22,13}, {-22,14}, {-22,15}, {-21,-1}, {-21,0}, {-21,1}, {-21,2}, {-21,3}, {-21,4}, {-21,5}, {-21,6}, {-21,7}, {-21,8}, {-21,9}, {-21,10}, {-21,11}, {-21,12}, {-21,13}, {-21,14}, {-21,15}, {-20,-1}, {-20,0}, {-20,1}, {-20,2}, {-20,3}, {-20,4}, {-20,5}, {-20,6}, {-20,7}, {-20,8}, {-20,9}, {-20,10}, {-20,11}, {-20,12}, {-20,13}, {-20,14}, {-20,15}, {-19,-1}, {-19,0}, {-19,1}, {-19,2}, {-19,3}, {-19,4}, {-19,5}, {-19,6}, {-19,7}, {-19,8}, {-19,9}, {-19,10}, {-19,11}, {-19,12}, {-19,13}, {-19,14}, {-18,0}, {-18,1}, {-18,2}, {-18,3}, {-18,4}, {-18,5}, {-18,6}, {-18,7}, {-18,8}, {-18,9}, {-18,10}, {-18,11}, {-18,12}, {-18,13}, {-18,14}, {-17,0}, {-17,1}, {-17,2}, {-17,3}, {-17,4}, {-17,5}, {-17,6}, {-17,7}, {-17,8}, {-17,9}, {-17,10}, {-17,11}, {-17,12}, {-17,13}, {-17,14}, {-16,1}, {-16,2}, {-16,3}, {-16,4}, {-16,5}, {-16,6}, {-16,7}, {-16,8}, {-16,9}, {-16,10}, {-16,11}, {-16,12}, {-16,13}, {-15,12}, {-15,13}, {-13,-13}, {-13,-12}, {-13,-11}, {-12,-15}, {-12,-14}, {-12,-13}, {-12,-12}, {-12,-11}, {-12,-10}, {-12,-9}, {-11,-15}, {-11,-14}, {-11,-13}, {-11,-12}, {-11,-11}, {-11,-10}, {-11,-9}, {-10,-16}, {-10,-15}, {-10,-14}, {-10,-13}, {-10,-12}, {-10,-11}, {-10,-10}, {-10,-9}, {-9,-16}, {-9,-15}, {-9,-14}, {-9,-13}, {-9,-12}, {-9,-11}, {-9,-10}, {-9,-9}, {-9,-8}, {-8,-16}, {-8,-15}, {-8,-14}, {-8,-13}, {-8,-12}, {-8,-11}, {-8,-10}, {-8,-9}, {-7,-15}, {-7,-14}, {-7,-13}, {-7,-12}, {-7,-11}, {-7,-10}, {-7,-9}, {-7,13}, {-7,14}, {-7,15}, {-7,16}, {-7,17}, {-6,-15}, {-6,-14}, {-6,-13}, {-6,-12}, {-6,-11}, {-6,-10}, {-6,-9}, {-6,12}, {-6,13}, {-6,14}, {-6,15}, {-6,16}, {-6,17}, {-5,-13}, {-5,-12}, {-5,-11}, {-5,12}, {-5,13}, {-5,14}, {-5,15}, {-5,16}, {-5,17}, {-4,12}, {-4,13}, {-4,14}, {-4,15}, {-4,16}, {-4,17}, {-3,12}, {-3,13}, {-3,14}, {-3,15}, {-3,16}, {-3,17}, {-2,12}, {-2,13}, {-2,14}, {-2,15}, {-2,16}, {-2,17}, {-1,12}, {-1,13}, {-1,14}, {-1,15}, {-1,16}, {-1,17}, {0,12}, {0,13}, {0,14}, {0,15}, {0,16}, {0,17}, {1,12}, {1,13}, {1,14}, {1,15}, {1,16}, {1,17}, {2,12}, {2,13}, {2,14}, {2,15}, {2,16}, {2,17}, {4,-7}, {4,-6}, {4,-5}, {4,-4}, {4,-3}, {4,-2}, {4,-1}, {5,-7}, {5,-6}, {5,-5}, {5,-4}, {5,-3}, {5,-2}, {5,-1}, {6,-8}, {6,-7}, {6,-6}, {6,-5}, {6,-4}, {6,-3}, {6,-2}, {6,-1}, {6,0}, {7,-8}, {7,-7}, {7,-6}, {7,-5}, {7,-4}, {7,-3}, {7,-2}, {7,-1}, {7,0}, {8,-8}, {8,-7}, {8,-6}, {8,-5}, {8,-4}, {8,-3}, {8,-2}, {8,-1}, {8,0}, {9,-7}, {9,-6}, {9,-5}, {9,-4}, {9,-3}, {9,-2}, {9,-1}, {10,-7}, {10,-6}, {10,-5}, {10,-4}, {10,-3}, {10,-2}, {10,-1}, {11,-5}, {11,-4}, {11,-3}, {11,17}, {11,18}, {12,15}, {12,16}, {12,17}, {12,18}, {12,19}, {12,20}, {13,15}, {13,16}, {13,17}, {13,18}, {13,19}, {13,20}, {14,15}, {14,16}, {14,17}, {14,18}, {14,19}, {14,20}, {14,21}, {15,15}, {15,16}, {15,17}, {15,18}, {15,19}, {15,20}, {15,21}, {16,-16}, {16,-15}, {16,-14}, {16,15}, {16,16}, {16,17}, {16,18}, {16,19}, {16,20}, {17,-18}, {17,-17}, {17,-16}, {17,-15}, {17,-14}, {17,-13}, {17,-12}, {17,15}, {17,16}, {17,17}, {17,18}, {17,19}, {17,20}, {18,-19}, {18,-18}, {18,-17}, {18,-16}, {18,-15}, {18,-14}, {18,-13}, {18,-12}, {18,-11}, {18,17}, {18,18}, {19,-20}, {19,-19}, {19,-18}, {19,-17}, {19,-16}, {19,-15}, {19,-14}, {19,-13}, {19,-12}, {19,-11}, {19,-10}, {20,-20}, {20,-19}, {20,-18}, {20,-17}, {20,-16}, {20,-15}, {20,-14}, {20,-13}, {20,-12}, {20,-11}, {20,-10}, {21,-21}, {21,-20}, {21,-19}, {21,-18}, {21,-17}, {21,-16}, {21,-15}, {21,-14}, {21,-13}, {21,-12}, {21,-11}, {21,-10}, {22,-21}, {22,-20}, {22,-19}, {22,-18}, {22,-17}, {22,-16}, {22,-15}, {22,-14}, {22,-13}, {22,-12}, {22,-11}, {22,-10}, {23,-21}, {23,-20}, {23,-19}, {23,-18}, {23,-17}, {23,-16}, {23,-15}, {23,-14}, {23,-13}, {23,-12}, {23,-11}, {23,-10}, {24,-20}, {24,-19}, {24,-18}, {24,-17}, {24,-16}, {24,-15}, {24,-14}, {24,-13}, {24,-12}, {24,-11}, {24,-10}, {24,1}, {24,2}, {24,3}, {24,4}, {24,5}, {24,6}, {25,-20}, {25,-19}, {25,-18}, {25,-17}, {25,-16}, {25,-15}, {25,-14}, {25,-13}, {25,-12}, {25,-11}, {25,-10}, {25,1}, {25,2}, {25,3}, {25,4}, {25,5}, {25,6}, {26,-19}, {26,-18}, {26,-17}, {26,-16}, {26,-15}, {26,-14}, {26,-13}, {26,-12}, {26,-11}, {26,0}, {26,1}, {26,2}, {26,3}, {26,4}, {26,5}, {26,6}, {26,7}, {27,-18}, {27,-17}, {27,-16}, {27,-15}, {27,-14}, {27,-13}, {27,-12}, {27,0}, {27,1}, {27,2}, {27,3}, {27,4}, {27,5}, {27,6}, {27,7}, {28,-16}, {28,-15}, {28,-14}, {28,1}, {28,2}, {28,3}, {28,4}, {28,5}, {28,6}, {29,1}, {29,2}, {29,3}, {29,4}, {29,5}, {29,6}, {30,3}, {30,4}, },
    ["vegetation-green-grass-1"] = {{-19,-2}, {-18,-2}, {-8,14}, {-2,-21}, {0,-19}, {1,-26}, {8,-24}, {10,-9}, {11,-6}, {15,-14}, {17,-11}, {18,-10}, {18,-9}, {18,-6}, },
    ["concrete"] = {{-18,-1}, {-17,-2}, {-17,-1}, {-16,-3}, {-16,-2}, {-16,-1}, {-16,0}, {-15,-4}, {-15,-3}, {-15,-1}, {-15,0}, {-15,1}, {-15,2}, {-15,3}, {-15,4}, {-15,5}, {-15,6}, {-15,7}, {-15,8}, {-15,9}, {-15,10}, {-15,11}, {-14,-5}, {-14,-4}, {-14,-3}, {-14,-2}, {-14,-1}, {-14,12}, {-14,13}, {-13,-6}, {-13,-5}, {-13,-4}, {-13,-3}, {-13,-2}, {-13,2}, {-13,12}, {-13,13}, {-12,-8}, {-12,-7}, {-12,-6}, {-12,-5}, {-12,-4}, {-12,-3}, {-12,12}, {-12,13}, {-11,-8}, {-11,-7}, {-11,-6}, {-11,-5}, {-11,-4}, {-11,12}, {-11,13}, {-10,-8}, {-10,-7}, {-10,-6}, {-10,-5}, {-10,12}, {-10,13}, {-9,12}, {-9,13}, {-8,-8}, {-8,-7}, {-8,-6}, {-8,-5}, {-8,12}, {-8,13}, {-7,-7}, {-7,-6}, {-7,-5}, {-6,-7}, {-6,-6}, {-5,-7}, {-5,-6}, {-4,-7}, {-4,-6}, {-3,-7}, {-3,-6}, {-2,-7}, {-2,-6}, {-2,-2}, {-2,-1}, {-2,0}, {-2,1}, {-2,2}, {-2,3}, {-2,7}, {-2,8}, {-2,9}, {-2,10}, {-2,11}, {-1,-7}, {-1,-6}, {-1,-2}, {-1,-1}, {-1,0}, {-1,1}, {-1,2}, {-1,3}, {-1,7}, {-1,8}, {-1,9}, {-1,10}, {-1,11}, {0,-7}, {0,-6}, {0,-2}, {0,-1}, {1,-7}, {1,-6}, {1,-2}, {1,-1}, {2,-7}, {2,-6}, {2,-2}, {2,-1}, {3,-7}, {3,-6}, {3,-2}, {3,-1}, {3,14}, {4,14}, {5,14}, {6,14}, {7,14}, {8,14}, {9,14}, {10,14}, {11,-2}, {11,14}, {12,-4}, {12,-3}, {12,-2}, {12,12}, {12,13}, {12,14}, {13,-4}, {13,-3}, {13,-2}, {13,12}, {13,13}, {13,14}, {16,12}, {16,13}, {16,14}, {17,-4}, {17,-3}, {17,-2}, {17,11}, {17,12}, {17,13}, {17,14}, {18,-4}, {18,-3}, {18,-2}, {18,10}, {18,11}, {18,12}, {19,-9}, {19,-8}, {19,-7}, {19,-6}, {19,-5}, {19,-4}, {19,-3}, {19,-2}, {19,9}, {19,10}, {19,11}, {20,-9}, {20,-8}, {20,-7}, {20,-6}, {20,-5}, {20,-4}, {20,-3}, {20,-2}, {20,8}, {20,9}, {20,10}, {21,7}, {21,8}, {21,9}, {22,6}, {22,7}, {22,8}, {23,-9}, {23,-8}, {23,-7}, {23,-6}, {23,-5}, {23,-4}, {23,-3}, {23,-2}, {23,-1}, {23,0}, {23,1}, {23,2}, {23,5}, {23,6}, {23,7}, {24,-9}, {24,-8}, {24,-7}, {24,-6}, {24,-5}, {24,-4}, {24,-3}, {24,-2}, {24,-1}, {24,0}, },
    ["black-refined-concrete"] = {{-15,-2}, {-14,0}, {-14,1}, {-14,2}, {-14,3}, {-14,4}, {-14,5}, {-14,6}, {-14,7}, {-14,8}, {-14,9}, {-14,10}, {-14,11}, {-13,-1}, {-13,0}, {-13,1}, {-13,3}, {-13,4}, {-13,5}, {-13,6}, {-13,7}, {-13,8}, {-13,9}, {-13,10}, {-13,11}, {-12,-2}, {-12,-1}, {-12,0}, {-12,1}, {-12,2}, {-12,3}, {-12,4}, {-12,5}, {-12,6}, {-12,7}, {-12,8}, {-12,9}, {-12,10}, {-12,11}, {-11,-3}, {-11,-2}, {-11,-1}, {-11,0}, {-11,1}, {-11,2}, {-11,3}, {-11,4}, {-11,5}, {-11,6}, {-11,7}, {-11,8}, {-11,9}, {-11,10}, {-11,11}, {-10,-4}, {-10,-3}, {-10,-2}, {-10,-1}, {-10,0}, {-10,1}, {-10,2}, {-10,3}, {-10,4}, {-10,5}, {-10,6}, {-10,7}, {-10,8}, {-10,9}, {-10,10}, {-10,11}, {-9,-7}, {-9,-6}, {-9,-5}, {-9,-4}, {-9,-3}, {-9,-2}, {-9,-1}, {-9,0}, {-9,1}, {-9,2}, {-9,3}, {-9,4}, {-9,5}, {-9,6}, {-9,7}, {-9,8}, {-9,9}, {-9,10}, {-9,11}, {-8,-4}, {-8,-3}, {-8,-2}, {-8,-1}, {-8,0}, {-8,1}, {-8,2}, {-8,3}, {-8,4}, {-8,5}, {-8,6}, {-8,7}, {-8,8}, {-8,9}, {-8,10}, {-8,11}, {-7,-8}, {-7,-4}, {-7,-3}, {-7,-2}, {-7,-1}, {-7,0}, {-7,1}, {-7,2}, {-7,3}, {-7,4}, {-7,5}, {-7,6}, {-7,7}, {-7,8}, {-7,9}, {-7,10}, {-7,11}, {-7,12}, {-6,-5}, {-6,-4}, {-6,-3}, {-6,-2}, {-6,-1}, {-6,0}, {-6,1}, {-6,2}, {-6,3}, {-6,4}, {-6,5}, {-6,6}, {-6,7}, {-6,8}, {-6,9}, {-6,10}, {-6,11}, {-5,-5}, {-5,-4}, {-5,-3}, {-5,-2}, {-5,-1}, {-5,0}, {-5,1}, {-5,2}, {-5,3}, {-5,4}, {-5,5}, {-5,6}, {-5,7}, {-5,8}, {-5,9}, {-5,10}, {-5,11}, {-4,-5}, {-4,-4}, {-4,-3}, {-4,-2}, {-4,-1}, {-4,0}, {-4,1}, {-4,2}, {-4,3}, {-4,4}, {-4,5}, {-4,6}, {-4,7}, {-4,8}, {-4,9}, {-4,10}, {-4,11}, {-3,-5}, {-3,-4}, {-3,-3}, {-3,-2}, {-3,-1}, {-3,0}, {-3,1}, {-3,2}, {-3,3}, {-3,4}, {-3,5}, {-3,6}, {-3,7}, {-3,8}, {-3,9}, {-3,10}, {-3,11}, {-2,-5}, {-2,-4}, {-2,-3}, {-1,-5}, {-1,-4}, {-1,-3}, {0,-5}, {0,-4}, {0,-3}, {1,-5}, {1,-4}, {1,-3}, {2,-5}, {2,-4}, {2,-3}, {3,-5}, {3,-4}, {3,-3}, },
    ["mineral-dustyrose-dirt-3"] = {{-7,-27}, {-6,-26}, {-6,-25}, {-5,-26}, {-5,-25}, {-5,-24}, {-4,-25}, {-4,-24}, {-3,-24}, {-3,-23}, {-2,-25}, {-2,-24}, {-2,-23}, {-2,-22}, {-1,-25}, {-1,-24}, {-1,-23}, {-1,-22}, {-1,-21}, {-1,4}, {-1,5}, {-1,6}, {0,-24}, {0,-23}, {0,-22}, {0,-21}, {0,4}, {0,5}, {0,6}, {1,-24}, {1,-23}, {1,-22}, {1,-21}, {1,-20}, {1,4}, {1,5}, {1,6}, {2,-26}, {2,-25}, {2,-24}, {2,-21}, {2,-20}, {2,-19}, {2,4}, {2,5}, {2,6}, {3,-26}, {3,-25}, {3,-23}, {3,-22}, {3,-21}, {3,-20}, {3,-19}, {3,-18}, {3,4}, {3,5}, {4,-27}, {4,-26}, {4,-25}, {4,-24}, {4,-23}, {4,-22}, {4,-21}, {4,-20}, {4,-19}, {4,-18}, {4,-17}, {4,4}, {4,5}, {4,6}, {5,-28}, {5,-27}, {5,-26}, {5,-25}, {5,-24}, {5,-23}, {5,-22}, {5,-21}, {5,-20}, {5,-19}, {5,-18}, {5,-17}, {5,-16}, {5,4}, {5,5}, {5,6}, {6,-18}, {6,-17}, {6,-16}, {6,-15}, {6,4}, {6,5}, {6,6}, {7,-17}, {7,-16}, {7,-15}, {7,-14}, {7,4}, {7,5}, {7,6}, {8,-16}, {8,-15}, {8,-14}, {8,-13}, {8,5}, {8,6}, {9,-16}, {9,-15}, {9,-14}, {9,-13}, {9,5}, {9,6}, {10,-15}, {10,-14}, {10,-13}, {10,-12}, {10,5}, {10,6}, {11,-15}, {11,-14}, {11,-13}, {11,-12}, {11,-11}, {11,5}, {11,6}, {12,-14}, {12,-13}, {12,-12}, {12,-11}, {12,4}, {12,5}, {12,6}, {13,-13}, {13,-12}, {13,-11}, {13,-10}, {13,-9}, {13,-8}, {13,-7}, {13,4}, {13,5}, {13,6}, {14,-12}, {14,-11}, {14,-10}, {14,-9}, {14,-8}, {14,-7}, {14,-6}, {14,-4}, {14,-3}, {14,-2}, {14,-1}, {14,0}, {14,1}, {14,2}, {14,3}, {14,4}, {14,5}, {14,6}, {15,-11}, {15,-10}, {15,-9}, {15,-8}, {15,-7}, {15,-6}, {15,-5}, {15,-4}, {15,-3}, {15,-2}, {15,-1}, {15,0}, {15,1}, {15,2}, {15,3}, {15,4}, {15,5}, {15,6}, {16,-7}, {16,-6}, {16,-5}, {16,-4}, {16,-3}, {16,-2}, {16,-1}, {16,0}, {16,1}, {16,2}, {16,3}, {16,4}, {16,5}, },
    ["landfill"] = {{-6,-8}, {-5,-10}, {-5,-9}, {-5,-8}, {-4,-10}, {-4,-9}, {-4,-8}, },
    ["mineral-dustyrose-dirt-2"] = {{-2,4}, {-2,5}, {-2,6}, {3,6}, {8,4}, {9,4}, {10,4}, {11,4},{12,-5},{13,3}, {14,-5},},
    ["stone-path"] = {{0,0}, {0,1}, {0,2}, {0,3}, {0,7}, {0,8}, {0,9}, {0,10}, {0,11}, {1,0}, {1,1}, {1,2}, {1,3}, {1,7}, {1,8}, {1,9}, {1,10}, {1,11}, {2,0}, {2,1}, {2,2}, {2,3}, {2,7}, {2,8}, {2,9}, {2,10}, {2,11}, {3,0}, {3,1}, {3,2}, {3,3}, {3,7}, {3,8}, {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, {3,15}, {4,0}, {4,1}, {4,2}, {4,3}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, {4,13}, {4,15}, {5,0}, {5,1}, {5,2}, {5,3}, {5,7}, {5,8}, {5,9}, {5,10}, {5,11}, {5,12}, {5,13}, {5,15}, {6,1}, {6,2}, {6,3}, {6,7}, {6,8}, {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, {6,15}, {7,1}, {7,2}, {7,3}, {7,7}, {7,8}, {7,9}, {7,10}, {7,11}, {7,12}, {7,13}, {7,15}, {8,1}, {8,2}, {8,3}, {8,7}, {8,8}, {8,9}, {8,10}, {8,11}, {8,12}, {8,13}, {8,15}, {9,0}, {9,1}, {9,2}, {9,3}, {9,7}, {9,8}, {9,9}, {9,10}, {9,11}, {9,12}, {9,13}, {9,15}, {10,0}, {10,1}, {10,2}, {10,3}, {10,7}, {10,8}, {10,9}, {10,10}, {10,11}, {10,12}, {10,13}, {10,15}, {11,-1}, {11,0}, {11,1}, {11,2}, {11,3}, {11,7}, {11,8}, {11,9}, {11,10}, {11,11}, {11,12}, {11,13}, {11,15}, {12,-1}, {12,0}, {12,1}, {12,2}, {12,3}, {12,7}, {12,8}, {12,9}, {12,10}, {12,11}, {13,-5}, {13,-1}, {13,0}, {13,1}, {13,2}, {13,7}, {13,8}, {13,9}, {13,10}, {13,11}, {14,7}, {14,8}, {14,9}, {14,10}, {14,11}, {14,12}, {14,13}, {14,14}, {15,7}, {15,8}, {15,9}, {15,10}, {15,11}, {15,12}, {15,13}, {15,14}, {16,6}, {16,7}, {16,8}, {16,9}, {16,10}, {16,11}, {17,-5}, {17,-1}, {17,0}, {17,1}, {17,2}, {17,3}, {17,4}, {17,5}, {17,6}, {17,7}, {17,8}, {17,9}, {17,10}, {18,-5}, {18,-1}, {18,0}, {18,1}, {18,2}, {18,3}, {18,4}, {18,5}, {18,6}, {18,7}, {18,8}, {18,9}, {19,-1}, {19,0}, {19,1}, {19,2}, {19,3}, {19,4}, {19,5}, {19,6}, {19,7}, {19,8}, {20,-1}, {20,0}, {20,1}, {20,2}, {20,3}, {20,4}, {20,5}, {20,6}, {20,7}, {21,-9}, {21,-8}, {21,-7}, {21,-6}, {21,-5}, {21,-4}, {21,-3}, {21,-2}, {21,-1}, {21,0}, {21,1}, {21,2}, {21,3}, {21,4}, {21,5}, {21,6}, {22,-9}, {22,-8}, {22,-7}, {22,-6}, {22,-5}, {22,-4}, {22,-3}, {22,-2}, {22,-1}, {22,0}, {22,1}, {22,2}, {22,3}, {22,4}, {22,5}, {23,3}, {23,4}, },
  },
  under_tiles = {
    ["mineral-beige-dirt-4"] = {{-30,5}, {-30,6}, {-30,7}, {-30,8}, {-30,9}, {-29,5}, {-29,6}, {-29,7}, {-29,8}, {-29,9}, {-28,3}, {-28,4}, {-28,5}, {-28,6}, {-28,7}, {-28,8}, {-28,9}, {-28,10}, {-28,11}, {-27,1}, {-27,2}, {-27,3}, {-27,4}, {-27,5}, {-27,6}, {-27,7}, {-27,8}, {-27,9}, {-27,10}, {-27,11}, {-27,12}, {-27,13}, {-26,1}, {-26,2}, {-26,3}, {-26,4}, {-26,5}, {-26,6}, {-26,7}, {-26,8}, {-26,9}, {-26,10}, {-26,11}, {-26,12}, {-26,13}, {-25,0}, {-25,1}, {-25,2}, {-25,3}, {-25,4}, {-25,5}, {-25,6}, {-25,7}, {-25,8}, {-25,9}, {-25,10}, {-25,11}, {-25,12}, {-25,13}, {-25,14}, {-24,0}, {-24,1}, {-24,2}, {-24,3}, {-24,4}, {-24,5}, {-24,6}, {-24,7}, {-24,8}, {-24,9}, {-24,10}, {-24,11}, {-24,12}, {-24,13}, {-24,14}, {-23,-1}, {-23,0}, {-23,1}, {-23,2}, {-23,3}, {-23,4}, {-23,5}, {-23,6}, {-23,7}, {-23,8}, {-23,9}, {-23,10}, {-23,11}, {-23,12}, {-23,13}, {-23,14}, {-23,15}, {-22,-1}, {-22,0}, {-22,1}, {-22,2}, {-22,3}, {-22,4}, {-22,5}, {-22,6}, {-22,7}, {-22,8}, {-22,9}, {-22,10}, {-22,11}, {-22,12}, {-22,13}, {-22,14}, {-22,15}, {-21,-1}, {-21,0}, {-21,1}, {-21,2}, {-21,3}, {-21,4}, {-21,5}, {-21,6}, {-21,7}, {-21,8}, {-21,9}, {-21,10}, {-21,11}, {-21,12}, {-21,13}, {-21,14}, {-21,15}, {-20,-1}, {-20,0}, {-20,1}, {-20,2}, {-20,3}, {-20,4}, {-20,5}, {-20,6}, {-20,7}, {-20,8}, {-20,9}, {-20,10}, {-20,11}, {-20,12}, {-20,13}, {-20,14}, {-20,15}, {-19,-1}, {-19,0}, {-19,1}, {-19,2}, {-19,3}, {-19,4}, {-19,5}, {-19,6}, {-19,7}, {-19,8}, {-19,9}, {-19,10}, {-19,11}, {-19,12}, {-19,13}, {-19,14}, {-18,2}, {-18,3}, {-18,4}, {-18,5}, {-18,6}, {-18,7}, {-18,8}, {-18,9}, {-18,10}, {-18,11}, {-18,12}, {-18,13}, {-18,14}, {-17,9}, {-17,10}, {-17,11}, {-17,12}, {-17,13}, {-17,14}, {-16,11}, {-16,12}, {-16,13}, {-15,12}, {-15,13}, {-14,0}, {-13,-13}, {-13,-11}, {-13,-1}, {-13,0}, {-13,1}, {-12,-15}, {-12,-9}, {-12,-8}, {-12,-2}, {-12,-1}, {-12,0}, {-12,1}, {-12,2}, {-12,3}, {-12,4}, {-12,5}, {-12,6}, {-12,7}, {-12,8}, {-12,9}, {-12,10}, {-11,-3}, {-11,-2}, {-11,-1}, {-11,0}, {-11,1}, {-11,2}, {-11,3}, {-11,4}, {-11,5}, {-11,6}, {-11,7}, {-11,8}, {-11,9}, {-11,10}, {-11,14}, {-10,-16}, {-10,-3}, {-10,-2}, {-10,-1}, {-10,0}, {-10,1}, {-10,2}, {-10,3}, {-10,4}, {-10,5}, {-10,6}, {-10,7}, {-10,8}, {-10,9}, {-10,10}, {-10,14}, {-9,-7}, {-9,-6}, {-9,-5}, {-9,-4}, {-9,-3}, {-9,-2}, {-9,-1}, {-9,0}, {-9,1}, {-9,2}, {-9,3}, {-9,4}, {-9,5}, {-9,6}, {-9,7}, {-9,8}, {-9,9}, {-9,10}, {-9,14}, {-8,-16}, {-8,-3}, {-8,-2}, {-8,-1}, {-8,0}, {-8,1}, {-8,2}, {-8,3}, {-8,4}, {-8,5}, {-8,6}, {-8,7}, {-8,8}, {-8,9}, {-8,10}, {-7,-3}, {-7,-2}, {-7,-1}, {-7,0}, {-7,1}, {-7,2}, {-7,3}, {-7,4}, {-7,5}, {-7,6}, {-7,7}, {-7,8}, {-7,9}, {-7,10}, {-7,12}, {-7,13}, {-7,14}, {-7,15}, {-7,16}, {-7,17}, {-6,-15}, {-6,-8}, {-6,-3}, {-6,-2}, {-6,-1}, {-6,0}, {-6,1}, {-6,2}, {-6,3}, {-6,4}, {-6,5}, {-6,6}, {-6,7}, {-6,8}, {-6,9}, {-6,10}, {-6,15}, {-6,16}, {-6,17}, {-5,-15}, {-5,-14}, {-5,-13}, {-5,-11}, {-5,-3}, {-5,-2}, {-5,-1}, {-5,0}, {-5,1}, {-5,2}, {-5,3}, {-5,4}, {-5,5}, {-5,6}, {-5,7}, {-5,8}, {-5,9}, {-5,10}, {-5,15}, {-5,16}, {-5,17}, {-4,-15}, {-4,-14}, {-4,-13}, {-4,-12}, {-4,-11}, {-4,-10}, {-4,-9}, {-4,-3}, {-4,-2}, {-4,-1}, {-4,0}, {-4,1}, {-4,2}, {-4,3}, {-4,4}, {-4,5}, {-4,6}, {-4,7}, {-4,8}, {-4,9}, {-4,14}, {-4,15}, {-4,16}, {-4,17}, {-3,-15}, {-3,-14}, {-3,-13}, {-3,-12}, {-3,-11}, {-3,-10}, {-3,-9}, {-3,-3}, {-3,13}, {-3,14}, {-3,15}, {-3,16}, {-3,17}, {-2,-14}, {-2,-13}, {-2,-12}, {-2,-11}, {-2,-10}, {-2,-9}, {-2,-8}, {-2,13}, {-2,14}, {-2,15}, {-2,16}, {-2,17}, {-1,-14}, {-1,-13}, {-1,-12}, {-1,-11}, {-1,-10}, {-1,-9}, {-1,-8}, {-1,4}, {-1,5}, {-1,6}, {-1,7}, {-1,8}, {-1,9}, {-1,10}, {-1,11}, {-1,12}, {-1,13}, {-1,14}, {-1,15}, {-1,16}, {-1,17}, {0,-13}, {0,-12}, {0,-11}, {0,-10}, {0,-9}, {0,-8}, {0,4}, {0,5}, {0,6}, {0,7}, {0,8}, {0,9}, {0,10}, {0,11}, {0,12}, {0,13}, {0,14}, {0,15}, {0,16}, {0,17}, {1,-12}, {1,-11}, {1,-10}, {1,-9}, {1,-8}, {1,-3}, {1,2}, {1,4}, {1,5}, {1,6}, {1,7}, {1,8}, {1,9}, {1,10}, {1,11}, {1,12}, {1,13}, {1,14}, {1,15}, {1,16}, {1,17}, {2,-10}, {2,-9}, {2,-8}, {2,1}, {2,2}, {2,3}, {2,4}, {2,5}, {2,6}, {2,7}, {2,8}, {2,9}, {2,10}, {2,11}, {2,12}, {2,13}, {2,14}, {2,15}, {2,16}, {2,17}, {3,-8}, {3,0}, {3,1}, {3,2}, {3,3}, {3,4}, {3,5}, {3,6}, {3,7}, {3,8}, {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, {3,14}, {3,15}, {3,16}, {4,-7}, {4,-1}, {4,0}, {4,1}, {4,2}, {4,3}, {4,4}, {4,5}, {4,6}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, {4,13}, {4,14}, {4,15}, {4,16}, {5,-3}, {5,-2}, {5,-1}, {5,0}, {5,1}, {5,2}, {5,3}, {5,4}, {5,5}, {5,6}, {5,7}, {5,8}, {5,9}, {5,10}, {5,11}, {5,12}, {5,13}, {5,14}, {5,15}, {5,16}, {6,-8}, {6,-7}, {6,-6}, {6,-5}, {6,-4}, {6,-3}, {6,-2}, {6,-1}, {6,0}, {6,1}, {6,2}, {6,3}, {6,4}, {6,5}, {6,6}, {6,7}, {6,8}, {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, {6,14}, {6,15}, {6,16}, {7,-8}, {7,-7}, {7,-6}, {7,-5}, {7,-4}, {7,-3}, {7,-2}, {7,-1}, {7,0}, {7,1}, {7,2}, {7,3}, {7,4}, {7,5}, {7,6}, {7,7}, {7,8}, {7,9}, {7,10}, {7,11}, {7,12}, {7,13}, {7,14}, {7,15}, {7,16}, {8,-8}, {8,-7}, {8,-6}, {8,-5}, {8,-4}, {8,-3}, {8,-2}, {8,-1}, {8,0}, {8,1}, {8,2}, {8,3}, {8,4}, {8,5}, {8,6}, {8,7}, {8,8}, {8,9}, {8,10}, {8,11}, {8,12}, {8,13}, {8,14}, {8,15}, {8,16}, {9,-7}, {9,-6}, {9,-5}, {9,-4}, {9,-3}, {9,-2}, {9,-1}, {9,0}, {9,1}, {9,2}, {9,3}, {9,4}, {9,5}, {9,6}, {9,7}, {9,8}, {9,9}, {9,10}, {9,11}, {9,12}, {9,13}, {9,14}, {9,15}, {9,16}, {10,-7}, {10,-6}, {10,-5}, {10,-4}, {10,-3}, {10,-2}, {10,-1}, {10,0}, {10,1}, {10,2}, {10,3}, {10,4}, {10,5}, {10,6}, {10,7}, {10,8}, {10,9}, {10,10}, {10,11}, {10,12}, {10,13}, {10,14}, {10,15}, {10,16}, {11,-5}, {11,-4}, {11,-3}, {11,-2}, {11,-1}, {11,0}, {11,1}, {11,2}, {11,3}, {11,4}, {11,5}, {11,6}, {11,7}, {11,8}, {11,9}, {11,10}, {11,11}, {11,12}, {11,13}, {11,14}, {11,15}, {11,16}, {11,17}, {11,18}, {12,-1}, {12,0}, {12,1}, {12,2}, {12,3}, {12,4}, {12,5}, {12,6}, {12,7}, {12,8}, {12,9}, {12,10}, {12,11}, {12,12}, {12,13}, {12,14}, {12,15}, {12,16}, {12,17}, {12,18}, {12,19}, {12,20}, {13,-1}, {13,0}, {13,1}, {13,2}, {13,3}, {13,4}, {13,5}, {13,6}, {13,7}, {13,8}, {13,9}, {13,10}, {13,11}, {13,12}, {13,13}, {13,14}, {13,15}, {13,16}, {13,17}, {13,18}, {13,19}, {13,20}, {14,-1}, {14,0}, {14,1}, {14,2}, {14,3}, {14,4}, {14,5}, {14,6}, {14,7}, {14,8}, {14,9}, {14,10}, {14,11}, {14,12}, {14,13}, {14,14}, {14,15}, {14,16}, {14,17}, {14,18}, {14,19}, {14,20}, {14,21}, {15,-1}, {15,0}, {15,1}, {15,2}, {15,3}, {15,4}, {15,5}, {15,6}, {15,7}, {15,8}, {15,9}, {15,10}, {15,11}, {15,12}, {15,13}, {15,14}, {15,15}, {15,16}, {15,17}, {15,18}, {15,19}, {15,20}, {15,21}, {16,-16}, {16,-15}, {16,-14}, {16,-1}, {16,0}, {16,1}, {16,2}, {16,3}, {16,4}, {16,5}, {16,6}, {16,7}, {16,8}, {16,9}, {16,10}, {16,11}, {16,12}, {16,13}, {16,14}, {16,15}, {16,16}, {16,17}, {16,18}, {16,19}, {16,20}, {17,-18}, {17,-17}, {17,-16}, {17,-15}, {17,-14}, {17,-13}, {17,-12}, {17,-1}, {17,0}, {17,1}, {17,2}, {17,3}, {17,4}, {17,5}, {17,6}, {17,7}, {17,8}, {17,9}, {17,10}, {17,11}, {17,12}, {17,13}, {17,14}, {17,15}, {17,16}, {17,17}, {17,18}, {17,19}, {17,20}, {18,-19}, {18,-18}, {18,-17}, {18,-16}, {18,-15}, {18,-14}, {18,-13}, {18,-12}, {18,-11}, {18,-1}, {18,0}, {18,1}, {18,2}, {18,3}, {18,4}, {18,5}, {18,6}, {18,7}, {18,8}, {18,9}, {18,10}, {18,11}, {18,12}, {18,17}, {18,18}, {19,-20}, {19,-19}, {19,-18}, {19,-17}, {19,-16}, {19,-15}, {19,-14}, {19,-13}, {19,-12}, {19,-11}, {19,-10}, {19,-9}, {19,-8}, {19,-7}, {19,-6}, {19,-1}, {19,0}, {19,1}, {19,2}, {19,3}, {19,4}, {19,5}, {19,6}, {19,7}, {19,8}, {19,9}, {19,10}, {19,11}, {20,-20}, {20,-19}, {20,-18}, {20,-17}, {20,-16}, {20,-15}, {20,-14}, {20,-13}, {20,-12}, {20,-11}, {20,-10}, {20,-9}, {20,-8}, {20,-7}, {20,-6}, {20,-5}, {20,-4}, {20,-3}, {20,-2}, {20,-1}, {20,0}, {20,1}, {20,2}, {20,3}, {20,4}, {20,5}, {20,6}, {20,7}, {20,8}, {20,9}, {20,10}, {21,-21}, {21,-20}, {21,-19}, {21,-18}, {21,-17}, {21,-16}, {21,-15}, {21,-14}, {21,-13}, {21,-12}, {21,-11}, {21,-10}, {21,-9}, {21,-8}, {21,-7}, {21,-6}, {21,-5}, {21,-4}, {21,-3}, {21,-2}, {21,-1}, {21,0}, {21,1}, {21,2}, {21,3}, {21,4}, {21,5}, {21,6}, {21,7}, {21,8}, {21,9}, {22,-21}, {22,-20}, {22,-19}, {22,-18}, {22,-17}, {22,-16}, {22,-15}, {22,-14}, {22,-13}, {22,-12}, {22,-11}, {22,-10}, {22,-9}, {22,-8}, {22,-7}, {22,-6}, {22,-5}, {22,-4}, {22,-3}, {22,-2}, {22,-1}, {22,0}, {22,1}, {22,2}, {22,3}, {22,4}, {22,5}, {22,6}, {22,7}, {22,8}, {22,9}, {23,-21}, {23,-20}, {23,-19}, {23,-18}, {23,-17}, {23,-16}, {23,-15}, {23,-14}, {23,-13}, {23,-12}, {23,-11}, {23,-10}, {23,-9}, {23,-8}, {23,-7}, {23,-6}, {23,-5}, {23,-4}, {23,-3}, {23,-2}, {23,-1}, {23,0}, {23,1}, {23,2}, {23,3}, {23,4}, {23,5}, {23,6}, {23,7}, {23,8}, {24,-20}, {24,-19}, {24,-18}, {24,-17}, {24,-16}, {24,-15}, {24,-14}, {24,-13}, {24,-12}, {24,-11}, {24,-10}, {24,-9}, {24,-8}, {24,-7}, {24,-6}, {24,-5}, {24,-4}, {24,-3}, {24,-2}, {24,-1}, {24,0}, {24,1}, {24,2}, {24,3}, {24,4}, {24,5}, {24,6}, {24,7}, {24,8}, {25,-20}, {25,-19}, {25,-18}, {25,-17}, {25,-16}, {25,-15}, {25,-14}, {25,-13}, {25,-12}, {25,-11}, {25,-10}, {25,0}, {25,1}, {25,2}, {25,3}, {25,4}, {25,5}, {25,6}, {25,7}, {26,-19}, {26,-18}, {26,-17}, {26,-16}, {26,-15}, {26,-14}, {26,-13}, {26,-12}, {26,-11}, {26,0}, {26,1}, {26,2}, {26,3}, {26,4}, {26,5}, {26,6}, {26,7}, {27,-18}, {27,-17}, {27,-16}, {27,-15}, {27,-14}, {27,-13}, {27,-12}, {27,0}, {27,1}, {27,2}, {27,3}, {27,4}, {27,5}, {27,6}, {27,7}, {28,-16}, {28,-15}, {28,-14}, {28,1}, {28,2}, {28,3}, {28,4}, {28,5}, {28,6}, {29,1}, {29,2}, {29,3}, {29,4}, {29,5}, {29,6}, {30,3}, {30,4}, {-18,-1}, {-18,0}, {-18,1}, {-17,-2}, {-17,-1}, {-17,0}, {-17,1}, {-17,2}, {-17,3}, {-17,4}, {-17,5}, {-17,6}, {-17,7}, {-17,8}, {-16,-3}, {-16,-2}, {-16,-1}, {-16,0}, {-16,1}, {-16,2}, {-16,3}, {-16,4}, {-16,5}, {-16,6}, {-16,7}, {-16,8}, {-16,9}, {-16,10}, {-15,-4}, {-15,-3}, {-15,-1}, {-15,0}, {-15,1}, {-15,2}, {-15,3}, {-15,4}, {-15,5}, {-15,6}, {-15,7}, {-15,8}, {-15,9}, {-15,10}, {-15,11}, {-14,-5}, {-14,-4}, {-14,-3}, {-14,-2}, {-14,-1}, {-14,1}, {-14,2}, {-14,3}, {-14,4}, {-14,5}, {-14,6}, {-14,7}, {-14,8}, {-14,9}, {-14,10}, {-14,11}, {-14,12}, {-13,-6}, {-13,-5}, {-13,-4}, {-13,-3}, {-13,-2}, {-13,2}, {-13,3}, {-13,4}, {-13,5}, {-13,6}, {-13,7}, {-13,8}, {-13,9}, {-13,10}, {-13,11}, {-13,12}, {-12,-7}, {-12,-6}, {-12,-5}, {-12,-4}, {-12,-3}, {-12,11}, {-12,12}, {-11,-8}, {-11,-7}, {-11,-6}, {-11,-5}, {-11,-4}, {-11,11}, {-11,12}, {-10,-8}, {-10,-7}, {-10,-6}, {-10,-5}, {-10,-4}, {-10,11}, {-10,12}, {-9,11}, {-9,12}, {-8,-8}, {-8,-7}, {-8,-6}, {-8,-5}, {-8,-4}, {-8,11}, {-8,12}, {-7,-8}, {-7,-7}, {-7,-6}, {-7,-5}, {-7,-4}, {-7,11}, {-6,-9}, {-6,-7}, {-6,-6}, {-6,-5}, {-6,-4}, {-6,11}, {-6,12}, {-6,13}, {-6,14}, {-5,-10}, {-5,-9}, {-5,-8}, {-5,-7}, {-5,-6}, {-5,-5}, {-5,-4}, {-5,11}, {-5,12}, {-5,13}, {-5,14}, {-4,-8}, {-4,-7}, {-4,-6}, {-4,-5}, {-4,-4}, {-4,11}, {-4,12}, {-4,13}, {-3,-8}, {-3,-7}, {-3,-6}, {-3,-5}, {-3,-4}, {-3,-2}, {-3,-1}, {-3,0}, {-3,1}, {-3,2}, {-3,3}, {-3,4}, {-3,5}, {-3,6}, {-3,7}, {-3,8}, {-3,9}, {-3,10}, {-3,11}, {-3,12}, {-2,-7}, {-2,-6}, {-2,-5}, {-2,-4}, {-2,-3}, {-2,-2}, {-2,-1}, {-2,0}, {-2,1}, {-2,2}, {-2,3}, {-2,4}, {-2,5}, {-2,6}, {-2,7}, {-2,8}, {-2,9}, {-2,10}, {-2,11}, {-2,12}, {-1,-7}, {-1,-6}, {-1,-5}, {-1,-4}, {-1,-3}, {-1,-2}, {-1,-1}, {-1,0}, {-1,1}, {-1,2}, {0,-7}, {0,-6}, {0,-5}, {0,-4}, {0,-3}, {0,-2}, {0,-1}, {0,0}, {0,1}, {0,2}, {1,-7}, {1,-6}, {1,-5}, {1,-4}, {1,-2}, {1,-1}, {1,0}, {1,1}, {2,-7}, {2,-6}, {2,-5}, {2,-4}, {2,-3}, {2,-2}, {2,-1}, {2,0}, {3,-7}, {3,-6}, {3,-5}, {3,-4}, {3,-3}, {3,-2}, {3,-1}, {4,-6}, {4,-5}, {4,-4}, {4,-3}, {4,-2}, {5,-7}, {5,-6}, {5,-5}, {5,-4}, {-14,13}, {-9,13}, {-8,13}, {-13,-12}, {-12,-14}, {-12,-13}, {-12,-12}, {-12,-11}, {-12,-10}, {-11,-15}, {-11,-14}, {-11,-13}, {-11,-12}, {-11,-11}, {-11,-10}, {-11,-9}, {-10,-15}, {-10,-14}, {-10,-13}, {-10,-12}, {-10,-11}, {-10,-10}, {-10,-9}, {-9,-16}, {-9,-15}, {-9,-14}, {-9,-13}, {-9,-12}, {-9,-11}, {-9,-10}, {-9,-9}, {-9,-8}, {-8,-15}, {-8,-14}, {-8,-13}, {-8,-12}, {-8,-11}, {-8,-10}, {-8,-9}, {-7,-15}, {-7,-14}, {-7,-13}, {-7,-12}, {-7,-11}, {-7,-10}, {-7,-9}, {-6,-14}, {-6,-13}, {-6,-12}, {-6,-11}, {-6,-10}, {-5,-12}, {-13,13}, {-12,13}, {-11,13}, {-10,13},{-1,3}, {0,3}, {1,3},{12,-4}, {12,-3}, {12,-2}, {13,-5}, {13,-4}, {13,-3}, {13,-2}, {14,-2}, {15,-2}, {16,-2}, {17,-5}, {17,-4}, {17,-3}, {17,-2}, {18,-5}, {18,-4}, {18,-3}, {18,-2}, {19,-5}, {19,-4}, {19,-3}, {19,-2},},
  },
  blueprint_strings = {
    { xadj = 1, yadj = 0, force_override = "conquest",
      string = "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"
    }
  }
}

return arty40
