local data_util = require("data-util")

-- Fix burner assembler animation
local burner_assembler = data.raw["assembling-machine"]["burner-assembling-machine"]
burner_assembler.crafting_categories = {"basic-crafting-0", "crafting-0"}
burner_assembler.animation.layers = {
	burner_assembler.animation.layers[1],
	{ -- Copied from __base__/prototypes/entity/entities.lua
		filename = "__base__/graphics/entity/assembling-machine-1/assembling-machine-1-shadow.png",
		priority="high",
		width = 95,
		height = 83,
		frame_count = 1,
		line_length = 1,
		repeat_count = 32,
		draw_as_shadow = true,
		shift = util.by_pixel(8.5, 5.5),
		hr_version = {
			filename = "__base__/graphics/entity/assembling-machine-1/hr-assembling-machine-1-shadow.png",
			priority="high",
			width = 190,
			height = 165,
			frame_count = 1,
			line_length = 1,
			repeat_count = 32,
			draw_as_shadow = true,
			shift = util.by_pixel(8.5, 5),
			scale = 0.5
		}
	}
}

-- Move early-game components to "crafting-0" category
data:extend{
	{type = "recipe-category", name = "basic-crafting-0"},
	{type = "recipe-category", name = "crafting-0"},
}
data.raw.recipe["automation-science-pack"].category = "basic-crafting-0"
for name,recipe in pairs(data.raw.recipe) do
	if (name:sub(1, 6) == "burner" or name:sub(1, 6) == "copper" or name:sub(1, 5) == "steam" or name:sub(1, 5) == "stone" or name:sub(1, 3) == "tin" or name:sub(1, 4) == "wood") and
	(recipe.category == "crafting" or recipe.category == nil) and not data_util.table_contains({
		"burner-turbine",
		"copper-aetheric-lamp-straight",
		"copper-board",
		"copper-cable",
		"copper-cable-heavy",
		"copper-coil",
		"copper-foil",
		"copper-gate",
		"steam-engine",
		"steam-turbine",
		"tin-cable",
	}, name) then
		recipe.category = "crafting-0"
	end
end
for _,name in pairs{
	"assembling-machine-1",
	"light-armor",
	"long-handed-pipe-inserter",
	"pipe-inserter",
	"scattergun-turret",
	"shotgun",
	"shotgun-shell",
	"small-tank-steam",
	"splitter",
	"transport-belt",
	"underground-belt",
} do
	data.raw.recipe[name].category = "crafting-0"
end
