local tints = {
	tin = {r = 0.255, g = 0.282, b = 0.325}
}

local function create_component(material, type, icon, ingredients)
	local component_template = DIR.components[type]
	local material_template = DIR.materials[material]
	local name = material .. "-" .. type
	local tint = tints[material]
	data:extend{
		{
			type = "item",
			name = name,
			
			icons = {{
				icon = "__IndustrialRevolution__/graphics/mod_support/icons-64-greyscale/" .. icon .. ".png",
				icon_mipmaps = DIR.icon_mipmaps,
				icon_size = DIR.icon_size,
				tint = {r = tint.r * 2, g = tint.g * 2, b = tint.b * 2, a = 1},
			}},
			order = component_template.order .. "-" .. material_template.order,
			stack_size = component_template.stack_size or DIR.default_stack_size,
			subgroup = component_template.subgroup or type,
		},
		{
			type = "recipe",
			name = name,
			
			energy_required = component_template.speed,
			ingredients = ingredients,
			result = name,
		},
	}
end

create_component("tin", "frame-large", "greyscale-dull-frame-large", {
	{"tin-beam", 8},
	{"tin-plate", 16},
	{"tin-rivet", 4},
})
create_component("tin", "beam", "greyscale-dull-beam-cap", {
	{"tin-plate", 1},
	{"tin-rivet", 1},
	{"wood-beam", 1},
})
create_component("tin", "rivet", "greyscale-dull-1-rivet", {
	{"tin-rod", 1},
})

-- Fix icon overlays
table.insert(data.raw.item["tin-beam"].icons, 1, {
	icon = "__IndustrialRevolution__/graphics/icons/64/wood-beam.png",
	icon_mipmaps = DIR.icon_mipmaps,
	icon_size = DIR.icon_size,
})
