local blank = {
	filename = "__aai-industry__/graphics/blank.png",
	priority = "high",
	width = 1,
	height = 1,
	frame_count = 1,
}

local offshore_pump = data.raw["offshore-pump"]["copper-pump"]

local offshore_pump_output = table.deepcopy(data.raw.pump["offshore-pump-output"])
offshore_pump_output.animations = blank
offshore_pump_output.corpse = nil
offshore_pump_output.fluid_animation = nil
offshore_pump_output.glass_pictures = nil
offshore_pump_output.localised_name = {"entity-name.copper-pump"}
offshore_pump_output.minable = offshore_pump.minable
offshore_pump_output.name = "copper-pump-output"
offshore_pump_output.placeable_by = {item = "copper-pump", count = 1} -- Allow pressing Q on a pump
offshore_pump_output.pumping_speed = offshore_pump.pumping_speed
offshore_pump_output.selectable_in_game = true
offshore_pump_output.selection_box = offshore_pump.selection_box
offshore_pump_output.water_reflection = nil

offshore_pump_output.energy_source = {
	type = "burner",
	effectivity = 0.75,
	emissions_per_minute = 4,
	fuel_categories = {"chemical", data.raw["fuel-category"]["processed-chemical"] and "processed-chemical"},
	fuel_inventory_size = 1,
	light_flicker = {
		color = {1,0.6,0},
		derivation_change_frequency = 0.6,
		light_intensity_to_size_coefficient = 0.2,
		maximum_intensity = 0.25,
		minimum_intensity = 0.05,
		minimum_light_size = 1,
	},
	smoke = {{
		name = "smoke",
		deviation = {0.1, 0.1},
		frequency = 1.75,
		
		north_position = {0, -0.75},
		east_position = {0.5, -0.35},
		south_position = {0, 0},
		west_position = {-0.5, -0.35},
	}}
}
offshore_pump_output.energy_usage = "37.5kW"

data:extend({offshore_pump_output})

table.insert(offshore_pump.flags, "hide-alt-info")
offshore_pump.fluid_box.pipe_connections = {{position = {0, 0.6}}}
offshore_pump.localised_description = {"entity-description.copper-pump", "50.0 kW", offshore_pump_output.energy_source.effectivity * 100}
offshore_pump.selectable_in_game = false
