if not mods.IndustrialRevolution then
	return
end

local util = require("data-util")

local function fix_order(type, copy_to, copy_from, order)
	if (not data.raw[type][copy_to]) or (not data.raw[type][copy_from]) then return end

	data.raw[type][copy_to].order = order
	data.raw[type][copy_to].group = data.raw[type][copy_from].group
	data.raw[type][copy_to].subgroup = data.raw[type][copy_from].subgroup
end

-- Fix icon paths of new IR2 backbone technologies
data.raw.technology["electricity"].icon = "__aai-industry__/graphics/technology/burner-turbine.png"

-- Re-enable toolbelt
DIR.enable_technology("toolbelt")
util.tech_add_prerequisites("toolbelt-2", "toolbelt")

-- Fix upgrade targets
util.conditional_modify({
	type = "assembling-machine",
	name = "burner-assembling-machine",
	collision_box = data.raw["assembling-machine"]["assembling-machine-1"].collision_box,
	fast_replaceable_group = data.raw["assembling-machine"]["assembling-machine-1"].fast_replaceable_group,
})

util.conditional_modify({type = "lab", name = "burner-lab", next_upgrade = "copper-lab"})

-- Fix IR2 stuff overwritten by AAI
data.raw.item["electric-engine-unit"].localised_name = {"item-name.ir2-steel-motor"}
data.raw.item["engine-unit"].localised_name = {"item-name.ir2-combustion-engine"}
data.raw.technology["electric-engine"].localised_name = {"technology-name.ir2-steel-motor"}
data.raw.technology["electric-engine"].localised_description = {"technology-description.ir2-steel-motor"}
data.raw.technology["engine"].localised_name = {"technology-name.ir2-combustion-engine"}
data.raw.technology["engine"].localised_description = {"technology-description.ir2-combustion-engine"}

data.raw.technology["ir2-steam-power"].localised_name = {"technology-name.steam-power"}
data.raw.technology["ir2-steam-power"].localised_description = {"technology-description.steam-power"}

-- Fix ordering
fix_order("assembling-machine", "burner-assembling-machine", "assembling-machine-1", "z-aa-a")
fix_order("recipe", "fuel-processing", "rocket-fuel", "dz")
fix_order("item", "processed-fuel", "rocket-fuel", "dz")

for _,type in pairs({"item", "recipe"}) do
	fix_order(type, "fuel-processor", "electric-furnace", "zz[fuel-processor]")
	fix_order(type, "burner-turbine", "steam-engine", "c[burner-turbine]")
	fix_order(type, "burner-assembling-machine", "assembling-machine-1", "a")
	fix_order(type, "burner-lab", "lab", "-[burner-lab]")
	fix_order(type, "concrete-wall", "stone-wall", "aa")
	fix_order(type, "industrial-furnace", "electric-furnace", "machine-10-m")
	fix_order(type, "steel-wall", "stone-wall", "ba")
end

-- Add conceptual prerequisites to IR2 native technologies
util.tech_add_prerequisites("ir2-iron-forestry", "ir2-bronze-forestry")
util.tech_add_prerequisites("ir2-mining-1", "steam-mining")
util.tech_add_prerequisites("ir2-research-1", "steam-research")

-- Hide unused items; needs to run before IR2 data-final-fixes.lua
local items_to_hide = {"stone-tablet"}
for _,item in pairs(items_to_hide) do
	if not util.is_ingredient_used(item) then
		DIR.disable_recipes(util.find_recipes_with_result(item))
		DIR.hide_items{item}
	end
end

for _,item in pairs(data.raw.item) do  -- will be replaced later by IR2 equivalents
	if item.IR_replacement then
		local recipes = util.find_recipes_with_result(item.name)
		--util.remove_recipes_from_technologies(recipes)
		DIR.disable_recipes(recipes)
		DIR.hide_items{item.name}
	end
end

-- Entity balancing
data.raw["assembling-machine"]["burner-assembling-machine"].energy_source.emissions_per_minute = 3
data.raw.boiler["copper-boiler"].energy_source.emissions_per_minute = 18
data.raw["burner-generator"]["burner-turbine"].burner.emissions_per_minute = 22
data.raw["burner-generator"]["burner-turbine"].burner.fuel_inventory_size = 2
data.raw.lab["burner-lab"].energy_source.emissions_per_minute = 3

data.raw["assembling-machine"]["burner-assembling-machine"].energy_source.effectivity = 0.75
data.raw.boiler["copper-boiler"].energy_source.effectivity = 0.9
data.raw.furnace["bronze-furnace"].energy_source.effectivity = 0.9
data.raw.furnace["bronze-incinerator"].energy_source.effectivity = 0.9
data.raw.furnace["stone-furnace"].energy_source.effectivity = 0.75
data.raw.inserter["burner-inserter"].energy_source.effectivity = 0.75
data.raw.lab["burner-lab"].energy_source.effectivity = 0.75

util.conditional_modify({
	type = "assembling-machine",
	name = "burner-assembling-machine",
	max_health = 200,
})

util.conditional_modify({
	type = "assembling-machine",
	name = "industrial-furnace",
	crafting_categories = table.deepcopy(data.raw.furnace["electric-furnace"].crafting_categories),
	energy_source = {type = "electric", drain = "45kW", emissions_per_minute = 8, usage_priority = "secondary-input"},
	energy_usage = "1080kW",
})
data.raw["assembling-machine"]["industrial-furnace"].module_specification.module_slots = 4 -- was 5
data.raw["assembling-machine"]["arc-furnace"].allowed_effects = {"consumption", "pollution", "speed"}

util.conditional_modify({type = "burner-generator", name = "burner-turbine", max_power_output = "1MW"})
util.conditional_modify({
	type = "lab",
	name = "burner-lab",
	energy_usage = "125kW",
	max_health = 75,
	researching_speed = 0.75,
})

util.conditional_modify{type = "mining-drill", name = "steam-drill", energy_usage = "450kW"}
util.conditional_modify({type = "tile", name = "rough-stone-path", walking_speed_modifier = 1.1})
util.conditional_modify({type = "wall", name = "concrete-wall", max_health = 700})
util.conditional_modify({type = "wall", name = "steel-wall", max_health = 1500})

util.conditional_modify({
	type = "item",
	name = "processed-fuel",
	fuel_acceleration_multiplier = 1.5,
	fuel_top_speed_multiplier = 1.05,
	stack_size = 50,
})

require("prototypes/compatibility/industrial-revolution/copper-pump")

-- Balance toolbelts
data.raw.technology["toolbelt"].effects = {{ modifier = 2, type = "character-inventory-slots-bonus" }}
data.raw.technology["toolbelt-2"].effects = {{ modifier = 2, type = "character-inventory-slots-bonus" }}
data.raw.technology["toolbelt-3"].effects = {{ modifier = 3, type = "character-inventory-slots-bonus" }}
data.raw.technology["toolbelt-4"].effects = {{ modifier = 3, type = "character-inventory-slots-bonus" }}

-- Replace unavailable resources in wrecks with stone age ones
for _,container in pairs(data.raw.container) do
	if container.subgroup == "wrecks" and container.minable and container.minable.results then
		for _,result in pairs(container.minable.results) do
			if result.name == "iron-plate" then
				result.name = "tin-plate"
			elseif result.name == "steel-plate" then
				result.name = "stone-brick"
				result.amount = result.amount * 5
			end
		end
	end
end
data.raw["simple-entity"]["aai-small-ship-wreck"].minable.results = {{name="tin-plate", amount = 1}}

-- Make IR2 junkpiles resistant to fire
for _,entity in pairs(data.raw["simple-entity"]) do
	if entity.name:sub(-8) == "junkpile" and not entity.resistances then
		entity.resistances = {{type = "fire", percent = 100}}
	end
end
