-- SE sim: shield_projector_defense
local surface = game.surfaces.nauvis
local logo = surface.find_entities_filtered{name = "se-space-exploration-logo-shattered-15tiles", limit = 1}[1]
local center = {logo.position.x, logo.position.y+10.50}
game.camera_position = center
game.camera_zoom = 1
game.tick_paused = false
surface.daytime = 0

game.forces.player.worker_robots_speed_modifier = 3
game.forces.player.set_ammo_damage_modifier("laser", 1.1)

-- Used in vanilla sim to make biters look good
game.map_settings.steering.moving.force_unit_fuzzy_goto_behavior = true
game.map_settings.steering.moving.radius = 3

-- Spawn biters
local targets = surface.find_entities_filtered{name = {"shield-projector", "laser-turret"}, position = {21, 0}, radius = 10}
local target_count = #targets

local enemy_spawn = function(names, nb)
  for _ = 1, nb do
    local spawn_position = {center[1] - 60 + math.random(-35, 5), center[2] + math.random(-10, 10)}
    local name = names[math.random(#names)]
    local biter = surface.create_entity{name = name, position = spawn_position}
    biter.set_command({type = defines.command.attack, target = targets[math.random(target_count)]})
    biter.speed = 0.24 + (math.random() / 20)
  end
end

local biter_names = {"medium-biter", "medium-biter", "big-biter"}
local spiter_names = {"medium-spitter", "medium-spitter", "big-spitter"}
enemy_spawn(biter_names, 100)
enemy_spawn(spiter_names, 15)
