local data_util = require("data_util")
local RecipeTints = require("prototypes/recipe-tints")
local make_recipe = data_util.make_recipe

if not data.raw.recipe["sand-from-stone"] then
  data:extend({
    {
      ingredients = {
        { "stone", 1 }
      },
      name = "sand-from-stone",
      result = "sand",
      result_count = 2,
      type = "recipe",
      enabled = false,
      energy_required = 0.5,
    }
  })
end
data:extend({
  {
    ingredients = {
      { "stone", 1 }
    },
    name = data_util.mod_prefix .. "pulverised-sand",
    result = "sand",
    result_count = 3,
    type = "recipe",
    enabled = false,
    energy_required = 0.5,
    category = "pulverising",
    --localised_name = {"recipe-name."..data_util.mod_prefix .. "pulverised-sand"},
    always_show_made_in = true,
  }
})

if not data.raw.recipe["glass-from-sand"] then
  data:extend({
    {
      category = "smelting",
      energy_required = 4,
      ingredients = {
        { "sand", 4 }
      },
      name = "glass-from-sand",
      result = "glass",
      type = "recipe",
      enabled = false,
    },
  })
end

local naquium_tessaract_a = {r = 0.805, g = 0.055, b = 0.055, a = 1.000}
local naquium_tessaract_b = {r = 0.805, g = 0.055, b = 0.569, a = 1.000}

local naquium_processor_a = {r = 0.481, g = 0.805, b = 0.055, a = 1.000}
local naquium_processor_b = {r = 0.805, g = 0.279, b = 0.055, a = 1.000}

data:extend({
  {
    type = "recipe",
    name = data_util.mod_prefix .. "low-density-structure-beryllium",
    result = "low-density-structure",
    result_count = 2,
    energy_required = 10,
    ingredients = {
      { name = data_util.mod_prefix .. "aeroframe-scaffold", amount = 1},
      { name = "glass", amount = 2},
      { "steel-plate", 2 },
      { "plastic-bar", 2 }
    },
    icons = data_util.sub_icons(data.raw.item["low-density-structure"].icon,
                                data.raw.item[data_util.mod_prefix .. "aeroframe-scaffold"].icon),
    requester_paste_multiplier = 2,
    enabled = false,
    always_show_made_in = false,
    allow_as_intermediate = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "heat-shielding",
    result = data_util.mod_prefix .. "heat-shielding",
    energy_required = 10,
    ingredients = {
      { name = "stone-tablet", amount = 20},
      { "sulfur", 8 },
      { "steel-plate", 2 }
    },
    requester_paste_multiplier = 2,
    enabled = false,
    always_show_made_in = false,
  },
  {

    type = "recipe",
    name = data_util.mod_prefix .. "heat-shielding-iridium",
    result = data_util.mod_prefix .. "heat-shielding",
    result_count = 2,
    energy_required = 10,
    ingredients = {
      { name = data_util.mod_prefix .. "iridium-plate", amount = 1},
      { name = "stone-tablet", amount = 4},
      { "sulfur", 1 },
    },
    icons = data_util.sub_icons(data.raw.item[data_util.mod_prefix .. "heat-shielding"].icon,
                                data.raw.item[data_util.mod_prefix .. "iridium-plate"].icon),
    requester_paste_multiplier = 2,
    enabled = false,
    always_show_made_in = true,
    allow_as_intermediate = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "processing-unit-holmium",
    result = "processing-unit",
    result_count = 2,
    energy_required = 10,
    ingredients = {
      { "electronic-circuit", 10 },
      { "advanced-circuit", 1 },
      { name = data_util.mod_prefix .. "holmium-cable", amount = 4},
      { type = "fluid", name = "sulfuric-acid", amount = 2 },
    },
    icons = data_util.sub_icons(data.raw.item["processing-unit"].icon,
                                data.raw.item[data_util.mod_prefix .. "holmium-cable"].icon),
    requester_paste_multiplier = 3,
    enabled = false,
    always_show_made_in = true,
    allow_as_intermediate = false,
	  category = "crafting-with-fluid",
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "thruster-suit",
    result = data_util.mod_prefix .. "thruster-suit",
    enabled = false,
    energy_required = 30,
    ingredients = {
      { "rocket-control-unit", 10 },
      { data_util.mod_prefix .. "heat-shielding", 20 },
      { "low-density-structure", 20 },
      { "glass", 20 },
      { "jetpack-1", 1 },
      { data_util.mod_prefix .. "lifesupport-equipment-1", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "thruster-suit-2",
    results = {
      { name=data_util.mod_prefix .. "thruster-suit-2", amount = 1},
    },
    main_product = data_util.mod_prefix .. "thruster-suit-2",
    enabled = false,
    energy_required = 30,
    ingredients = {
      { "processing-unit", 50 },
      { "rocket-fuel", 50 },
      { data_util.mod_prefix .. "iridium-plate", 50 },
      { data_util.mod_prefix .. "material-catalogue-1", 1 },
      { data_util.mod_prefix .. "thruster-suit", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "thruster-suit-3",
    results = {
      { name=data_util.mod_prefix .. "thruster-suit-3", amount = 1},
    },
    main_product = data_util.mod_prefix .. "thruster-suit-3",
    enabled = false,
    energy_required = 30,
    ingredients = {
      { "processing-unit", 100 },
      { "rocket-fuel", 50 },
      { data_util.mod_prefix .. "superconductive-cable", 50 },
      { data_util.mod_prefix .. "astronomic-catalogue-1", 1 },
      { data_util.mod_prefix .. "biological-catalogue-1", 1 },
      { data_util.mod_prefix .. "energy-catalogue-3", 1 },
      { data_util.mod_prefix .. "material-catalogue-3", 1 },
      { data_util.mod_prefix .. "aeroframe-bulkhead", 1 },
      { data_util.mod_prefix .. "thruster-suit-2", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "thruster-suit-4",
    results = {
      { name=data_util.mod_prefix .. "thruster-suit-4", amount = 1},
    },
    main_product = data_util.mod_prefix .. "thruster-suit-4",
    enabled = false,
    energy_required = 30,
    ingredients = {
      { "processing-unit", 200 },
      { data_util.mod_prefix .. "antimatter-canister", 10 },
      { data_util.mod_prefix .. "nanomaterial", 200 },
      { data_util.mod_prefix .. "superconductive-cable", 100 },
      { data_util.mod_prefix .. "naquium-plate", 100 },
      { data_util.mod_prefix .. "deep-catalogue-2", 1 },
      { data_util.mod_prefix .. "self-sealing-gel", 1 },
      { data_util.mod_prefix .. "lattice-pressure-vessel", 1 },
      { data_util.mod_prefix .. "naquium-processor", 1 },
      { data_util.mod_prefix .. "thruster-suit-3", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "rtg-equipment",
    result = data_util.mod_prefix .. "rtg-equipment",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "processing-unit", 50 },
      { "low-density-structure", 50 },
      { "uranium-fuel-cell", 4 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "rtg-equipment-2",
    result = data_util.mod_prefix .. "rtg-equipment-2",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "processing-unit", 50 },
      { "low-density-structure", 100 },
      { data_util.mod_prefix .."atomic-data", 1 },
      { data_util.mod_prefix .."radiation-data", 1 },
      { data_util.mod_prefix .. "rtg-equipment", 4 },
      { data_util.mod_prefix .. "holmium-solenoid", 8 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "adaptive-armour-equipment-1",
    result = data_util.mod_prefix .. "adaptive-armour-equipment-1",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "steel-plate", 20 },
      { "advanced-circuit", 10 },
      { "battery", 5 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "adaptive-armour-equipment-2",
    result = data_util.mod_prefix .. "adaptive-armour-equipment-2",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "steel-plate", 30 },
      { "processing-unit", 10 },
      { "low-density-structure", 10 },
      { data_util.mod_prefix .. "adaptive-armour-equipment-1", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "adaptive-armour-equipment-3",
    result = data_util.mod_prefix .. "adaptive-armour-equipment-3",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "steel-plate", 40 },
      { "processing-unit", 10 },
      { data_util.mod_prefix .. "heat-shielding", 10 },
      { data_util.mod_prefix .. "adaptive-armour-equipment-2", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "adaptive-armour-equipment-4",
    result = data_util.mod_prefix .. "adaptive-armour-equipment-4",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "steel-plate", 50 },
      { "processing-unit", 20 },
      { data_util.mod_prefix .. "heat-shielding", 20 },
      { data_util.mod_prefix .. "adaptive-armour-equipment-3", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "adaptive-armour-equipment-5",
    result = data_util.mod_prefix .. "adaptive-armour-equipment-5",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "steel-plate", 40 },
      { "processing-unit", 30 },
      { data_util.mod_prefix .. "nanomaterial", 10 },
      { data_util.mod_prefix .. "adaptive-armour-equipment-4", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = "energy-shield-mk3-equipment",
    result = "energy-shield-mk3-equipment",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "energy-shield-mk2-equipment", 5 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = "energy-shield-mk4-equipment",
    result = "energy-shield-mk4-equipment",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "energy-shield-mk3-equipment", 5 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = "energy-shield-mk5-equipment",
    result = "energy-shield-mk5-equipment",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "energy-shield-mk4-equipment", 5 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = "energy-shield-mk6-equipment",
    result = "energy-shield-mk6-equipment",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { "energy-shield-mk5-equipment", 5 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },




  { -- 2
    type = "recipe",
    name = data_util.mod_prefix .. "aeroframe-pole",
    results = {{data_util.mod_prefix .. "aeroframe-pole", 1}},
    energy_required = 1,
    ingredients = {
      { "iron-stick", 1 },
      { data_util.mod_prefix .. "beryllium-plate", 2 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },
  { -- 8
    type = "recipe",
    name = data_util.mod_prefix .. "aeroframe-scaffold",
    result = data_util.mod_prefix .. "aeroframe-scaffold",
    result_count = 1,
    energy_required = 4,
    ingredients = {
      { data_util.mod_prefix .. "aeroframe-pole", 4 },
      { data_util.mod_prefix .. "cryonite-rod", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },
  { -- 32
    type = "recipe",
    name = data_util.mod_prefix .. "aeroframe-bulkhead",
    result = data_util.mod_prefix .. "aeroframe-bulkhead",
    energy_required = 4,
    ingredients = {
      { "low-density-structure", 2 },
      { data_util.mod_prefix .. "aeroframe-scaffold", 2 },
      { data_util.mod_prefix .. "beryllium-plate", 8 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },
  { -- 128
    type = "recipe",
    name = data_util.mod_prefix .. "lattice-pressure-vessel",
    result = data_util.mod_prefix .. "lattice-pressure-vessel",
    energy_required = 3,
    ingredients = {
      { data_util.mod_prefix .. "aeroframe-bulkhead", 3 },
      { data_util.mod_prefix .. "beryllium-plate", 16 },
      { type = "fluid", name = data_util.mod_prefix .. "chemical-gel", amount = 4 },
      { type = "fluid", name = data_util.mod_prefix .. "methane-gas", amount = 20 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
    category="space-manufacturing"
  },

  { --4
    type = "recipe",
    name = data_util.mod_prefix .. "heavy-girder",
    result = data_util.mod_prefix .. "heavy-girder",
    energy_required = 1,
    ingredients = {
      { data_util.mod_prefix .. "vulcanite-block", 1 },
      { data_util.mod_prefix .. "iridium-plate", 4 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },
  { -- 8
    type = "recipe",
    name = data_util.mod_prefix .. "heavy-bearing",
    result = data_util.mod_prefix .. "heavy-bearing",
    energy_required = 2,
    ingredients = {
      { data_util.mod_prefix .. "heavy-girder", 1 },
      { data_util.mod_prefix .. "iridium-plate", 4 },
      { type="fluid", name="lubricant", amount=4 },
    },
    category="crafting-with-fluid",
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },
  { -- 32
    type = "recipe",
    name = data_util.mod_prefix .. "heavy-composite",
    result = data_util.mod_prefix .. "heavy-composite",
    energy_required = 3,
    ingredients = {
      { data_util.mod_prefix .. "iridium-plate", 16 },
      { data_util.mod_prefix .. "heavy-girder", 4 },
      { data_util.mod_prefix .. "heat-shielding", 8 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },
  { -- 128
    type = "recipe",
    name = data_util.mod_prefix .. "heavy-assembly",
    result = data_util.mod_prefix .. "heavy-assembly",
    energy_required = 4,
    ingredients = {
      { data_util.mod_prefix .. "heavy-composite", 2 },
      { data_util.mod_prefix .. "heavy-bearing", 8 },
      { "electric-engine-unit", 2 },
      { type="fluid", name="lubricant", amount = 16 },
    },
    category="crafting-with-fluid",
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
  },


  { --0.5
    type = "recipe",
    name = data_util.mod_prefix .. "vitalic-acid",
    results = {
      { type = "fluid", name = data_util.mod_prefix .. "vitalic-acid", amount = 2}
    },
    energy_required = 2,
    ingredients = {
      { data_util.mod_prefix .. "vitamelange-extract", 1 },
      { type = "fluid", name = "sulfuric-acid", amount = 2 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
    enabled = false,
    category = "chemistry",
    subgroup = "vitamelange",
    crafting_machine_tint = RecipeTints.vita_tint,
    order = "a-e"
  },
  { -- 16
    type = "recipe",
    name = data_util.mod_prefix .. "bioscrubber",
    result = data_util.mod_prefix .. "bioscrubber",
    energy_required = 2,
    ingredients = {
      { type = "fluid", name = data_util.mod_prefix .. "vitalic-acid", amount = 30 },
      { "coal", 2 },
      { "glass", 2 },
      { "steel-plate", 2 },
    },
    crafting_machine_tint = RecipeTints.vita_tint,
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "chemistry",
  },
  { -- 8
    type = "recipe",
    name = data_util.mod_prefix .. "vitalic-reagent",
    result = data_util.mod_prefix .. "vitalic-reagent",
    energy_required = 3,
    ingredients = {
      { "glass", 4 },
      { data_util.mod_prefix .. "vitamelange-extract", 8 },
      { data_util.mod_prefix .. "vulcanite-block", 1 },
    },
    crafting_machine_tint = RecipeTints.vita_tint,
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "centrifuging",
    order = "a-g"
  },
  { -- 64
    type = "recipe",
    name = data_util.mod_prefix .. "vitalic-epoxy",
    result = data_util.mod_prefix .. "vitalic-epoxy",
    energy_required = 4,
    ingredients = {
      { data_util.mod_prefix .. "vitalic-reagent", 6 },
      { type = "fluid", name = data_util.mod_prefix .. "vitalic-acid", amount = 32 },
      { "sulfur", 8 },
    },
    crafting_machine_tint = RecipeTints.vita_tint,
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "chemistry",
    order = "a-h"
  },
  { -- 128
    type = "recipe",
    name = data_util.mod_prefix .. "self-sealing-gel",
    result = data_util.mod_prefix .. "self-sealing-gel",
    result_count = 2,
    energy_required = 5,
    ingredients = {
      { data_util.mod_prefix .. "vitalic-reagent", 4 },
      { data_util.mod_prefix .. "vitalic-epoxy", 3 },
      { data_util.mod_prefix .. "cryonite-rod", 4 },
      { type = "fluid", name = data_util.mod_prefix .. "methane-gas", amount = 32 },
    },
    crafting_machine_tint = RecipeTints.vita_tint,
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "space-biochemical",
    order = "a-i"
  },

  {
    type = "recipe",
    name = data_util.mod_prefix .. "naquium-cube",
    result = data_util.mod_prefix .. "naquium-cube",
    energy_required = 10,
    ingredients = {
      { type="fluid", name = data_util.mod_prefix .. "particle-stream", amount = 12 },
      { data_util.mod_prefix .. "naquium-plate", 12 },
      { data_util.mod_prefix .. "nanomaterial", 1 },
      { data_util.mod_prefix .. "vulcanite-block", 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "space-materialisation",
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "naquium-tessaract",
    main_product = data_util.mod_prefix .. "naquium-tessaract",
    energy_required = 20,
    ingredients = {
      { data_util.mod_prefix .. "naquium-cube", 1 },
      { data_util.mod_prefix .. "naquium-plate", 16 },
      { data_util.mod_prefix .. "cryonite-rod", 4 },
      { name = data_util.mod_prefix .. "arcosphere-a", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-b", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-c", amount = 1},
    },
    results = {
      { name = data_util.mod_prefix .. "naquium-tessaract", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-d", amount= 1 },
      { name = data_util.mod_prefix .. "arcosphere-e", amount= 1 },
      { name = data_util.mod_prefix .. "arcosphere-f", amount= 1 },
      { name = data_util.mod_prefix .. "arcosphere-g", amount= 0 },
      { name = data_util.mod_prefix .. "arcosphere-h", amount= 0 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "arcosphere",
    localised_description = {"space-exploration.arcosphere-random"},
    crafting_machine_tint =
    {
      primary = naquium_tessaract_a,
      secondary = naquium_tessaract_b,
    },
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "naquium-tessaract-alt",
    main_product = data_util.mod_prefix .. "naquium-tessaract",
    energy_required = 20,
    ingredients = {
      { data_util.mod_prefix .. "naquium-cube", 1 },
      { data_util.mod_prefix .. "naquium-plate", 16 },
      { data_util.mod_prefix .. "cryonite-rod", 4 },
      { name = data_util.mod_prefix .. "arcosphere-a", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-b", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-c", amount = 1},
    },
    results = {
      { name = data_util.mod_prefix .. "naquium-tessaract", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-d", amount= 0 },
      { name = data_util.mod_prefix .. "arcosphere-e", amount= 0 },
      { name = data_util.mod_prefix .. "arcosphere-f", amount= 1 },
      { name = data_util.mod_prefix .. "arcosphere-g", amount= 1 },
      { name = data_util.mod_prefix .. "arcosphere-h", amount= 1 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "arcosphere",
    localised_description = {"space-exploration.arcosphere-random"},
    crafting_machine_tint =
    {
      primary = naquium_tessaract_b,
      secondary = naquium_tessaract_a,
    },
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "naquium-processor",
    main_product = data_util.mod_prefix .. "naquium-processor",
    energy_required = 30,
    ingredients = {
      { data_util.mod_prefix .. "quantum-processor", 1 },
      { data_util.mod_prefix .. "naquium-tessaract", 1 },
      { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 4},
      { name = data_util.mod_prefix .. "arcosphere-c", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-d", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-e", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-f", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-g", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-h", amount = 1},
    },
    results = {
      {name = data_util.mod_prefix .. "naquium-processor", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-a", amount = 5},
      { name = data_util.mod_prefix .. "arcosphere-b", amount = 1},
    },
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "arcosphere",
    localised_description = {"space-exploration.arcosphere-random"},
    crafting_machine_tint =
    {
      primary = naquium_processor_a,
      secondary = naquium_processor_b,
    },
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "naquium-processor-alt",
    main_product = data_util.mod_prefix .. "naquium-processor",
    energy_required = 30,
    ingredients = {
      { data_util.mod_prefix .. "quantum-processor", 1 },
      { data_util.mod_prefix .. "naquium-tessaract", 1 },
      { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 4},
      { name = data_util.mod_prefix .. "arcosphere-c", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-d", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-e", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-f", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-g", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-h", amount = 1},
    },
    results = {
      {name = data_util.mod_prefix .. "naquium-processor", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-a", amount = 1},
      { name = data_util.mod_prefix .. "arcosphere-b", amount = 5},
    },
    requester_paste_multiplier = 1,
    always_show_made_in = true,
    enabled = false,
    category = "arcosphere",
    localised_description = {"space-exploration.arcosphere-random"},
    crafting_machine_tint =
    {
      primary = naquium_processor_b,
      secondary = naquium_processor_a,
    },
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "processed-fuel-from-solid-fuel",
    category = "fuel-refining",
    enabled = false,
    energy_required = 5,
    ingredients = {
      { "solid-fuel", 2 },
      { type = "fluid", name = data_util.mod_prefix .. "methane-gas", amount = 20 },
    },
    results = {
      { "processed-fuel", 5 },
    },
    icons = data_util.sub_icons(data.raw.item["processed-fuel"].icon,
                                data.raw.fluid[data_util.mod_prefix .. "methane-gas"].icon),
    icon_size = 64,
    requester_paste_multiplier = 1,
    allow_decomposition = false,
    always_show_made_in = true,
    subgroup = "fuel",
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "vitalic-hydrocarbon-extraction",
    localised_name = {"recipe-name."..data_util.mod_prefix .. "vitalic-hydrocarbon-extraction"},
    category = "oil-processing",
    order = "y",
    enabled = false,
    energy_required = 5,
    ingredients = {
      { data_util.mod_prefix .. "vitalic-reagent", 1 },
      { data_util.mod_prefix .. "vitamelange-bloom", 4 },
      { "processed-fuel", 4 },
      { type = "fluid", name = "petroleum-gas", amount = 40 },
    },
    results = {
      { type = "fluid", name = "crude-oil", amount = 20 },
      { "coal", 2 },
      { "wood", 3 },
    },
    icons = data_util.transition_icons(
      {
        icon = data.raw.item[data_util.mod_prefix .. "vitalic-reagent"].icon,
        icon_size = data.raw.item[data_util.mod_prefix .. "vitalic-reagent"].icon_size, scale = 0.5
      },
      {
        icon = data.raw.item["coal"].icon,
        icon_size = data.raw.item["coal"].icon_size, scale = 0.5
      }
    ),
    icon_size = 64,
    requester_paste_multiplier = 1,
    allow_decomposition = false,
    always_show_made_in = true,
    subgroup = "chemical",
  },
})
