local data_util = require("data_util")
local make_recipe = data_util.make_recipe

-- Note: telemetry cost: 1.1 coal, 3.9 stone, 5 copper, 6.4 iron, 82 water, 73 oil

function se_chemical_science_pack_recipe_override()
  data:extend({
    {
      type = "recipe",
      name = "chemical-science-pack",
      enabled = false,
      energy_required = 36,
      ingredients =
      {
        {"engine-unit", 1},
        {"advanced-circuit", 3},
        {"sulfur", 2}
      },
      result_count = 3,
      result = "chemical-science-pack"
    }
  })
end

function se_utility_science_pack_recipe_override()
  data:extend({
    {
        type = "recipe",
        name = "utility-science-pack",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 80,
        ingredients = {
          { data_util.mod_prefix .. "machine-learning-data", 4 },
          { data_util.mod_prefix .. "cryonite-rod", 8 }, -- 2 per output
          { "effectivity-module", 1 },
          { "solar-panel", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-warm", amount = 20 },
        },
        results = {
          { "utility-science-pack", 4},
          { data_util.mod_prefix .. "junk-data", 4},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icons = {
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/deep-2.png", icon_size = 64},
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/mask-2.png", icon_size = 64, tint = data_util.utility_science_tint},
        },
        icon_size = 64,
        main_product = "utility-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
  })
end

function se_production_science_pack_recipe_override()
  data:extend({
    {
        type = "recipe",
        name = "production-science-pack",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 60,
        ingredients = {
          { data_util.mod_prefix .. "machine-learning-data", 1 },
          { data_util.mod_prefix .. "vulcanite-block", 6 }, -- 2 per output
          { "productivity-module", 1 },
          { data_util.mod_prefix .. "iron-ingot", 5 },
          { type = "fluid", name = data_util.mod_prefix .. "plasma-stream", amount = 100 },
        },
        results = {
          { "production-science-pack", 3},
          { data_util.mod_prefix .. "junk-data", 1},
        },
        icons = {
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/deep-2.png", icon_size = 64},
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/mask-2.png", icon_size = 64, tint = data_util.production_science_tint},
        },
        icon_size = 64,
        main_product = "production-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
  })
end

data:extend({
  --[[{
    -- equivalent to 1 cargo rocket setion: (1/100) of a more expensive rocket
    -- but gives 1/10 of a silo rocket launch, so around 2-5 times more efficient than silo rockets
      type = "recipe",
      name = "space-science-pack",
      results = {{"space-science-pack", 100}},
      category = "space-manufacturing",
      enabled = false,
      energy_required = 20,
      ingredients = {
        { data_util.mod_prefix .. "heat-shielding", 10 },
        { "low-density-structure", 10 },
        { "rocket-control-unit", 10 },
        { data_util.mod_prefix .. "cargo-rocket-cargo-pod", 5 },
        { data_util.mod_prefix .. "cargo-rocket-fuel-tank", 1 }
      },
      main_product = "space-science-pack",
      requester_paste_multiplier = 1,
    },
    {
        -- this is much more efficient that rocket returns
        type = "recipe",
        name = "space-science-pack",
        results = {{"space-science-pack", 4}},
        category = "space-crafting",
        enabled = false,
        energy_required = 20,
        ingredients = {
          { data_util.mod_prefix .. "heat-shielding", 1 },
          { "low-density-structure", 1 },
          { "battery", 5 },
          { "processing-unit", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "liquid-rocket-fuel", amount = 20 },
        },
        main_product = "space-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },]]--
    {
        type = "recipe",
        name = data_util.mod_prefix .. "rocket-science-pack",
        category = "advanced-crafting",
        enabled = false,
        energy_required = 80,
        ingredients = {
          { "speed-module", 1 },
          { "electric-furnace", 1 },
          { data_util.mod_prefix .. "satellite-telemetry", 1 },
        },
        results = {
          { data_util.mod_prefix .. "rocket-science-pack", 8},
        },
        icon = "__space-exploration-graphics__/graphics/icons/beaker/orange.png",
        icon_size = 64,
        main_product = data_util.mod_prefix .. "rocket-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
    {
        type = "recipe",
        name = "space-science-pack",
        category = "space-crafting",
        enabled = false,
        energy_required = 75,
        ingredients = {
          { "stone", 5},
          { data_util.mod_prefix .. "space-transport-belt", 2},
          { "processing-unit", 1},
          { "rocket-fuel", 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-water", amount = 1 },
        },
        results = {
          { "space-science-pack", 5},
        },
        icons = {
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/deep-1.png", icon_size = 64},
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/mask-1.png", icon_size = 64},
        },
        icon_size = 64,
        main_product = "space-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "astronomic-catalogue-1", 1 },
          { data_util.mod_prefix .. "beryllium-plate", 20 },
          { data_util.mod_prefix .. "astronomic-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "astronomic-science-pack-1", 2},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "astronomic-catalogue-2", 1 },
          { data_util.mod_prefix .. "astronomic-science-pack-1", 2 },
          { data_util.mod_prefix .. "aeroframe-pole", 40 },
          { data_util.mod_prefix .. "astronomic-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "astronomic-science-pack-2", 4},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "astronomic-catalogue-3", 1 },
          { data_util.mod_prefix .. "astronomic-science-pack-2", 4 },
          { data_util.mod_prefix .. "aeroframe-scaffold", 30 },
          { data_util.mod_prefix .. "astronomic-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "astronomic-science-pack-3", 6},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "astronomic-catalogue-4", 1 },
          { data_util.mod_prefix .. "astronomic-science-pack-3", 6 },
          { data_util.mod_prefix .. "aeroframe-bulkhead", 10 },
          { data_util.mod_prefix .. "astronomic-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "astronomic-science-pack-4", 8},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "biological-catalogue-1", 1 },
          { data_util.mod_prefix .. "vitamelange-extract", 20 },
          { data_util.mod_prefix .. "biological-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "biological-science-pack-1", 2},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "biological-catalogue-2", 1 },
          { data_util.mod_prefix .. "biological-science-pack-1",2 },
          { data_util.mod_prefix .. "bioscrubber", 10 },
          { data_util.mod_prefix .. "biological-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "biological-science-pack-2", 4},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "biological-catalogue-3", 1 },
          { data_util.mod_prefix .. "biological-science-pack-2", 4 },
          { data_util.mod_prefix .. "vitalic-reagent", 40 },
          { data_util.mod_prefix .. "biological-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "biological-science-pack-3", 6},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "biological-catalogue-4", 1 },
          { data_util.mod_prefix .. "biological-science-pack-3", 6 },
          { data_util.mod_prefix .. "vitalic-epoxy", 10 },
          { data_util.mod_prefix .. "core-fragment-".. data_util.mod_prefix .."vitamelange", 1 },
          { data_util.mod_prefix .. "biological-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "biological-science-pack-4", 8},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "material-catalogue-1", 1 },
          { data_util.mod_prefix .. "iridium-plate", 20 },
          { data_util.mod_prefix .. "material-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "material-science-pack-1", 2},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "material-catalogue-2", 1 },
          { data_util.mod_prefix .. "material-science-pack-1", 2 },
          { data_util.mod_prefix .. "heavy-girder", 10 },
          { data_util.mod_prefix .. "material-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "material-science-pack-2", 4},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "material-catalogue-3", 1 },
          { data_util.mod_prefix .. "material-science-pack-2", 4 },
          { data_util.mod_prefix .. "heavy-bearing", 15 },
          { data_util.mod_prefix .. "material-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "material-science-pack-3", 6},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "material-catalogue-4", 1 },
          { data_util.mod_prefix .. "material-science-pack-3", 6 },
          { data_util.mod_prefix .. "heavy-composite", 10 },
          { data_util.mod_prefix .. "material-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "material-science-pack-4", 8},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "energy-catalogue-1", 1 },
          { data_util.mod_prefix .. "holmium-plate", 20 },
          { data_util.mod_prefix .. "energy-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "energy-science-pack-1", 2},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "energy-catalogue-2", 1 },
          { data_util.mod_prefix .. "energy-science-pack-1", 2 },
          { data_util.mod_prefix .. "holmium-cable", 20 },
          { data_util.mod_prefix .. "energy-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "energy-science-pack-2", 4},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "energy-catalogue-3", 1 },
          { data_util.mod_prefix .. "energy-science-pack-2", 4 },
          { data_util.mod_prefix .. "holmium-solenoid", 15 },
          { data_util.mod_prefix .. "energy-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "energy-science-pack-3", 6},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { data_util.mod_prefix .. "energy-catalogue-4", 1 },
          { data_util.mod_prefix .. "energy-science-pack-3", 6 },
          { data_util.mod_prefix .. "quantum-processor", 5 },
          { data_util.mod_prefix .. "energy-insight", 1 },
          { data_util.mod_prefix .. "significant-data", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { data_util.mod_prefix .. "energy-science-pack-4", 8},
          { data_util.mod_prefix .. "junk-data", 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    --[[{
        type = "recipe",
        name = "space-science-pack",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 20,
        ingredients = {
          { data_util.mod_prefix .. "significant-data", 100 },
          { data_util.mod_prefix .. "lifesupport-canister", 1 },
          { data_util.mod_prefix .. "space-mirror", 1 },
          { data_util.mod_prefix .. "space-platform-scaffold", 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 100},
        },
        results = {
          { "space-science-pack", 5},
          { data_util.mod_prefix .. "junk-data", 100},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 100},
        },
        icon = data.raw.tool["space-science-pack"].icon,
        icon_size = 64,
        main_product = "space-science-pack",
        requester_paste_multiplier = 1,
    },]]--
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 60,
        ingredients = {
          { data_util.mod_prefix .. "significant-data", 1 },
          { data_util.mod_prefix .. "deep-catalogue-1", 1 },
          { name = data_util.mod_prefix .. "naquium-plate", amount = 10},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 100},
        },
        results = {
          { data_util.mod_prefix .. "deep-space-science-pack-1", 2},
          { data_util.mod_prefix .. "junk-data", 4},
          { data_util.mod_prefix .. "broken-data", 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 100},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-1"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 120,
        ingredients = {
          { data_util.mod_prefix .. "deep-space-science-pack-1", 2},
          { data_util.mod_prefix .. "significant-data", 1 },
          { data_util.mod_prefix .. "deep-catalogue-2", 1 },
          { name = data_util.mod_prefix .. "naquium-cube", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 200},
        },
        results = {
          { data_util.mod_prefix .. "deep-space-science-pack-2", 4},
          { data_util.mod_prefix .. "junk-data", 4},
          { data_util.mod_prefix .. "broken-data", 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 200},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-2"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 180,
        ingredients = {
          { data_util.mod_prefix .. "deep-space-science-pack-2", 4},
          { data_util.mod_prefix .. "significant-data", 1 },
          { data_util.mod_prefix .. "deep-catalogue-3", 1 },
          { name = data_util.mod_prefix .. "naquium-tessaract", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 200},
        },
        results = {
          { data_util.mod_prefix .. "deep-space-science-pack-3", 6},
          { data_util.mod_prefix .. "junk-data", 4},
          { data_util.mod_prefix .. "broken-data", 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 200},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-3"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 240,
        ingredients = {
          { data_util.mod_prefix .. "deep-space-science-pack-3", 6},
          { data_util.mod_prefix .. "significant-data", 1 },
          { data_util.mod_prefix .. "deep-catalogue-4", 1 },
          { name = data_util.mod_prefix .. "naquium-processor", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 200},
        },
        results = {
          { data_util.mod_prefix .. "deep-space-science-pack-4", 8},
          { data_util.mod_prefix .. "junk-data", 4},
          { data_util.mod_prefix .. "broken-data", 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 200},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-4"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },

})
