if not mods.IndustrialRevolution then
    return
end

local util = require("data-util")

-- Limit burner lab science packs
data.raw.lab["burner-lab"].inputs = {"automation-science-pack"}

-- Replace AAI items with IR2 versions
for _,item in pairs(data.raw.item) do
	if item.IR_replacement then
		util.find_and_replace_ingredients{[item.name] = item.IR_replacement}
	end
end

-- Hide unused technologies
for _,tech in pairs(data.raw.technology) do
	if tech.IR_disabled then
		DIR.disable_technology(tech.name)
	end
end

-- Add "crafting-0" category to all characters which had crafting category
for _,character in pairs(data.raw.character) do
	if character.crafting_categories and util.table_contains(character.crafting_categories, "crafting") then
		table.insert(character.crafting_categories, "crafting-0")
	end
end
table.insert(data.raw["god-controller"].default.crafting_categories, "crafting-0")
