local util = require("data-util")

data.raw.recipe["sulfur"].allow_decomposition = false -- It falsely shows that water is produced from light oil

for _, recipe in pairs(data.raw.recipe) do
	if recipe.category and recipe.category:find("casting") then
		recipe.allow_decomposition = false -- Don't decompose ingredients into molten metals
	end
end

-- Recipe overhaul of AAII entities
util.conditional_modify({
	type = "recipe",
	name = "burner-assembling-machine",
	ingredients = {
		{type="item", name="burner-inserter", amount=2},
		{type="item", name="tin-frame-large", amount=1},
		{type="item", name="tin-gear-wheel", amount=4},
	}
})
util.recipe_set_time("burner-assembling-machine", DIR.standard_crafting_time * 2)

util.conditional_modify({
	type = "recipe",
	name = "burner-lab",
	ingredients = {
		{type="item", name="copper-motor", amount=4},
		{type="item", name="tin-frame-large", amount=1},
		{type="item", name="tin-plate", amount=8},
	}
})
util.recipe_set_time("burner-lab", DIR.standard_crafting_time * 3)

util.conditional_modify({
	type = "recipe",
	name = "burner-turbine",
	ingredients = {
		{type="item", name="copper-motor", amount=16},
		{type="item", name="iron-plate", amount=40},
		{type="item", name="iron-beam", amount=12},
		{type="item", name="iron-gear-wheel", amount=24},
		{type="item", name="iron-piston", amount=12},
	}
})
util.recipe_set_time("burner-turbine", DIR.standard_crafting_time * 4)

util.conditional_modify({
	type = "recipe",
	name = "fuel-processor",
	ingredients = {
		{type="item", name="burner-inserter", amount=2},
		{type="item", name="stone-brick", amount=32},
		{type="item", name="tin-frame-large", amount=1},
	}
})
util.recipe_set_time("fuel-processor", DIR.standard_crafting_time * 5)

util.conditional_modify({
	type = "recipe",
	name = "industrial-furnace",
	ingredients = {
		{type="item", name="copper-cable-heavy", amount=3},
		{type="item", name="invar-plate-special", amount=36},
		{type="item", name="junction-box", amount=1},
		{type="item", name="refined-concrete", amount=10},
		{type="item", name="stainless-frame-large", amount=1},
	}
})
util.recipe_set_time("industrial-furnace", DIR.standard_crafting_time * 8)

-- Walls
util.recipe_set_time("concrete-wall", DIR.standard_crafting_time * 2)
util.replace_or_add_ingredient(data.raw.recipe["steel-plate-wall"], "stone-wall", "concrete-wall", 1)
util.conditional_modify({
	type = "recipe",
	name = "steel-wall",
	ingredients = {
		{type="item", name="stainless-plate-heavy", amount=4},
		{type="item", name="stainless-rod", amount=8},
		{type="item", name="steel-plate-wall", amount=1},
	}
})
util.recipe_set_time("steel-wall", DIR.standard_crafting_time * 6)

-- IR2 items
util.replace_or_add_ingredient(data.raw.recipe["assembling-machine-1"], nil, "steam-pipe", 2)
util.replace_or_add_ingredient(data.raw.recipe["assembling-machine-2"], nil, "pipe", 2)
util.replace_or_add_ingredient(data.raw.recipe["assembling-machine-3"], nil, "steel-pipe", 2)
util.replace_or_add_ingredient(data.raw.recipe["cargo-wagon"], "iron-plate-heavy", "iron-plate-heavy", 40)
util.replace_or_add_ingredient(data.raw.recipe["chemical-plant"], nil, "glass", 10)
util.replace_or_add_ingredient(data.raw.recipe["fluid-wagon"], "bronze-plate-special", "bronze-plate-special", 32)

-- Add motors to IR2 machines
util.replace_or_add_ingredient(data.raw.recipe["copper-grinder"], nil, "copper-motor", 2)
util.replace_or_add_ingredient(data.raw.recipe["copper-lab"], "copper-gear-wheel", "copper-motor", 4)
util.replace_or_add_ingredient(data.raw.recipe["copper-mixer"], nil, "copper-motor", 1)

util.conditional_modify({
	type = "recipe",
	name = "copper-pump",
	ingredients = {
		{type="item", name="copper-pipe", amount=2},
		{type="item", name="copper-plate", amount=2},
		{type="item", name="copper-motor", amount=1},
		{type="item", name="copper-piston", amount=1},
	}
})

util.replace_or_add_ingredient(data.raw.recipe["lab"], nil, "iron-motor", 4)

util.conditional_modify({
	type = "recipe",
	name = "offshore-pump",
	ingredients = {
		{type="item", name="pipe", amount=4},
		{type="item", name="iron-plate", amount=4},
		{type="item", name="iron-motor", amount=2},
		{type="item", name="iron-piston", amount=2},
	}
})

util.replace_or_add_ingredient(data.raw.recipe["oil-refinery"], nil, "iron-motor", 10)
util.replace_or_add_ingredient(data.raw.recipe["pumpjack"], nil, "iron-motor", 4)
util.replace_or_add_ingredient(data.raw.recipe["radar"], nil, "iron-motor", 1)
util.replace_or_add_ingredient("rocket-silo", nil, "electric-engine-unit", 32)
util.replace_or_add_ingredient("rocket-silo", "pipe", "steel-pipe", 40)
util.replace_or_add_ingredient("steam-drill", nil, "copper-motor", 8)
util.replace_or_add_ingredient(data.raw.recipe["steam-engine"], "iron-gear-wheel", "iron-motor", 8)

util.conditional_modify({
	type = "recipe",
	name = "steam-turbine",
	ingredients = {
		{type="item", name="invar-plate-special", amount=24},
		{type="item", name="chromium-plate-heavy", amount=40},
		{type="item", name="chromium-gear-wheel", amount=24},
		{type="item", name="chromium-piston", amount=24},
		{type="item", name="electric-engine-unit", amount=16},
	}
})

-- Add motors to IR2 belts
util.conditional_modify({
	type = "recipe",
	name = "transport-belt",
	ingredients = {
		{type="item", name="tin-plate", amount=2},
		{type="item", name="copper-gear-wheel", amount=2},
		{type="item", name="copper-motor", amount=1},
	},
	results = {{type="item", name="transport-belt", amount=4}}
})
util.recipe_set_time("transport-belt", DIR.standard_crafting_time * 2)
util.replace_or_add_ingredient(data.raw.recipe["splitter"], nil, "copper-motor", 1)

util.conditional_modify({
	type = "recipe",
	name = "fast-transport-belt",
	ingredients = {
		{type="item", name="rubber", amount=2},
		{type="item", name="iron-plate", amount=2},
		{type="item", name="iron-motor", amount=1},
	},
	results = {{type="item", name="fast-transport-belt", amount=2}}
})
util.recipe_set_time("fast-transport-belt", DIR.standard_crafting_time * 2)
util.replace_or_add_ingredient(data.raw.recipe["fast-splitter"], nil, "iron-motor", 1)

util.conditional_modify({
	type = "recipe",
	name = "express-transport-belt",
	ingredients = {
		{type="item", name="rubber", amount=2},
		{type="item", name="steel-plate", amount=2},
		{type="item", name="electric-engine-unit", amount=1},
		{type="fluid", name="lubricant", amount=20},
	},
	results = {{type="item", name="express-transport-belt", amount=2}}
})
util.recipe_set_time("express-transport-belt", DIR.standard_crafting_time * 2)

util.conditional_modify({
	type = "recipe",
	name = "express-splitter",
	ingredients = {
		{type="item", name="advanced-circuit", amount=1},
		{type="item", name="express-transport-belt", amount=4},
		{type="item", name="steel-plate", amount=2},
		{type="item", name="steel-gear-wheel", amount=4},
		{type="item", name="electric-engine-unit", amount=1},
	},
	results = {{type="item", name="express-splitter", amount=2}}
})
util.recipe_set_time("express-splitter", DIR.standard_crafting_time * 4)
