if not mods.IndustrialRevolution then return end

local function disable_setting(type, name, value)
	local setting = data.raw[type .. "-setting"][name]
	setting.hidden = true
	if type == "bool" then
		setting.forced_value = value
	else
		setting.default_value = value
		setting.allowed_values = {value}
	end
end

-- IR2 settings
data.raw["string-setting"]["ir2-starting-age"].allowed_values = {"burner", "steam", "bronze", "iron", "steel", "chrome"}
data.raw["string-setting"]["ir2-starting-age"].default_value = "burner"

-- AAI settings
data.raw["int-setting"]["aai-burner-turbine-efficiency"].maximum_value = 90
data.raw["int-setting"]["aai-fuel-processor-efficiency"].maximum_value = 20

disable_setting("bool", "aai-fast-motor-crafting", false)
disable_setting("bool", "aai-wide-drill", false)
disable_setting("int", "quick-start-science", 0)
