-- Fake water wube used for a Runway menusim where the regular logo would be misaligned to the train grid
local water_wube_dirt = table.deepcopy(data.raw.container["factorio-logo-11tiles"])
water_wube_dirt.type = "simple-entity"
water_wube_dirt.name = "water-wube-dirt"
water_wube_dirt.icon = "__base__/graphics/icons/water-wube.png"
water_wube_dirt.collision_box = {{-0.4, -0.4}, {0.4, 0.4}} -- Small collision box
water_wube_dirt.selection_box = {{-2.5, -2.5}, {2.5, 2.5}}
water_wube_dirt.collision_mask = {}
water_wube_dirt.picture = {
  filename = "__space-exploration-menu-simulations__/graphics/water-wube-dirt.png",
  width = 146,
  height = 143,
  priority = "extra-high",
  scale = 1,
  shift = util.by_pixel(1, 4),
  hr_version = {
    filename = "__space-exploration-menu-simulations__/graphics/hr-water-wube-dirt.png",
    width = 292,
    height = 285,
    priority = "extra-high",
    scale = 0.5,
    shift = util.by_pixel(1, 4),
  }
}
water_wube_dirt.render_layer = "water-tile" -- Draw shadows and decorations over it

-- Plain wube logo used for spaceship sims
local wube_logo_plain = table.deepcopy(water_wube_dirt)
wube_logo_plain.name = "wube-logo-plain"
wube_logo_plain.picture = {
  filename = "__core__/graphics/wube-logo.png",
  width = 219,
  height = 219,
  priority = "extra-high",
  scale = 0.65,
  shift = util.by_pixel(0, 5),
}

data:extend({
  water_wube_dirt,
  wube_logo_plain,
})
