local data_util = require("data_util")
local function stack_size(width)
  if width >= 9 then
    return 1
  elseif width >= 8 then
    return 2
  elseif width >= 7 then
    return 5
  elseif width >= 6 then
    return 10
  elseif width >= 5 then
    return 15
  elseif width >= 4 then
    return 25
  elseif width >= 3 then
    return 50
  end
end


data:extend({
  {
    type = "item",
    name = data_util.mod_prefix .. "casting-machine",
    icon = "__space-exploration-graphics-2__/graphics/icons/casting-machine.png",
    icon_size = 64,
    subgroup = "smelting-machine",
    order = "d",
    stack_size = 50,
    place_result = data_util.mod_prefix .. "casting-machine",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "fuel-refinery",
    icon = "__space-exploration-graphics__/graphics/icons/fuel-refinery.png",
    icon_size = 64,
    order = "z-d[refinery]-e[fuel-refinery]",
    subgroup = "chemistry",
    stack_size = 10,
    place_result = data_util.mod_prefix .. "fuel-refinery",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "fluid-burner-generator",
    icon = "__space-exploration-graphics__/graphics/icons/fluid-burner-generator.png",
    icon_size = 64,
    order = "z-d[fluid-burner-generator]",
    subgroup = "energy",
    stack_size = 20,
    place_result = data_util.mod_prefix .. "fluid-burner-generator",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "antimatter-reactor",
    icon = "__space-exploration-graphics__/graphics/icons/antimatter-reactor.png",
    icon_size = 64,
    order = "f[antimatter]-a[reactor]-b",
    subgroup = "energy",
    stack_size = stack_size(9),
    place_result = data_util.mod_prefix .. "antimatter-reactor",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "naquium-heat-pipe",
    icon = "__space-exploration-graphics__/graphics/icons/naquium-heat-pipe.png",
    icon_size = 64,
    order = "f[nuclear-energy]-b[heat-pipe]-m",
    subgroup = "energy",
    stack_size = 50,
    place_result = data_util.mod_prefix .. "naquium-heat-pipe",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "dimensional-anchor",
    icon = "__space-exploration-graphics__/graphics/icons/dimensional-anchor.png",
    icon_size = 64,
    order = "z-a-".."dimensional-anchor",
    stack_size = stack_size(9),
    subgroup = "beaming",
    place_result = data_util.mod_prefix .. "dimensional-anchor",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "pulveriser",
    icon = "__space-exploration-graphics__/graphics/icons/pulveriser.png",
    icon_size = 64,
    order = "z-d-z",
    stack_size = stack_size(7),
    subgroup = "mechanical",
    place_result = data_util.mod_prefix .. "pulveriser",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "addon-power-pole",
    icon = "__space-exploration-graphics__/graphics/icons/addon-power-pole.png",
    icon_size = 64,
    order = "z-p-a",
    stack_size = 50,
    subgroup = "energy-pipe-distribution",
    place_result = data_util.mod_prefix .. "addon-power-pole",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "pylon",
    icon = "__space-exploration-graphics__/graphics/icons/pylon.png",
    icon_size = 64,
    order = "z-p-a",
    stack_size = 50,
    subgroup = "energy-pipe-distribution",
    place_result = data_util.mod_prefix .. "pylon",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "pylon-substation",
    icon = "__space-exploration-graphics__/graphics/icons/pylon-substation.png",
    icon_size = 64,
    order = "z-p-b",
    stack_size = 50,
    subgroup = "energy-pipe-distribution",
    place_result = data_util.mod_prefix .. "pylon-substation",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "pylon-construction",
    icon = "__space-exploration-graphics__/graphics/icons/pylon-construction.png",
    icon_size = 64,
    order = "z-p-c",
    stack_size = 50,
    subgroup = "energy-pipe-distribution",
    place_result = data_util.mod_prefix .. "pylon-construction",
    flags = {"draw-logistic-overlay"}
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "pylon-construction-radar",
    icon = "__space-exploration-graphics__/graphics/icons/pylon-construction-radar.png",
    icon_size = 64,
    order = "z-p-d",
    stack_size = 50,
    subgroup = "energy-pipe-distribution",
    place_result = data_util.mod_prefix .. "pylon-construction-radar",
    flags = {"draw-logistic-overlay"}
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-assembling-machine",
    icon = "__space-exploration-graphics__/graphics/icons/assembling-machine.png",
    icon_size = 64,
    order = "z-a-".."space-assembling-machine",
    stack_size = stack_size(3),
    subgroup = "assembling",
    place_result = data_util.mod_prefix .. "space-assembling-machine",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-astrometrics-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/astrometrics-laboratory.png",
    icon_size = 64,
    order = "a-a",
    stack_size = stack_size(5),
    subgroup = "computation",
    place_result = data_util.mod_prefix .. "space-astrometrics-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-biochemical-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/biochemical-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-biochemical-laboratory",
    stack_size = stack_size(7),
    subgroup = "chemistry",
    place_result = data_util.mod_prefix .. "space-biochemical-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-electromagnetics-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/electromagnetics-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-electromagnetics-laboratory",
    stack_size = stack_size(7),
    subgroup = "plasma",
    place_result = data_util.mod_prefix .. "space-electromagnetics-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-decontamination-facility",
    icon = "__space-exploration-graphics__/graphics/icons/decontamination-facility.png",
    icon_size = 64,
    order = "z-a-".."space-decontamination-facility",
    stack_size = stack_size(6),
    subgroup = "chemistry",
    place_result = data_util.mod_prefix .. "space-decontamination-facility",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-genetics-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/genetics-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-genetics-laboratory",
    stack_size = stack_size(7),
    subgroup = "chemistry",
    place_result = data_util.mod_prefix .. "space-genetics-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-gravimetrics-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/gravimetrics-laboratory.png",
    icon_size = 64,
    order = "a-b",
    stack_size = stack_size(5),
    subgroup = "computation",
    place_result = data_util.mod_prefix .. "space-gravimetrics-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-growth-facility",
    icon = "__space-exploration-graphics__/graphics/icons/growth-facility.png",
    icon_size = 64,
    order = "z-a-".."space-growth-facility",
    stack_size = stack_size(9),
    subgroup = "chemistry",
    place_result = data_util.mod_prefix .. "space-growth-facility",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-hypercooler",
    icon = "__space-exploration-graphics__/graphics/icons/hypercooler.png",
    icon_size = 64,
    order = "z-a-".."space-hypercooler",
    stack_size = stack_size(5),
    subgroup = "cooling",
    place_result = data_util.mod_prefix .. "space-hypercooler",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-laser-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/laser-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-laser-laboratory",
    stack_size = stack_size(7),
    subgroup = "plasma",
    place_result = data_util.mod_prefix .. "space-laser-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "lifesupport-facility",
    icon = "__space-exploration-graphics__/graphics/icons/lifesupport-facility.png",
    icon_size = 64,
    order = "z-a-".."lifesupport-facility",
    stack_size = stack_size(6),
    subgroup = "chemistry",
    place_result = data_util.mod_prefix .. "lifesupport-facility",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-manufactory",
    icon = "__space-exploration-graphics__/graphics/icons/manufactory.png",
    icon_size = 64,
    order = "z-a-".."space-manufactory",
    stack_size = stack_size(9),
    subgroup = "assembling",
    place_result = data_util.mod_prefix .. "space-manufactory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-material-fabricator",
    icon = "__space-exploration-graphics__/graphics/icons/material-fabricator.png",
    icon_size = 64,
    order = "z-a-".."space-material-fabricator",
    stack_size = stack_size(9),
    subgroup = "plasma",
    place_result = data_util.mod_prefix .. "space-material-fabricator",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-mechanical-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/mechanical-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-mechanical-laboratory",
    stack_size = stack_size(7),
    subgroup = "mechanical",
    place_result = data_util.mod_prefix .. "space-mechanical-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-particle-accelerator",
    icon = "__space-exploration-graphics__/graphics/icons/particle-accelerator.png",
    icon_size = 64,
    order = "z-a-".."space-particle-accelerator",
    stack_size = stack_size(9),
    subgroup = "plasma",
    place_result = data_util.mod_prefix .. "space-particle-accelerator",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-particle-collider",
    icon = "__space-exploration-graphics__/graphics/icons/particle-collider.png",
    icon_size = 64,
    order = "z-a-".."space-particle-collider",
    stack_size = stack_size(9),
    subgroup = "plasma",
    place_result = data_util.mod_prefix .. "space-particle-collider",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-plasma-generator",
    icon = "__space-exploration-graphics__/graphics/icons/plasma-generator.png",
    icon_size = 64,
    order = "z-a-".."space-plasma-generator",
    stack_size = stack_size(7),
    subgroup = "plasma",
    place_result = data_util.mod_prefix .. "space-plasma-generator",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-radiation-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/radiation-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-radiation-laboratory",
    stack_size = stack_size(7),
    subgroup = "radiation",
    place_result = data_util.mod_prefix .. "space-radiation-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-radiator",
    icon = "__space-exploration-graphics__/graphics/icons/radiator.png",
    icon_size = 64,
    order = "z-a-".."space-radiator",
    stack_size = stack_size(3),
    subgroup = "cooling",
    place_result = data_util.mod_prefix .. "space-radiator",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-radiator-2",
    icon = "__space-exploration-graphics__/graphics/icons/radiator-blue.png",
    icon_size = 64,
    order = "z-a-".."space-radiator-2",
    stack_size = stack_size(3),
    subgroup = "cooling",
    place_result = data_util.mod_prefix .. "space-radiator-2",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "recycling-facility",
    icon = "__space-exploration-graphics__/graphics/icons/recycling-facility.png",
    icon_size = 64,
    order = "z-a-".."recycling-facility",
    stack_size = stack_size(7),
    subgroup = "mechanical",
    place_result = data_util.mod_prefix .. "recycling-facility",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-supercomputer-1",
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-1.png",
    icon_size = 64,
    order = "z-a-".."space-supercomputer",
    stack_size = stack_size(5),
    subgroup = "computation",
    place_result = data_util.mod_prefix .. "space-supercomputer-1",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-supercomputer-2",
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-2.png",
    icon_size = 64,
    order = "z-a-".."space-supercomputer",
    stack_size = stack_size(5),
    subgroup = "computation",
    place_result = data_util.mod_prefix .. "space-supercomputer-2",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-supercomputer-3",
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-3.png",
    icon_size = 64,
    order = "z-a-".."space-supercomputer",
    stack_size = stack_size(5),
    subgroup = "computation",
    place_result = data_util.mod_prefix .. "space-supercomputer-3",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-supercomputer-4",
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-4.png",
    icon_size = 64,
    order = "z-a-".."space-supercomputer",
    stack_size = stack_size(5),
    subgroup = "computation",
    place_result = data_util.mod_prefix .. "space-supercomputer-4",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-telescope",
    icon = "__space-exploration-graphics__/graphics/icons/telescope.png",
    icon_size = 64,
    order = "z-a-".."space-telescope",
    stack_size = stack_size(3),
    subgroup = "telescope",
    place_result = data_util.mod_prefix .. "space-telescope",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-telescope-xray",
    icon = "__space-exploration-graphics__/graphics/icons/telescope-xray.png",
    icon_size = 64,
    order = "z-a-".."space-telescope-xray",
    stack_size = stack_size(5),
    subgroup = "telescope",
    place_result = data_util.mod_prefix .. "space-telescope-xray",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-telescope-gammaray",
    icon = "__space-exploration-graphics__/graphics/icons/telescope-gammaray.png",
    icon_size = 64,
    order = "z-a-".."space-telescope-gammaray",
    stack_size = stack_size(5),
    subgroup = "telescope",
    place_result = data_util.mod_prefix .. "space-telescope-gammaray",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-telescope-microwave",
    icon = "__space-exploration-graphics__/graphics/icons/telescope-microwave.png",
    icon_size = 64,
    order = "z-a-".."space-telescope-microwave",
    stack_size = stack_size(9),
    subgroup = "telescope",
    place_result = data_util.mod_prefix .. "space-telescope-microwave",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-telescope-radio",
    icon = "__space-exploration-graphics__/graphics/icons/telescope-radio.png",
    icon_size = 64,
    order = "z-a-".."space-telescope-radio",
    stack_size = stack_size(9),
    subgroup = "telescope",
    place_result = data_util.mod_prefix .. "space-telescope-radio",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-thermodynamics-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/thermodynamics-laboratory.png",
    icon_size = 64,
    order = "z-a-".."space-thermodynamics-laboratory",
    stack_size = stack_size(7),
    subgroup = "smelting-machine",
    place_result = data_util.mod_prefix .. "space-thermodynamics-laboratory",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "supercharger",
    icon = "__space-exploration-graphics__/graphics/icons/supercharger.png",
    icon_size = 64,
    order = "z-z",
    stack_size = stack_size(4),
    subgroup = "logistic-network",
    place_result = data_util.mod_prefix .. "supercharger",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "compact-beacon",
    icon = "__space-exploration-graphics__/graphics/icons/compact-beacon.png",
    icon_size = 64,
    order = "z-a[beacon]-b",
    stack_size = stack_size(4),
    subgroup = "module",
    place_result = data_util.mod_prefix .. "compact-beacon",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "compact-beacon-2",
    icon = "__space-exploration-graphics__/graphics/icons/compact-beacon-2.png",
    icon_size = 64,
    order = "z-a[beacon]-b",
    stack_size = stack_size(4),
    subgroup = "module",
    place_result = data_util.mod_prefix .. "compact-beacon-2",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "wide-beacon",
    icon = "__space-exploration-graphics__/graphics/icons/wide-beacon.png",
    icon_size = 64,
    order = "z-a[beacon]-c",
    stack_size = stack_size(4),
    subgroup = "module",
    place_result = data_util.mod_prefix .. "wide-beacon",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "wide-beacon-2",
    icon = "__space-exploration-graphics__/graphics/icons/wide-beacon-2.png",
    icon_size = 64,
    order = "z-a[beacon]-d",
    stack_size = stack_size(4),
    subgroup = "module",
    place_result = data_util.mod_prefix .. "wide-beacon-2",
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "space-science-lab",
    icon = "__space-exploration-graphics__/graphics/icons/space-science-lab.png",
    icon_size = 64,
    order = "z-space-science-lab",
    stack_size = 1,
    subgroup = "lab",
    place_result = data_util.mod_prefix .. "space-science-lab"
  },
})
