-- Note: Default entity force will be 'capture', if a player character get near and there are no enemies the player will capture the entity.
local asteroid_belt_ship = {
  center = {x = 0, y = 0},
  landing_offset = {-21,-8}, -- only used in the satelliet blueprint, not normal ruins
  force_name = "capture",
  clear_entity_areas = {
    {{-32,-32},{32,32}},
  },
  prebuild = function(surface, ruin_position, ruin) -- surface, position, self (DO NOT MODFY SELF)
    -- function that runs before tiles and entities are added
  end,
  postbuild = function(surface, ruin_position, ruin)

    local container_items = {
      {
        {name = "se-space-manufactory", count =  1},
        {name = "iron-plate", count =  500},
        {name = "copper-plate", count =  500},
        {name = mod_prefix.."beryllium-plate", count = 500},
        {name = "sulfur", count =  500},
        {name = "stone", count =  500},
      },
      {
        {name = "beacon", count = 1},
        {name = "se-fuel-refinery", count = 1},
        {name = mod_prefix.."vulcanite-block", count = 100},
        {name = "coal", count =  500},
        {name = "heavy-oil-barrel", count = 100},
      },
      {
        {name = mod_prefix.."space-rail", count = 100},
        {name = mod_prefix.."space-solar-panel-2", count = 2},
        {name = mod_prefix.."space-accumulator", count = 4},
        {name = mod_prefix.."pylon", count = 10},
        {name = mod_prefix.."pylon-substation", count = 1},
        {name = "logistic-chest-storage", count = 10},
      },
      {
        {name = mod_prefix.."rocket-landing-pad", count = 1},
        {name = mod_prefix.."delivery-cannon-chest", count = 1},
        {name = mod_prefix.."space-pipe", count = 400},
        {name = mod_prefix.."deep-space-transport-belt-cyan", count = 200},
        {name = mod_prefix.."deep-space-splitter-cyan", count = 10},
        {name = mod_prefix.."deep-space-underground-belt-cyan", count = 20},
      },
      {
        {name = "se-lifesupport-facility", count = 1},
        {name = "se-lifesupport-canister", count = 50},
        {name = "se-space-decontamination-facility", count = 1},
        {name = "se-space-biochemical-laboratory", count = 1},
        {name = "se-recycling-facility", count = 1},
        {name = "water-barrel", count = 200},
      },
      {
        {name = mod_prefix.."tesla-gun", count=1},
        {name = mod_prefix.."tesla-ammo", count=200},
        {name = "laser-turret", count=10},
      },
      {
        {name = mod_prefix.."spaceship-ion-engine", count = 1},
        {name = mod_prefix.."spaceship-gate", count = 10},
        {name = mod_prefix.."spaceship-wall", count = 50},
        {name = mod_prefix.."spaceship-floor", count = 100},
        {name = mod_prefix.."spaceship-clamp", count = 4},
      },
    }

    if script.active_mods["Krastorio2"] then
      table.insert(container_items, {
        {name = "biusart-lab", count = 1},
        {name = "automation-science-pack", count = 200},
        {name = "logistic-science-pack", count = 200},
        {name = "chemical-science-pack", count = 200},
        {name = mod_prefix.."rocket-science-pack", count = 200},
        {name = "space-science-pack", count = 600},
      })
    else
      table.insert(container_items, {
        {name = "se-space-science-lab", count = 1},
        {name = "automation-science-pack", count = 200},
        {name = "logistic-science-pack", count = 200},
        {name = "chemical-science-pack", count = 200},
        {name = mod_prefix.."rocket-science-pack", count = 200},
        {name = "space-science-pack", count = 600},
      })
    end

    local containers = surface.find_entities_filtered{
      type = {"container", "logistic-container"},
      area = util.position_to_area(ruin_position, 32)}

    util.shuffle(containers)
    for i = 1, math.min(#containers, #container_items) do
      local container = containers[i]
      local insert_items = container_items[i]
      for _, item in pairs(insert_items) do
        container.insert({name = item.name, count = item.count or 1})
      end
    end

    local ion_boosters = surface.find_entities_filtered{
      name = mod_prefix.."spaceship-ion-booster-tank",
      area = util.position_to_area(ruin_position, 32)}
    for _, ion_booster in pairs(ion_boosters) do
       ion_booster.fluidbox[1] = {name = mod_prefix.."ion-stream", amount = 10000}
    end

    local remnants = surface.find_entities_filtered{
      type = "simple-entity-with-force",
      area = util.position_to_area(ruin_position, 32)
    }
    for _, remnant in pairs(remnants) do
      remnant.force = "neutral"
    end

    local ship_name = "Canary prospector"

    local roboports = surface.find_entities_filtered{
      name = "roboport",
      area = util.position_to_area(ruin_position, 32)
    }
    for _, roboport in pairs(roboports) do
      roboport.backer_name = ship_name
      roboport.insert({name="repair-pack", count=50})
      roboport.insert({name="logistic-robot", count=50})
      roboport.insert({name="construction-robot", count=50})
    end

    local consoles = surface.find_entities_filtered{
      name = "se-spaceship-console",
      area = util.position_to_area(ruin_position, 32)
    }
    if consoles[1] then
      local spaceship = Spaceship.from_entity(consoles[1])
      if spaceship then
        spaceship.name = ship_name
      end
    end

  end,
  tiles = {
    ["se-space"] = {{-60,-15}, {-60,-14}, {-60,-13}, {-60,14}, {-59,-15}, {-59,-14}, {-59,-13}, {-59,-12}, {-59,-11}, {-59,-10}, {-59,-9}, {-59,-8}, {-59,-7}, {-59,-6}, {-59,12}, {-59,13}, {-59,14}, {-59,15}, {-59,16}, {-59,17}, {-59,18}, {-59,19}, {-58,-16}, {-58,-15}, {-58,-14}, {-58,-13}, {-58,-12}, {-58,-11}, {-58,-10}, {-58,-9}, {-58,-8}, {-58,-7}, {-58,-6}, {-58,-5}, {-58,-4}, {-58,-3}, {-58,-2}, {-58,-1}, {-58,0}, {-58,1}, {-58,2}, {-58,3}, {-58,4}, {-58,5}, {-58,6}, {-58,7}, {-58,8}, {-58,9}, {-58,10}, {-58,11}, {-58,12}, {-58,13}, {-58,14}, {-58,15}, {-58,16}, {-58,17}, {-58,18}, {-58,19}, {-58,20}, {-57,-16}, {-57,-15}, {-57,-14}, {-57,-13}, {-57,-12}, {-57,-11}, {-57,-10}, {-57,-9}, {-57,-8}, {-57,-7}, {-57,-6}, {-57,-5}, {-57,-4}, {-57,-3}, {-57,-2}, {-57,-1}, {-57,0}, {-57,1}, {-57,2}, {-57,3}, {-57,4}, {-57,5}, {-57,6}, {-57,7}, {-57,8}, {-57,9}, {-57,10}, {-57,11}, {-57,12}, {-57,13}, {-57,14}, {-57,15}, {-57,16}, {-57,17}, {-57,18}, {-57,19}, {-57,20}, {-57,21}, {-56,-16}, {-56,-15}, {-56,-14}, {-56,-13}, {-56,-12}, {-56,-11}, {-56,-10}, {-56,-9}, {-56,-8}, {-56,-7}, {-56,-6}, {-56,-5}, {-56,-4}, {-56,-3}, {-56,-2}, {-56,-1}, {-56,0}, {-56,1}, {-56,2}, {-56,3}, {-56,4}, {-56,5}, {-56,6}, {-56,7}, {-56,8}, {-56,9}, {-56,10}, {-56,11}, {-56,12}, {-56,13}, {-56,14}, {-56,15}, {-56,16}, {-56,17}, {-56,18}, {-56,19}, {-56,20}, {-56,21}, {-56,22}, {-55,-17}, {-55,-16}, {-55,-15}, {-55,-14}, {-55,-13}, {-55,-12}, {-55,-11}, {-55,-10}, {-55,-9}, {-55,-8}, {-55,-7}, {-55,-6}, {-55,-5}, {-55,-4}, {-55,-3}, {-55,-2}, {-55,-1}, {-55,0}, {-55,1}, {-55,2}, {-55,3}, {-55,4}, {-55,5}, {-55,6}, {-55,7}, {-55,8}, {-55,9}, {-55,10}, {-55,11}, {-55,12}, {-55,13}, {-55,14}, {-55,15}, {-55,16}, {-55,17}, {-55,18}, {-55,19}, {-55,20}, {-55,21}, {-55,22}, {-55,23}, {-54,-17}, {-54,-16}, {-54,-15}, {-54,-14}, {-54,-13}, {-54,-12}, {-54,-11}, {-54,-10}, {-54,-9}, {-54,-8}, {-54,-7}, {-54,-6}, {-54,-5}, {-54,-4}, {-54,-3}, {-54,-2}, {-54,-1}, {-54,0}, {-54,1}, {-54,2}, {-54,3}, {-54,4}, {-54,5}, {-54,6}, {-54,7}, {-54,8}, {-54,9}, {-54,10}, {-54,11}, {-54,12}, {-54,13}, {-54,14}, {-54,15}, {-54,16}, {-54,17}, {-54,18}, {-54,19}, {-54,20}, {-54,21}, {-54,22}, {-54,23}, {-54,24}, {-53,-17}, {-53,-16}, {-53,-15}, {-53,-14}, {-53,-13}, {-53,-12}, {-53,-11}, {-53,-10}, {-53,-9}, {-53,-8}, {-53,-7}, {-53,-6}, {-53,-5}, {-53,-4}, {-53,-3}, {-53,-2}, {-53,-1}, {-53,0}, {-53,1}, {-53,2}, {-53,3}, {-53,4}, {-53,5}, {-53,6}, {-53,7}, {-53,8}, {-53,9}, {-53,10}, {-53,11}, {-53,12}, {-53,13}, {-53,14}, {-53,15}, {-53,16}, {-53,17}, {-53,18}, {-53,19}, {-53,20}, {-53,21}, {-53,22}, {-53,23}, {-53,24}, {-53,25}, {-53,26}, {-52,-18}, {-52,-17}, {-52,-16}, {-52,-15}, {-52,-14}, {-52,-13}, {-52,-12}, {-52,-11}, {-52,-10}, {-52,-9}, {-52,-8}, {-52,-7}, {-52,-6}, {-52,-5}, {-52,-4}, {-52,-3}, {-52,-2}, {-52,-1}, {-52,0}, {-52,1}, {-52,2}, {-52,3}, {-52,4}, {-52,5}, {-52,6}, {-52,7}, {-52,8}, {-52,9}, {-52,10}, {-52,11}, {-52,12}, {-52,13}, {-52,14}, {-52,15}, {-52,16}, {-52,17}, {-52,18}, {-52,19}, {-52,20}, {-52,21}, {-52,22}, {-52,23}, {-52,24}, {-52,25}, {-52,26}, {-52,27}, {-51,-18}, {-51,-17}, {-51,-16}, {-51,-15}, {-51,-14}, {-51,-13}, {-51,-12}, {-51,-11}, {-51,-10}, {-51,-9}, {-51,-8}, {-51,-7}, {-51,-6}, {-51,-5}, {-51,-4}, {-51,-3}, {-51,-2}, {-51,-1}, {-51,0}, {-51,1}, {-51,2}, {-51,3}, {-51,4}, {-51,5}, {-51,6}, {-51,7}, {-51,8}, {-51,9}, {-51,10}, {-51,11}, {-51,12}, {-51,13}, {-51,14}, {-51,15}, {-51,16}, {-51,17}, {-51,18}, {-51,19}, {-51,20}, {-51,21}, {-51,22}, {-51,23}, {-51,24}, {-51,25}, {-51,26}, {-51,27}, {-51,28}, {-51,29}, {-50,-18}, {-50,-17}, {-50,-16}, {-50,-15}, {-50,-14}, {-50,-13}, {-50,-12}, {-50,-11}, {-50,-10}, {-50,-9}, {-50,-8}, {-50,-7}, {-50,-6}, {-50,-5}, {-50,-4}, {-50,-3}, {-50,-2}, {-50,-1}, {-50,0}, {-50,1}, {-50,2}, {-50,3}, {-50,4}, {-50,5}, {-50,6}, {-50,7}, {-50,8}, {-50,9}, {-50,10}, {-50,11}, {-50,12}, {-50,13}, {-50,14}, {-50,15}, {-50,16}, {-50,17}, {-50,18}, {-50,19}, {-50,20}, {-50,21}, {-50,22}, {-50,23}, {-50,24}, {-50,25}, {-50,26}, {-50,27}, {-50,28}, {-50,29}, {-50,30}, {-49,-19}, {-49,-18}, {-49,-17}, {-49,-16}, {-49,-15}, {-49,-14}, {-49,-13}, {-49,-12}, {-49,-11}, {-49,-10}, {-49,-9}, {-49,-8}, {-49,-7}, {-49,-6}, {-49,-5}, {-49,-4}, {-49,-3}, {-49,-2}, {-49,-1}, {-49,0}, {-49,1}, {-49,2}, {-49,3}, {-49,4}, {-49,5}, {-49,6}, {-49,7}, {-49,8}, {-49,9}, {-49,10}, {-49,11}, {-49,12}, {-49,13}, {-49,14}, {-49,15}, {-49,16}, {-49,17}, {-49,18}, {-49,19}, {-49,20}, {-49,21}, {-49,22}, {-49,23}, {-49,24}, {-49,25}, {-49,26}, {-49,27}, {-49,28}, {-49,29}, {-49,30}, {-49,31}, {-48,-19}, {-48,-18}, {-48,-17}, {-48,-16}, {-48,-15}, {-48,-14}, {-48,-13}, {-48,-12}, {-48,-11}, {-48,-10}, {-48,-9}, {-48,-8}, {-48,-7}, {-48,-6}, {-48,-5}, {-48,-4}, {-48,-3}, {-48,-2}, {-48,-1}, {-48,0}, {-48,1}, {-48,2}, {-48,3}, {-48,4}, {-48,5}, {-48,6}, {-48,7}, {-48,8}, {-48,9}, {-48,10}, {-48,11}, {-48,12}, {-48,13}, {-48,14}, {-48,15}, {-48,16}, {-48,17}, {-48,18}, {-48,19}, {-48,20}, {-48,21}, {-48,22}, {-48,23}, {-48,24}, {-48,25}, {-48,26}, {-48,27}, {-48,28}, {-48,29}, {-48,30}, {-48,31}, {-47,-20}, {-47,-19}, {-47,-18}, {-47,-17}, {-47,-16}, {-47,-15}, {-47,-14}, {-47,-13}, {-47,-12}, {-47,-11}, {-47,-10}, {-47,-9}, {-47,-8}, {-47,-7}, {-47,-6}, {-47,-5}, {-47,-4}, {-47,-3}, {-47,-2}, {-47,-1}, {-47,0}, {-47,1}, {-47,2}, {-47,3}, {-47,4}, {-47,5}, {-47,6}, {-47,7}, {-47,8}, {-47,9}, {-47,10}, {-47,11}, {-47,12}, {-47,13}, {-47,14}, {-47,15}, {-47,16}, {-47,17}, {-47,18}, {-47,19}, {-47,20}, {-47,21}, {-47,22}, {-47,23}, {-47,24}, {-47,25}, {-47,26}, {-47,27}, {-47,28}, {-47,29}, {-47,30}, {-47,31}, {-47,32}, {-46,-22}, {-46,-21}, {-46,-20}, {-46,-19}, {-46,-18}, {-46,-17}, {-46,-16}, {-46,-15}, {-46,-14}, {-46,-13}, {-46,-12}, {-46,-11}, {-46,-10}, {-46,-9}, {-46,-8}, {-46,-7}, {-46,-6}, {-46,-5}, {-46,-4}, {-46,-3}, {-46,-2}, {-46,-1}, {-46,0}, {-46,1}, {-46,2}, {-46,3}, {-46,4}, {-46,5}, {-46,6}, {-46,7}, {-46,8}, {-46,9}, {-46,10}, {-46,11}, {-46,12}, {-46,13}, {-46,14}, {-46,15}, {-46,16}, {-46,17}, {-46,18}, {-46,19}, {-46,20}, {-46,21}, {-46,22}, {-46,23}, {-46,24}, {-46,25}, {-46,26}, {-46,27}, {-46,28}, {-46,29}, {-46,30}, {-46,31}, {-46,32}, {-45,-24}, {-45,-23}, {-45,-22}, {-45,-21}, {-45,-20}, {-45,-19}, {-45,-18}, {-45,-17}, {-45,-16}, {-45,-15}, {-45,-14}, {-45,-13}, {-45,-12}, {-45,-11}, {-45,-10}, {-45,-9}, {-45,-8}, {-45,-7}, {-45,-6}, {-45,-5}, {-45,-4}, {-45,-3}, {-45,-2}, {-45,-1}, {-45,0}, {-45,1}, {-45,2}, {-45,3}, {-45,4}, {-45,5}, {-45,6}, {-45,7}, {-45,8}, {-45,9}, {-45,10}, {-45,11}, {-45,12}, {-45,13}, {-45,14}, {-45,15}, {-45,16}, {-45,17}, {-45,18}, {-45,19}, {-45,20}, {-45,21}, {-45,22}, {-45,23}, {-45,24}, {-45,25}, {-45,26}, {-45,27}, {-45,28}, {-45,29}, {-45,30}, {-45,31}, {-45,32}, {-45,33}, {-44,-33}, {-44,-26}, {-44,-25}, {-44,-24}, {-44,-23}, {-44,-22}, {-44,-21}, {-44,-20}, {-44,-19}, {-44,-18}, {-44,-17}, {-44,-16}, {-44,-15}, {-44,-14}, {-44,-13}, {-44,-12}, {-44,-11}, {-44,-10}, {-44,-9}, {-44,-8}, {-44,-7}, {-44,-6}, {-44,-5}, {-44,-4}, {-44,-3}, {-44,-2}, {-44,-1}, {-44,0}, {-44,1}, {-44,2}, {-44,3}, {-44,4}, {-44,5}, {-44,6}, {-44,7}, {-44,8}, {-44,9}, {-44,10}, {-44,11}, {-44,12}, {-44,13}, {-44,14}, {-44,15}, {-44,16}, {-44,17}, {-44,18}, {-44,19}, {-44,20}, {-44,21}, {-44,22}, {-44,23}, {-44,24}, {-44,25}, {-44,26}, {-44,27}, {-44,28}, {-44,29}, {-44,30}, {-44,31}, {-44,32}, {-44,33}, {-43,-34}, {-43,-33}, {-43,-32}, {-43,-31}, {-43,-30}, {-43,-29}, {-43,-28}, {-43,-27}, {-43,-26}, {-43,-25}, {-43,-24}, {-43,-23}, {-43,-22}, {-43,-21}, {-43,-20}, {-43,-19}, {-43,-18}, {-43,-17}, {-43,-16}, {-43,-15}, {-43,-14}, {-43,-13}, {-43,-12}, {-43,-11}, {-43,-10}, {-43,-9}, {-43,-8}, {-43,-7}, {-43,-6}, {-43,-5}, {-43,-4}, {-43,-3}, {-43,-2}, {-43,-1}, {-43,0}, {-43,1}, {-43,2}, {-43,3}, {-43,4}, {-43,5}, {-43,6}, {-43,7}, {-43,8}, {-43,9}, {-43,10}, {-43,11}, {-43,12}, {-43,13}, {-43,14}, {-43,15}, {-43,16}, {-43,17}, {-43,18}, {-43,19}, {-43,20}, {-43,21}, {-43,22}, {-43,23}, {-43,24}, {-43,25}, {-43,26}, {-43,27}, {-43,28}, {-43,29}, {-43,30}, {-43,31}, {-43,32}, {-43,33}, {-42,-34}, {-42,-33}, {-42,-32}, {-42,-31}, {-42,-30}, {-42,-29}, {-42,-28}, {-42,-27}, {-42,-26}, {-42,-25}, {-42,-24}, {-42,-23}, {-42,-22}, {-42,-21}, {-42,-20}, {-42,-19}, {-42,-18}, {-42,-17}, {-42,-16}, {-42,-15}, {-42,-14}, {-42,-13}, {-42,-12}, {-42,-11}, {-42,-10}, {-42,-9}, {-42,-8}, {-42,-7}, {-42,-6}, {-42,-5}, {-42,-4}, {-42,-3}, {-42,-2}, {-42,-1}, {-42,0}, {-42,1}, {-42,2}, {-42,3}, {-42,4}, {-42,5}, {-42,6}, {-42,7}, {-42,8}, {-42,9}, {-42,10}, {-42,11}, {-42,12}, {-42,13}, {-42,14}, {-42,15}, {-42,16}, {-42,17}, {-42,18}, {-42,19}, {-42,20}, {-42,21}, {-42,22}, {-42,23}, {-42,24}, {-42,25}, {-42,26}, {-42,27}, {-42,28}, {-42,29}, {-42,30}, {-42,31}, {-42,32}, {-42,33}, {-41,-35}, {-41,-34}, {-41,-33}, {-41,-32}, {-41,-31}, {-41,-30}, {-41,-29}, {-41,-28}, {-41,-27}, {-41,-26}, {-41,-25}, {-41,-24}, {-41,-23}, {-41,-22}, {-41,-21}, {-41,-20}, {-41,-19}, {-41,-18}, {-41,-17}, {-41,-16}, {-41,-15}, {-41,-14}, {-41,-13}, {-41,-12}, {-41,-11}, {-41,-10}, {-41,-9}, {-41,-8}, {-41,-7}, {-41,-6}, {-41,-5}, {-41,-4}, {-41,-3}, {-41,-2}, {-41,-1}, {-41,0}, {-41,1}, {-41,2}, {-41,3}, {-41,4}, {-41,5}, {-41,6}, {-41,7}, {-41,8}, {-41,9}, {-41,10}, {-41,11}, {-41,12}, {-41,13}, {-41,14}, {-41,15}, {-41,16}, {-41,17}, {-41,18}, {-41,19}, {-41,20}, {-41,21}, {-41,22}, {-41,23}, {-41,24}, {-41,25}, {-41,26}, {-41,27}, {-41,28}, {-41,29}, {-41,30}, {-41,31}, {-41,32}, {-41,33}, {-41,34}, {-40,-35}, {-40,-34}, {-40,-33}, {-40,-32}, {-40,-31}, {-40,-30}, {-40,-29}, {-40,-28}, {-40,-27}, {-40,-26}, {-40,-25}, {-40,-24}, {-40,-23}, {-40,-22}, {-40,-21}, {-40,-20}, {-40,-19}, {-40,-18}, {-40,-17}, {-40,-16}, {-40,-15}, {-40,-14}, {-40,-13}, {-40,-12}, {-40,-11}, {-40,-10}, {-40,-9}, {-40,-8}, {-40,-7}, {-40,-6}, {-40,-5}, {-40,-4}, {-40,-3}, {-40,-2}, {-40,-1}, {-40,0}, {-40,1}, {-40,2}, {-40,3}, {-40,4}, {-40,5}, {-40,6}, {-40,7}, {-40,8}, {-40,9}, {-40,10}, {-40,11}, {-40,12}, {-40,13}, {-40,14}, {-40,15}, {-40,16}, {-40,17}, {-40,18}, {-40,19}, {-40,20}, {-40,21}, {-40,22}, {-40,23}, {-40,24}, {-40,25}, {-40,26}, {-40,27}, {-40,28}, {-40,29}, {-40,30}, {-40,31}, {-40,32}, {-40,33}, {-40,34}, {-39,-35}, {-39,-34}, {-39,-33}, {-39,-32}, {-39,-31}, {-39,-30}, {-39,-29}, {-39,-28}, {-39,-27}, {-39,-26}, {-39,-25}, {-39,-24}, {-39,-23}, {-39,-22}, {-39,-21}, {-39,-20}, {-39,-19}, {-39,-18}, {-39,-17}, {-39,-16}, {-39,-15}, {-39,-14}, {-39,-13}, {-39,-12}, {-39,-11}, {-39,-10}, {-39,-9}, {-39,-8}, {-39,-7}, {-39,-6}, {-39,-5}, {-39,-4}, {-39,-3}, {-39,-2}, {-39,-1}, {-39,0}, {-39,1}, {-39,2}, {-39,3}, {-39,4}, {-39,5}, {-39,6}, {-39,7}, {-39,8}, {-39,9}, {-39,10}, {-39,11}, {-39,12}, {-39,13}, {-39,14}, {-39,15}, {-39,16}, {-39,17}, {-39,18}, {-39,19}, {-39,20}, {-39,21}, {-39,22}, {-39,23}, {-39,24}, {-39,25}, {-39,26}, {-39,27}, {-39,28}, {-39,29}, {-39,30}, {-39,31}, {-39,32}, {-39,33}, {-39,34}, {-38,-35}, {-38,-34}, {-38,-33}, {-38,-32}, {-38,-31}, {-38,-30}, {-38,-29}, {-38,-28}, {-38,-27}, {-38,-26}, {-38,-25}, {-38,-24}, {-38,-23}, {-38,-22}, {-38,-21}, {-38,-20}, {-38,-19}, {-38,-18}, {-38,-17}, {-38,-16}, {-38,-15}, {-38,-14}, {-38,-13}, {-38,-12}, {-38,-11}, {-38,-10}, {-38,-9}, {-38,-8}, {-38,-7}, {-38,-6}, {-38,-5}, {-38,-4}, {-38,-3}, {-38,-2}, {-38,-1}, {-38,0}, {-38,1}, {-38,2}, {-38,3}, {-38,4}, {-38,5}, {-38,6}, {-38,7}, {-38,8}, {-38,9}, {-38,10}, {-38,11}, {-38,12}, {-38,13}, {-38,14}, {-38,15}, {-38,16}, {-38,17}, {-38,18}, {-38,19}, {-38,20}, {-38,21}, {-38,22}, {-38,23}, {-38,24}, {-38,25}, {-38,26}, {-38,27}, {-38,28}, {-38,29}, {-38,30}, {-38,31}, {-38,32}, {-38,33}, {-38,34}, {-38,35}, {-37,-36}, {-37,-35}, {-37,-34}, {-37,-33}, {-37,-32}, {-37,-31}, {-37,-30}, {-37,-29}, {-37,-28}, {-37,-27}, {-37,-26}, {-37,-25}, {-37,-24}, {-37,-23}, {-37,-22}, {-37,-21}, {-37,-20}, {-37,-19}, {-37,-18}, {-37,-17}, {-37,-16}, {-37,-15}, {-37,-14}, {-37,-13}, {-37,-12}, {-37,-11}, {-37,-10}, {-37,-9}, {-37,-8}, {-37,-7}, {-37,-6}, {-37,-5}, {-37,-4}, {-37,-3}, {-37,-2}, {-37,-1}, {-37,0}, {-37,1}, {-37,2}, {-37,3}, {-37,4}, {-37,5}, {-37,6}, {-37,7}, {-37,8}, {-37,9}, {-37,10}, {-37,11}, {-37,12}, {-37,13}, {-37,14}, {-37,15}, {-37,16}, {-37,17}, {-37,18}, {-37,19}, {-37,20}, {-37,21}, {-37,22}, {-37,23}, {-37,24}, {-37,25}, {-37,26}, {-37,27}, {-37,28}, {-37,29}, {-37,30}, {-37,31}, {-37,32}, {-37,33}, {-37,34}, {-37,35}, {-36,-36}, {-36,-35}, {-36,-34}, {-36,-33}, {-36,-32}, {-36,-31}, {-36,-30}, {-36,-29}, {-36,-28}, {-36,-27}, {-36,-26}, {-36,-25}, {-36,-24}, {-36,-23}, {-36,-22}, {-36,-21}, {-36,-20}, {-36,-19}, {-36,-18}, {-36,-17}, {-36,-16}, {-36,-15}, {-36,-14}, {-36,-13}, {-36,-12}, {-36,-11}, {-36,-10}, {-36,-9}, {-36,-8}, {-36,-7}, {-36,-6}, {-36,-5}, {-36,-4}, {-36,-3}, {-36,-2}, {-36,-1}, {-36,0}, {-36,1}, {-36,2}, {-36,3}, {-36,4}, {-36,5}, {-36,6}, {-36,7}, {-36,8}, {-36,9}, {-36,10}, {-36,11}, {-36,12}, {-36,13}, {-36,14}, {-36,15}, {-36,16}, {-36,17}, {-36,18}, {-36,19}, {-36,20}, {-36,21}, {-36,22}, {-36,23}, {-36,24}, {-36,25}, {-36,26}, {-36,27}, {-36,28}, {-36,29}, {-36,30}, {-36,31}, {-36,32}, {-36,33}, {-36,34}, {-36,35}, {-35,-37}, {-35,-36}, {-35,-35}, {-35,-34}, {-35,-33}, {-35,-32}, {-35,-31}, {-35,-30}, {-35,-29}, {-35,-28}, {-35,-27}, {-35,-26}, {-35,-25}, {-35,-24}, {-35,-23}, {-35,-22}, {-35,-21}, {-35,-20}, {-35,-19}, {-35,-18}, {-35,-17}, {-35,-16}, {-35,-15}, {-35,-14}, {-35,-13}, {-35,-12}, {-35,-11}, {-35,-10}, {-35,-9}, {-35,-8}, {-35,-7}, {-35,-6}, {-35,-5}, {-35,-4}, {-35,-3}, {-35,-2}, {-35,-1}, {-35,0}, {-35,1}, {-35,2}, {-35,3}, {-35,4}, {-35,5}, {-35,6}, {-35,7}, {-35,8}, {-35,9}, {-35,10}, {-35,11}, {-35,12}, {-35,13}, {-35,14}, {-35,15}, {-35,16}, {-35,17}, {-35,18}, {-35,19}, {-35,20}, {-35,21}, {-35,22}, {-35,23}, {-35,24}, {-35,25}, {-35,26}, {-35,27}, {-35,28}, {-35,29}, {-35,30}, {-35,31}, {-35,32}, {-35,33}, {-35,34}, {-35,35}, {-35,36}, {-34,-37}, {-34,-36}, {-34,-35}, {-34,-34}, {-34,-33}, {-34,-32}, {-34,-31}, {-34,-30}, {-34,-29}, {-34,-28}, {-34,-27}, {-34,-26}, {-34,-25}, {-34,-24}, {-34,-23}, {-34,-22}, {-34,-21}, {-34,-20}, {-34,-19}, {-34,-18}, {-34,-17}, {-34,-16}, {-34,-15}, {-34,-14}, {-34,-13}, {-34,-12}, {-34,-11}, {-34,-10}, {-34,-9}, {-34,-8}, {-34,-7}, {-34,-6}, {-34,-5}, {-34,-4}, {-34,-3}, {-34,-2}, {-34,-1}, {-34,0}, {-34,1}, {-34,2}, {-34,3}, {-34,4}, {-34,5}, {-34,6}, {-34,7}, {-34,8}, {-34,9}, {-34,10}, {-34,11}, {-34,12}, {-34,13}, {-34,14}, {-34,15}, {-34,16}, {-34,17}, {-34,18}, {-34,19}, {-34,20}, {-34,21}, {-34,22}, {-34,23}, {-34,24}, {-34,25}, {-34,26}, {-34,27}, {-34,28}, {-34,29}, {-34,30}, {-34,31}, {-34,32}, {-34,33}, {-34,34}, {-34,35}, {-34,36}, {-33,-37}, {-33,-36}, {-33,-35}, {-33,-34}, {-33,-33}, {-33,-32}, {-33,-31}, {-33,-30}, {-33,-29}, {-33,-28}, {-33,-27}, {-33,-26}, {-33,-25}, {-33,-20}, {-33,-19}, {-33,-18}, {-33,-17}, {-33,-16}, {-33,-15}, {-33,-14}, {-33,-13}, {-33,-12}, {-33,-11}, {-33,-10}, {-33,-9}, {-33,-8}, {-33,-7}, {-33,-6}, {-33,-5}, {-33,-4}, {-33,-3}, {-33,-2}, {-33,-1}, {-33,0}, {-33,1}, {-33,2}, {-33,3}, {-33,4}, {-33,5}, {-33,6}, {-33,7}, {-33,8}, {-33,9}, {-33,10}, {-33,11}, {-33,12}, {-33,13}, {-33,14}, {-33,15}, {-33,16}, {-33,17}, {-33,18}, {-33,19}, {-33,20}, {-33,21}, {-33,22}, {-33,23}, {-33,24}, {-33,25}, {-33,26}, {-33,27}, {-33,28}, {-33,29}, {-33,30}, {-33,31}, {-33,32}, {-33,33}, {-33,34}, {-33,35}, {-33,36}, {-33,37}, {-32,-37}, {-32,-36}, {-32,-35}, {-32,-34}, {-32,-33}, {-32,-32}, {-32,-31}, {-32,-30}, {-32,-29}, {-32,-28}, {-32,-27}, {-32,-20}, {-32,-19}, {-32,-18}, {-32,-17}, {-32,-16}, {-32,-15}, {-32,-14}, {-32,-13}, {-32,-12}, {-32,-11}, {-32,-10}, {-32,-9}, {-32,-8}, {-32,-7}, {-32,-6}, {-32,-5}, {-32,-4}, {-32,-3}, {-32,-2}, {-32,-1}, {-32,0}, {-32,1}, {-32,2}, {-32,3}, {-32,4}, {-32,5}, {-32,6}, {-32,7}, {-32,8}, {-32,9}, {-32,10}, {-32,11}, {-32,12}, {-32,13}, {-32,14}, {-32,15}, {-32,16}, {-32,17}, {-32,18}, {-32,19}, {-32,20}, {-32,21}, {-32,22}, {-32,23}, {-32,24}, {-32,25}, {-32,26}, {-32,27}, {-32,28}, {-32,29}, {-32,30}, {-32,31}, {-32,32}, {-32,33}, {-32,34}, {-32,35}, {-32,36}, {-32,37}, {-31,-38}, {-31,-37}, {-31,-36}, {-31,-35}, {-31,-34}, {-31,-33}, {-31,-32}, {-31,-31}, {-31,-30}, {-31,-29}, {-31,-28}, {-31,-27}, {-31,-20}, {-31,-19}, {-31,-18}, {-31,-17}, {-31,-16}, {-31,-15}, {-31,-14}, {-31,-13}, {-31,-12}, {-31,-11}, {-31,-10}, {-31,-9}, {-31,-8}, {-31,-7}, {-31,-6}, {-31,-5}, {-31,-4}, {-31,-3}, {-31,-2}, {-31,-1}, {-31,0}, {-31,1}, {-31,2}, {-31,3}, {-31,4}, {-31,5}, {-31,6}, {-31,7}, {-31,8}, {-31,9}, {-31,10}, {-31,11}, {-31,12}, {-31,13}, {-31,14}, {-31,15}, {-31,16}, {-31,17}, {-31,18}, {-31,19}, {-31,20}, {-31,21}, {-31,22}, {-31,23}, {-31,24}, {-31,25}, {-31,26}, {-31,27}, {-31,28}, {-31,29}, {-31,30}, {-31,31}, {-31,32}, {-31,33}, {-31,34}, {-31,35}, {-31,36}, {-31,37}, {-30,-38}, {-30,-37}, {-30,-36}, {-30,-35}, {-30,-34}, {-30,-33}, {-30,-32}, {-30,-31}, {-30,-30}, {-30,-29}, {-30,-28}, {-30,-20}, {-30,-19}, {-30,-18}, {-30,-17}, {-30,-16}, {-30,-15}, {-30,-14}, {-30,-13}, {-30,-12}, {-30,-11}, {-30,-10}, {-30,-9}, {-30,-8}, {-30,-7}, {-30,-6}, {-30,-5}, {-30,-4}, {-30,-3}, {-30,-2}, {-30,-1}, {-30,0}, {-30,1}, {-30,2}, {-30,3}, {-30,4}, {-30,5}, {-30,6}, {-30,7}, {-30,8}, {-30,9}, {-30,10}, {-30,11}, {-30,12}, {-30,13}, {-30,14}, {-30,15}, {-30,16}, {-30,17}, {-30,18}, {-30,19}, {-30,20}, {-30,21}, {-30,22}, {-30,23}, {-30,24}, {-30,25}, {-30,26}, {-30,27}, {-30,28}, {-30,29}, {-30,30}, {-30,31}, {-30,32}, {-30,33}, {-30,34}, {-30,35}, {-30,36}, {-30,37}, {-30,38}, {-29,-39}, {-29,-38}, {-29,-37}, {-29,-36}, {-29,-35}, {-29,-34}, {-29,-33}, {-29,-32}, {-29,-31}, {-29,-30}, {-29,-29}, {-29,-28}, {-29,-20}, {-29,-19}, {-29,-18}, {-29,-17}, {-29,-16}, {-29,-15}, {-29,-14}, {-29,-13}, {-29,-12}, {-29,-11}, {-29,-10}, {-29,-9}, {-29,-8}, {-29,-7}, {-29,-6}, {-29,-5}, {-29,-4}, {-29,-3}, {-29,-2}, {-29,-1}, {-29,0}, {-29,1}, {-29,2}, {-29,3}, {-29,4}, {-29,5}, {-29,6}, {-29,15}, {-29,16}, {-29,17}, {-29,18}, {-29,19}, {-29,20}, {-29,21}, {-29,22}, {-29,23}, {-29,24}, {-29,25}, {-29,26}, {-29,27}, {-29,28}, {-29,29}, {-29,30}, {-29,31}, {-29,32}, {-29,33}, {-29,34}, {-29,35}, {-29,36}, {-29,37}, {-29,38}, {-28,-45}, {-28,-41}, {-28,-40}, {-28,-39}, {-28,-38}, {-28,-37}, {-28,-36}, {-28,-35}, {-28,-34}, {-28,-33}, {-28,-32}, {-28,-31}, {-28,-30}, {-28,-29}, {-28,-20}, {-28,-19}, {-28,-18}, {-28,-17}, {-28,-16}, {-28,-15}, {-28,-14}, {-28,-13}, {-28,-12}, {-28,-11}, {-28,-10}, {-28,-9}, {-28,-8}, {-28,-7}, {-28,-6}, {-28,-5}, {-28,-4}, {-28,-3}, {-28,-2}, {-28,-1}, {-28,0}, {-28,1}, {-28,2}, {-28,3}, {-28,4}, {-28,5}, {-28,15}, {-28,16}, {-28,17}, {-28,18}, {-28,19}, {-28,20}, {-28,21}, {-28,22}, {-28,23}, {-28,24}, {-28,25}, {-28,26}, {-28,27}, {-28,28}, {-28,29}, {-28,30}, {-28,31}, {-28,32}, {-28,33}, {-28,34}, {-28,35}, {-28,36}, {-28,37}, {-27,-45}, {-27,-44}, {-27,-43}, {-27,-42}, {-27,-41}, {-27,-40}, {-27,-39}, {-27,-38}, {-27,-37}, {-27,-36}, {-27,-35}, {-27,-34}, {-27,-33}, {-27,-32}, {-27,-31}, {-27,-30}, {-27,-29}, {-27,-19}, {-27,-18}, {-27,-17}, {-27,-16}, {-27,-15}, {-27,-14}, {-27,-13}, {-27,-12}, {-27,-11}, {-27,-10}, {-27,-9}, {-27,-8}, {-27,-7}, {-27,-6}, {-27,-5}, {-27,-4}, {-27,-3}, {-27,-2}, {-27,-1}, {-27,0}, {-27,1}, {-27,2}, {-27,3}, {-27,4}, {-27,5}, {-27,15}, {-27,16}, {-27,17}, {-27,18}, {-27,19}, {-27,20}, {-27,21}, {-27,22}, {-27,23}, {-27,24}, {-27,25}, {-27,26}, {-27,27}, {-27,28}, {-27,29}, {-27,30}, {-27,31}, {-27,32}, {-27,33}, {-27,34}, {-27,35}, {-27,36}, {-27,37}, {-26,-45}, {-26,-44}, {-26,-43}, {-26,-42}, {-26,-41}, {-26,-40}, {-26,-39}, {-26,-38}, {-26,-37}, {-26,-36}, {-26,-35}, {-26,-34}, {-26,-33}, {-26,-32}, {-26,-31}, {-26,-30}, {-26,-29}, {-26,-19}, {-26,-18}, {-26,-17}, {-26,-16}, {-26,-15}, {-26,-14}, {-26,-13}, {-26,-12}, {-26,-11}, {-26,-10}, {-26,-9}, {-26,-8}, {-26,-7}, {-26,-6}, {-26,-5}, {-26,-4}, {-26,-3}, {-26,-2}, {-26,-1}, {-26,0}, {-26,15}, {-26,16}, {-26,17}, {-26,18}, {-26,19}, {-26,20}, {-26,21}, {-26,22}, {-26,23}, {-26,24}, {-26,25}, {-26,26}, {-26,27}, {-26,28}, {-26,29}, {-26,30}, {-26,31}, {-26,32}, {-26,33}, {-26,34}, {-26,35}, {-26,36}, {-26,37}, {-25,-44}, {-25,-43}, {-25,-42}, {-25,-41}, {-25,-40}, {-25,-39}, {-25,-38}, {-25,-37}, {-25,-36}, {-25,-35}, {-25,-34}, {-25,-33}, {-25,-32}, {-25,-31}, {-25,-30}, {-25,-29}, {-25,-18}, {-25,-17}, {-25,-16}, {-25,-15}, {-25,-14}, {-25,-13}, {-25,-12}, {-25,-11}, {-25,-10}, {-25,-9}, {-25,-8}, {-25,-7}, {-25,-6}, {-25,-5}, {-25,-4}, {-25,-3}, {-25,-2}, {-25,-1}, {-25,12}, {-25,13}, {-25,14}, {-25,15}, {-25,16}, {-25,17}, {-25,18}, {-25,19}, {-25,20}, {-25,21}, {-25,22}, {-25,23}, {-25,24}, {-25,25}, {-25,26}, {-25,27}, {-25,28}, {-25,29}, {-25,30}, {-25,31}, {-25,32}, {-25,33}, {-25,34}, {-25,35}, {-25,36}, {-25,37}, {-24,-44}, {-24,-43}, {-24,-42}, {-24,-41}, {-24,-40}, {-24,-39}, {-24,-38}, {-24,-37}, {-24,-36}, {-24,-35}, {-24,-34}, {-24,-33}, {-24,-32}, {-24,-31}, {-24,-30}, {-24,-29}, {-24,-28}, {-24,-17}, {-24,-16}, {-24,-15}, {-24,-14}, {-24,-13}, {-24,-12}, {-24,-11}, {-24,-10}, {-24,-9}, {-24,-8}, {-24,-7}, {-24,-6}, {-24,-5}, {-24,-4}, {-24,17}, {-24,18}, {-24,19}, {-24,20}, {-24,21}, {-24,22}, {-24,23}, {-24,24}, {-24,25}, {-24,26}, {-24,27}, {-24,28}, {-24,29}, {-24,30}, {-24,31}, {-24,32}, {-24,33}, {-24,34}, {-24,35}, {-24,36}, {-24,37}, {-23,-43}, {-23,-42}, {-23,-41}, {-23,-40}, {-23,-39}, {-23,-38}, {-23,-37}, {-23,-36}, {-23,-35}, {-23,-34}, {-23,-33}, {-23,-32}, {-23,-31}, {-23,-30}, {-23,-29}, {-23,-28}, {-23,-27}, {-23,-26}, {-23,-25}, {-23,-24}, {-23,-17}, {-23,-16}, {-23,-15}, {-23,-14}, {-23,-13}, {-23,-12}, {-23,-11}, {-23,-10}, {-23,-9}, {-23,-8}, {-23,-7}, {-23,-6}, {-23,-5}, {-23,18}, {-23,19}, {-23,20}, {-23,21}, {-23,22}, {-23,23}, {-23,24}, {-23,25}, {-23,26}, {-23,27}, {-23,28}, {-23,29}, {-23,30}, {-23,31}, {-23,32}, {-23,33}, {-23,34}, {-23,35}, {-23,36}, {-23,37}, {-22,-43}, {-22,-42}, {-22,-41}, {-22,-40}, {-22,-39}, {-22,-38}, {-22,-37}, {-22,-36}, {-22,-35}, {-22,-34}, {-22,-33}, {-22,-32}, {-22,-31}, {-22,-30}, {-22,-29}, {-22,-28}, {-22,-27}, {-22,-26}, {-22,-25}, {-22,-24}, {-22,-23}, {-22,-22}, {-22,-18}, {-22,-17}, {-22,-16}, {-22,-15}, {-22,-14}, {-22,-13}, {-22,-12}, {-22,-11}, {-22,-10}, {-22,-9}, {-22,-8}, {-22,19}, {-22,20}, {-22,21}, {-22,22}, {-22,23}, {-22,24}, {-22,25}, {-22,26}, {-22,27}, {-22,28}, {-22,29}, {-22,30}, {-22,31}, {-22,32}, {-22,33}, {-22,34}, {-22,35}, {-22,36}, {-22,37}, {-21,-43}, {-21,-42}, {-21,-41}, {-21,-40}, {-21,-39}, {-21,-38}, {-21,-37}, {-21,-36}, {-21,-35}, {-21,-34}, {-21,-33}, {-21,-32}, {-21,-31}, {-21,-30}, {-21,-29}, {-21,-28}, {-21,-27}, {-21,-26}, {-21,-25}, {-21,-24}, {-21,-23}, {-21,-22}, {-21,-20}, {-21,-19}, {-21,-18}, {-21,-17}, {-21,-16}, {-21,-15}, {-21,-14}, {-21,-13}, {-21,19}, {-21,20}, {-21,21}, {-21,22}, {-21,23}, {-21,24}, {-21,25}, {-21,26}, {-21,27}, {-21,28}, {-21,29}, {-21,30}, {-21,31}, {-21,32}, {-21,33}, {-21,34}, {-21,35}, {-21,36}, {-21,37}, {-20,-43}, {-20,-42}, {-20,-41}, {-20,-40}, {-20,-39}, {-20,-38}, {-20,-37}, {-20,-36}, {-20,-35}, {-20,-34}, {-20,-33}, {-20,-32}, {-20,-31}, {-20,-30}, {-20,-29}, {-20,-28}, {-20,-27}, {-20,-26}, {-20,-25}, {-20,-24}, {-20,-23}, {-20,-22}, {-20,-21}, {-20,-20}, {-20,-19}, {-20,-18}, {-20,-17}, {-20,-16}, {-20,-15}, {-20,-14}, {-20,18}, {-20,19}, {-20,20}, {-20,21}, {-20,22}, {-20,23}, {-20,24}, {-20,25}, {-20,26}, {-20,27}, {-20,28}, {-20,29}, {-20,30}, {-20,31}, {-20,32}, {-20,33}, {-20,34}, {-20,35}, {-20,36}, {-20,37}, {-20,38}, {-19,-43}, {-19,-42}, {-19,-41}, {-19,-40}, {-19,-39}, {-19,-38}, {-19,-37}, {-19,-36}, {-19,-35}, {-19,-34}, {-19,-33}, {-19,-32}, {-19,-31}, {-19,-30}, {-19,-29}, {-19,-28}, {-19,-27}, {-19,-26}, {-19,-25}, {-19,-24}, {-19,-23}, {-19,-22}, {-19,-21}, {-19,-20}, {-19,-19}, {-19,-18}, {-19,-17}, {-19,-16}, {-19,-15}, {-19,18}, {-19,19}, {-19,20}, {-19,21}, {-19,22}, {-19,23}, {-19,24}, {-19,25}, {-19,26}, {-19,27}, {-19,28}, {-19,29}, {-19,30}, {-19,31}, {-19,32}, {-19,33}, {-19,34}, {-19,35}, {-19,36}, {-19,37}, {-19,38}, {-18,-43}, {-18,-42}, {-18,-41}, {-18,-40}, {-18,-39}, {-18,-38}, {-18,-37}, {-18,-36}, {-18,-35}, {-18,-34}, {-18,-33}, {-18,-32}, {-18,-31}, {-18,-30}, {-18,-29}, {-18,-28}, {-18,-27}, {-18,-26}, {-18,-25}, {-18,-24}, {-18,-23}, {-18,-22}, {-18,-21}, {-18,-20}, {-18,-19}, {-18,-18}, {-18,-17}, {-18,-16}, {-18,-15}, {-18,18}, {-18,19}, {-18,20}, {-18,21}, {-18,22}, {-18,23}, {-18,24}, {-18,25}, {-18,26}, {-18,27}, {-18,28}, {-18,29}, {-18,30}, {-18,31}, {-18,32}, {-18,33}, {-18,34}, {-18,35}, {-18,36}, {-18,37}, {-18,38}, {-17,-42}, {-17,-41}, {-17,-40}, {-17,-39}, {-17,-38}, {-17,-37}, {-17,-36}, {-17,-35}, {-17,-34}, {-17,-33}, {-17,-32}, {-17,-31}, {-17,-30}, {-17,-29}, {-17,-28}, {-17,-27}, {-17,-26}, {-17,-25}, {-17,-24}, {-17,-23}, {-17,-22}, {-17,-21}, {-17,-20}, {-17,-19}, {-17,-18}, {-17,-17}, {-17,-16}, {-17,-15}, {-17,-14}, {-17,18}, {-17,19}, {-17,20}, {-17,21}, {-17,22}, {-17,23}, {-17,24}, {-17,25}, {-17,26}, {-17,27}, {-17,28}, {-17,29}, {-17,30}, {-17,31}, {-17,32}, {-17,33}, {-17,34}, {-17,35}, {-17,36}, {-17,37}, {-17,38}, {-16,-42}, {-16,-41}, {-16,-40}, {-16,-39}, {-16,-38}, {-16,-37}, {-16,-36}, {-16,-35}, {-16,-34}, {-16,-33}, {-16,-32}, {-16,-31}, {-16,-30}, {-16,-29}, {-16,-28}, {-16,-27}, {-16,-26}, {-16,-25}, {-16,-24}, {-16,-23}, {-16,-22}, {-16,-21}, {-16,-20}, {-16,-19}, {-16,-18}, {-16,-17}, {-16,-16}, {-16,-15}, {-16,-14}, {-16,-13}, {-16,19}, {-16,20}, {-16,21}, {-16,22}, {-16,23}, {-16,24}, {-16,25}, {-16,26}, {-16,27}, {-16,28}, {-16,29}, {-16,30}, {-16,31}, {-16,32}, {-16,33}, {-16,34}, {-16,35}, {-16,36}, {-16,37}, {-16,38}, {-15,-42}, {-15,-41}, {-15,-40}, {-15,-39}, {-15,-38}, {-15,-37}, {-15,-36}, {-15,-35}, {-15,-34}, {-15,-33}, {-15,-32}, {-15,-31}, {-15,-30}, {-15,-29}, {-15,-28}, {-15,-27}, {-15,-26}, {-15,-25}, {-15,-24}, {-15,-23}, {-15,-22}, {-15,-21}, {-15,-20}, {-15,-19}, {-15,-18}, {-15,-17}, {-15,-16}, {-15,-15}, {-15,-14}, {-15,-13}, {-15,-12}, {-15,-11}, {-15,-10}, {-15,-9}, {-15,-8}, {-15,4}, {-15,19}, {-15,20}, {-15,21}, {-15,22}, {-15,23}, {-15,24}, {-15,25}, {-15,26}, {-15,27}, {-15,28}, {-15,29}, {-15,30}, {-15,31}, {-15,32}, {-15,33}, {-15,34}, {-15,35}, {-15,36}, {-15,37}, {-15,38}, {-14,-42}, {-14,-41}, {-14,-40}, {-14,-39}, {-14,-38}, {-14,-37}, {-14,-36}, {-14,-35}, {-14,-34}, {-14,-33}, {-14,-32}, {-14,-31}, {-14,-30}, {-14,-29}, {-14,-28}, {-14,-27}, {-14,-26}, {-14,-25}, {-14,-24}, {-14,-23}, {-14,-22}, {-14,-21}, {-14,-20}, {-14,-19}, {-14,-18}, {-14,-17}, {-14,-16}, {-14,-15}, {-14,-14}, {-14,-13}, {-14,-12}, {-14,-11}, {-14,-10}, {-14,-9}, {-14,-8}, {-14,-7}, {-14,-6}, {-14,-5}, {-14,2}, {-14,18}, {-14,19}, {-14,20}, {-14,21}, {-14,22}, {-14,23}, {-14,24}, {-14,25}, {-14,26}, {-14,27}, {-14,28}, {-14,29}, {-14,30}, {-14,31}, {-14,32}, {-14,33}, {-14,34}, {-14,35}, {-14,36}, {-14,37}, {-14,38}, {-14,39}, {-13,-42}, {-13,-41}, {-13,-40}, {-13,-39}, {-13,-38}, {-13,-37}, {-13,-36}, {-13,-35}, {-13,-34}, {-13,-33}, {-13,-32}, {-13,-31}, {-13,-30}, {-13,-29}, {-13,-28}, {-13,-27}, {-13,-26}, {-13,-25}, {-13,-24}, {-13,-23}, {-13,-22}, {-13,-21}, {-13,-20}, {-13,-19}, {-13,-18}, {-13,-17}, {-13,-16}, {-13,-15}, {-13,-14}, {-13,-13}, {-13,-12}, {-13,-11}, {-13,-10}, {-13,-9}, {-13,-8}, {-13,-7}, {-13,-6}, {-13,-5}, {-13,-4}, {-13,2}, {-13,17}, {-13,18}, {-13,19}, {-13,20}, {-13,21}, {-13,22}, {-13,23}, {-13,24}, {-13,25}, {-13,26}, {-13,27}, {-13,28}, {-13,29}, {-13,30}, {-13,31}, {-13,32}, {-13,33}, {-13,34}, {-13,35}, {-13,36}, {-13,37}, {-13,38}, {-13,39}, {-12,-42}, {-12,-41}, {-12,-40}, {-12,-39}, {-12,-38}, {-12,-37}, {-12,-36}, {-12,-35}, {-12,-34}, {-12,-33}, {-12,-32}, {-12,-31}, {-12,-30}, {-12,-28}, {-12,-27}, {-12,-26}, {-12,-25}, {-12,-24}, {-12,-23}, {-12,-22}, {-12,-21}, {-12,-20}, {-12,-19}, {-12,-18}, {-12,-17}, {-12,-16}, {-12,-15}, {-12,-14}, {-12,-13}, {-12,-12}, {-12,-9}, {-12,-8}, {-12,-7}, {-12,-6}, {-12,-5}, {-12,-4}, {-12,-3}, {-12,-2}, {-12,-1}, {-12,12}, {-12,13}, {-12,14}, {-12,15}, {-12,16}, {-12,17}, {-12,18}, {-12,19}, {-12,20}, {-12,21}, {-12,22}, {-12,23}, {-12,24}, {-12,25}, {-12,26}, {-12,27}, {-12,28}, {-12,29}, {-12,30}, {-12,31}, {-12,32}, {-12,33}, {-12,34}, {-12,35}, {-12,36}, {-12,37}, {-12,38}, {-12,39}, {-11,-43}, {-11,-42}, {-11,-41}, {-11,-40}, {-11,-39}, {-11,-38}, {-11,-37}, {-11,-36}, {-11,-35}, {-11,-34}, {-11,-33}, {-11,-32}, {-11,-26}, {-11,-25}, {-11,-24}, {-11,-23}, {-11,-22}, {-11,-21}, {-11,-20}, {-11,-19}, {-11,-18}, {-11,-17}, {-11,-16}, {-11,-15}, {-11,-7}, {-11,-6}, {-11,-5}, {-11,-2}, {-11,-1}, {-11,0}, {-11,14}, {-11,15}, {-11,16}, {-11,17}, {-11,18}, {-11,19}, {-11,20}, {-11,21}, {-11,22}, {-11,23}, {-11,24}, {-11,25}, {-11,26}, {-11,27}, {-11,28}, {-11,29}, {-11,30}, {-11,31}, {-11,32}, {-11,33}, {-11,34}, {-11,35}, {-11,36}, {-11,37}, {-11,38}, {-11,39}, {-10,-43}, {-10,-42}, {-10,-41}, {-10,-40}, {-10,-39}, {-10,-38}, {-10,-37}, {-10,-36}, {-10,-35}, {-10,-34}, {-10,-33}, {-10,-32}, {-10,-27}, {-10,-26}, {-10,-25}, {-10,-24}, {-10,-23}, {-10,-22}, {-10,-21}, {-10,-20}, {-10,-19}, {-10,-18}, {-10,-17}, {-10,-16}, {-10,-6}, {-10,-5}, {-10,-4}, {-10,-3}, {-10,-2}, {-10,-1}, {-10,0}, {-10,1}, {-10,2}, {-10,3}, {-10,4}, {-10,5}, {-10,15}, {-10,16}, {-10,17}, {-10,18}, {-10,19}, {-10,20}, {-10,21}, {-10,22}, {-10,23}, {-10,24}, {-10,25}, {-10,26}, {-10,27}, {-10,28}, {-10,29}, {-10,30}, {-10,31}, {-10,32}, {-10,33}, {-10,34}, {-10,35}, {-10,36}, {-10,37}, {-10,38}, {-10,39}, {-10,40}, {-9,-43}, {-9,-42}, {-9,-41}, {-9,-40}, {-9,-39}, {-9,-38}, {-9,-37}, {-9,-36}, {-9,-35}, {-9,-34}, {-9,-33}, {-9,-27}, {-9,-26}, {-9,-25}, {-9,-24}, {-9,-23}, {-9,-22}, {-9,-21}, {-9,-20}, {-9,-19}, {-9,-18}, {-9,-17}, {-9,-5}, {-9,-4}, {-9,-2}, {-9,-1}, {-9,0}, {-9,1}, {-9,5}, {-9,12}, {-9,13}, {-9,14}, {-9,15}, {-9,16}, {-9,17}, {-9,18}, {-9,19}, {-9,20}, {-9,21}, {-9,22}, {-9,23}, {-9,24}, {-9,25}, {-9,26}, {-9,27}, {-9,28}, {-9,29}, {-9,30}, {-9,31}, {-9,32}, {-9,33}, {-9,34}, {-9,35}, {-9,36}, {-9,37}, {-9,38}, {-9,39}, {-9,40}, {-8,-44}, {-8,-43}, {-8,-42}, {-8,-41}, {-8,-40}, {-8,-39}, {-8,-38}, {-8,-37}, {-8,-36}, {-8,-35}, {-8,-34}, {-8,-33}, {-8,-32}, {-8,-27}, {-8,-26}, {-8,-25}, {-8,-24}, {-8,-23}, {-8,-22}, {-8,-21}, {-8,-20}, {-8,-19}, {-8,-18}, {-8,-17}, {-8,-4}, {-8,-3}, {-8,-2}, {-8,-1}, {-8,0}, {-8,1}, {-8,5}, {-8,6}, {-8,14}, {-8,15}, {-8,16}, {-8,17}, {-8,18}, {-8,19}, {-8,20}, {-8,21}, {-8,22}, {-8,23}, {-8,24}, {-8,25}, {-8,26}, {-8,27}, {-8,28}, {-8,29}, {-8,30}, {-8,31}, {-8,32}, {-8,33}, {-8,34}, {-8,35}, {-8,36}, {-8,37}, {-8,38}, {-8,39}, {-8,40}, {-7,-44}, {-7,-43}, {-7,-42}, {-7,-41}, {-7,-40}, {-7,-39}, {-7,-38}, {-7,-37}, {-7,-36}, {-7,-35}, {-7,-34}, {-7,-33}, {-7,-32}, {-7,-28}, {-7,-27}, {-7,-26}, {-7,-25}, {-7,-24}, {-7,-23}, {-7,-22}, {-7,-21}, {-7,-20}, {-7,-19}, {-7,-18}, {-7,-17}, {-7,-1}, {-7,0}, {-7,1}, {-7,4}, {-7,5}, {-7,6}, {-7,7}, {-7,8}, {-7,13}, {-7,14}, {-7,15}, {-7,16}, {-7,17}, {-7,18}, {-7,19}, {-7,20}, {-7,21}, {-7,22}, {-7,23}, {-7,24}, {-7,25}, {-7,26}, {-7,27}, {-7,28}, {-7,29}, {-7,30}, {-7,31}, {-7,32}, {-7,33}, {-7,34}, {-7,35}, {-7,36}, {-7,37}, {-7,38}, {-7,39}, {-7,40}, {-7,41}, {-6,-45}, {-6,-44}, {-6,-43}, {-6,-42}, {-6,-41}, {-6,-40}, {-6,-39}, {-6,-38}, {-6,-37}, {-6,-36}, {-6,-35}, {-6,-34}, {-6,-33}, {-6,-32}, {-6,-31}, {-6,-30}, {-6,-29}, {-6,-28}, {-6,-27}, {-6,-26}, {-6,-25}, {-6,-24}, {-6,-23}, {-6,-22}, {-6,-21}, {-6,-20}, {-6,-19}, {-6,-18}, {-6,-17}, {-6,-2}, {-6,-1}, {-6,0}, {-6,1}, {-6,3}, {-6,4}, {-6,5}, {-6,6}, {-6,15}, {-6,16}, {-6,17}, {-6,18}, {-6,19}, {-6,20}, {-6,21}, {-6,22}, {-6,23}, {-6,24}, {-6,25}, {-6,26}, {-6,27}, {-6,28}, {-6,29}, {-6,30}, {-6,31}, {-6,32}, {-6,33}, {-6,34}, {-6,35}, {-6,36}, {-6,37}, {-6,38}, {-6,39}, {-6,40}, {-6,41}, {-5,-45}, {-5,-44}, {-5,-43}, {-5,-42}, {-5,-41}, {-5,-40}, {-5,-39}, {-5,-38}, {-5,-37}, {-5,-36}, {-5,-35}, {-5,-34}, {-5,-33}, {-5,-32}, {-5,-31}, {-5,-30}, {-5,-29}, {-5,-28}, {-5,-27}, {-5,-26}, {-5,-25}, {-5,-24}, {-5,-23}, {-5,-22}, {-5,-21}, {-5,-20}, {-5,-19}, {-5,-18}, {-5,-17}, {-5,-3}, {-5,-2}, {-5,-1}, {-5,0}, {-5,1}, {-5,2}, {-5,4}, {-5,5}, {-5,6}, {-5,17}, {-5,18}, {-5,19}, {-5,20}, {-5,21}, {-5,22}, {-5,23}, {-5,24}, {-5,25}, {-5,26}, {-5,27}, {-5,28}, {-5,29}, {-5,30}, {-5,31}, {-5,32}, {-5,33}, {-5,34}, {-5,35}, {-5,36}, {-5,37}, {-5,38}, {-5,39}, {-5,40}, {-5,41}, {-4,-44}, {-4,-43}, {-4,-42}, {-4,-41}, {-4,-40}, {-4,-39}, {-4,-38}, {-4,-37}, {-4,-36}, {-4,-35}, {-4,-34}, {-4,-33}, {-4,-32}, {-4,-31}, {-4,-30}, {-4,-29}, {-4,-28}, {-4,-27}, {-4,-26}, {-4,-25}, {-4,-24}, {-4,-23}, {-4,-22}, {-4,-21}, {-4,-20}, {-4,-19}, {-4,-18}, {-4,-17}, {-4,-16}, {-4,-3}, {-4,-2}, {-4,-1}, {-4,0}, {-4,1}, {-4,2}, {-4,3}, {-4,4}, {-4,20}, {-4,21}, {-4,22}, {-4,23}, {-4,24}, {-4,25}, {-4,26}, {-4,27}, {-4,28}, {-4,29}, {-4,30}, {-4,31}, {-4,32}, {-4,33}, {-4,34}, {-4,35}, {-4,36}, {-4,37}, {-4,38}, {-4,39}, {-4,40}, {-4,41}, {-3,-43}, {-3,-42}, {-3,-41}, {-3,-40}, {-3,-39}, {-3,-38}, {-3,-37}, {-3,-36}, {-3,-35}, {-3,-34}, {-3,-33}, {-3,-32}, {-3,-31}, {-3,-30}, {-3,-29}, {-3,-28}, {-3,-27}, {-3,-26}, {-3,-25}, {-3,-24}, {-3,-23}, {-3,-22}, {-3,-21}, {-3,-20}, {-3,-19}, {-3,-18}, {-3,-17}, {-3,-16}, {-3,-4}, {-3,-3}, {-3,-2}, {-3,-1}, {-3,0}, {-3,1}, {-3,2}, {-3,3}, {-3,20}, {-3,21}, {-3,22}, {-3,23}, {-3,24}, {-3,25}, {-3,26}, {-3,27}, {-3,28}, {-3,29}, {-3,30}, {-3,31}, {-3,32}, {-3,33}, {-3,34}, {-3,35}, {-3,36}, {-3,37}, {-3,38}, {-3,39}, {-3,40}, {-3,41}, {-2,-42}, {-2,-41}, {-2,-40}, {-2,-39}, {-2,-38}, {-2,-37}, {-2,-36}, {-2,-35}, {-2,-34}, {-2,-33}, {-2,-32}, {-2,-31}, {-2,-30}, {-2,-29}, {-2,-28}, {-2,-27}, {-2,-26}, {-2,-25}, {-2,-24}, {-2,-23}, {-2,-22}, {-2,-20}, {-2,-19}, {-2,-18}, {-2,-17}, {-2,-16}, {-2,-5}, {-2,-4}, {-2,-3}, {-2,-2}, {-2,-1}, {-2,0}, {-2,1}, {-2,2}, {-2,20}, {-2,21}, {-2,22}, {-2,23}, {-2,24}, {-2,25}, {-2,26}, {-2,27}, {-2,28}, {-2,29}, {-2,30}, {-2,31}, {-2,32}, {-2,33}, {-2,34}, {-2,35}, {-2,36}, {-2,37}, {-2,38}, {-2,39}, {-2,40}, {-2,41}, {-1,-41}, {-1,-40}, {-1,-39}, {-1,-38}, {-1,-37}, {-1,-36}, {-1,-35}, {-1,-34}, {-1,-33}, {-1,-32}, {-1,-31}, {-1,-30}, {-1,-29}, {-1,-28}, {-1,-27}, {-1,-26}, {-1,-25}, {-1,-24}, {-1,-23}, {-1,-22}, {-1,-21}, {-1,-20}, {-1,-19}, {-1,-18}, {-1,-17}, {-1,-16}, {-1,-15}, {-1,-14}, {-1,-6}, {-1,-5}, {-1,-4}, {-1,-3}, {-1,-2}, {-1,-1}, {-1,0}, {-1,1}, {-1,2}, {-1,3}, {-1,21}, {-1,22}, {-1,23}, {-1,24}, {-1,25}, {-1,26}, {-1,27}, {-1,28}, {-1,29}, {-1,30}, {-1,31}, {-1,32}, {-1,33}, {-1,34}, {-1,35}, {-1,36}, {-1,37}, {-1,38}, {-1,39}, {-1,40}, {-1,41}, {0,-41}, {0,-40}, {0,-39}, {0,-38}, {0,-37}, {0,-36}, {0,-35}, {0,-34}, {0,-33}, {0,-32}, {0,-31}, {0,-30}, {0,-29}, {0,-28}, {0,-27}, {0,-26}, {0,-25}, {0,-24}, {0,-23}, {0,-22}, {0,-21}, {0,-20}, {0,-19}, {0,-18}, {0,-17}, {0,-16}, {0,-15}, {0,-14}, {0,-13}, {0,-12}, {0,-11}, {0,-9}, {0,-8}, {0,-7}, {0,-6}, {0,-5}, {0,-4}, {0,-3}, {0,-2}, {0,-1}, {0,1}, {0,2}, {0,21}, {0,22}, {0,23}, {0,24}, {0,25}, {0,26}, {0,27}, {0,28}, {0,29}, {0,30}, {0,31}, {0,32}, {0,33}, {0,34}, {0,35}, {0,36}, {0,37}, {0,38}, {0,39}, {0,40}, {0,41}, {1,-40}, {1,-39}, {1,-38}, {1,-37}, {1,-36}, {1,-35}, {1,-34}, {1,-33}, {1,-32}, {1,-31}, {1,-30}, {1,-29}, {1,-28}, {1,-27}, {1,-26}, {1,-25}, {1,-24}, {1,-23}, {1,-22}, {1,-21}, {1,-20}, {1,-19}, {1,-18}, {1,-17}, {1,-16}, {1,-15}, {1,-13}, {1,-12}, {1,-11}, {1,-10}, {1,-9}, {1,-8}, {1,-7}, {1,-6}, {1,-5}, {1,-4}, {1,-3}, {1,-2}, {1,-1}, {1,0}, {1,1}, {1,2}, {1,21}, {1,22}, {1,23}, {1,24}, {1,25}, {1,26}, {1,27}, {1,28}, {1,29}, {1,30}, {1,31}, {1,32}, {1,33}, {1,34}, {1,35}, {1,36}, {1,37}, {1,38}, {1,39}, {1,40}, {1,41}, {2,-39}, {2,-38}, {2,-37}, {2,-36}, {2,-35}, {2,-34}, {2,-33}, {2,-32}, {2,-31}, {2,-30}, {2,-29}, {2,-28}, {2,-27}, {2,-26}, {2,-25}, {2,-24}, {2,-23}, {2,-22}, {2,-21}, {2,-20}, {2,-19}, {2,-18}, {2,-17}, {2,-11}, {2,-10}, {2,-9}, {2,-8}, {2,-7}, {2,-6}, {2,-5}, {2,-4}, {2,-3}, {2,-2}, {2,-1}, {2,0}, {2,1}, {2,22}, {2,23}, {2,24}, {2,25}, {2,26}, {2,27}, {2,28}, {2,29}, {2,30}, {2,31}, {2,32}, {2,33}, {2,34}, {2,35}, {2,36}, {2,37}, {2,38}, {2,39}, {2,40}, {2,41}, {3,-38}, {3,-37}, {3,-36}, {3,-35}, {3,-34}, {3,-33}, {3,-32}, {3,-31}, {3,-30}, {3,-29}, {3,-28}, {3,-27}, {3,-26}, {3,-25}, {3,-24}, {3,-23}, {3,-22}, {3,-21}, {3,-20}, {3,-19}, {3,-18}, {3,-17}, {3,-9}, {3,-8}, {3,-7}, {3,-6}, {3,-5}, {3,-4}, {3,-3}, {3,-2}, {3,-1}, {3,0}, {3,24}, {3,25}, {3,26}, {3,27}, {3,28}, {3,29}, {3,30}, {3,31}, {3,32}, {3,33}, {3,34}, {3,35}, {3,36}, {3,37}, {3,38}, {3,39}, {3,40}, {3,41}, {4,-37}, {4,-36}, {4,-35}, {4,-34}, {4,-33}, {4,-32}, {4,-31}, {4,-30}, {4,-29}, {4,-28}, {4,-27}, {4,-26}, {4,-25}, {4,-24}, {4,-23}, {4,-22}, {4,-21}, {4,-20}, {4,-19}, {4,-18}, {4,-9}, {4,-8}, {4,-7}, {4,-6}, {4,-5}, {4,-4}, {4,-3}, {4,-2}, {4,25}, {4,26}, {4,27}, {4,28}, {4,29}, {4,30}, {4,31}, {4,32}, {4,33}, {4,34}, {4,35}, {4,36}, {4,37}, {4,38}, {4,39}, {4,40}, {4,41}, {5,-37}, {5,-36}, {5,-35}, {5,-34}, {5,-33}, {5,-32}, {5,-31}, {5,-30}, {5,-29}, {5,-28}, {5,-27}, {5,-26}, {5,-25}, {5,-24}, {5,-23}, {5,-22}, {5,-21}, {5,-20}, {5,-19}, {5,-18}, {5,-10}, {5,-9}, {5,-8}, {5,-7}, {5,-6}, {5,-5}, {5,-4}, {5,25}, {5,26}, {5,27}, {5,28}, {5,29}, {5,30}, {5,31}, {5,32}, {5,33}, {5,34}, {5,35}, {5,36}, {5,37}, {5,38}, {5,39}, {5,40}, {5,41}, {6,-36}, {6,-35}, {6,-34}, {6,-33}, {6,-32}, {6,-31}, {6,-30}, {6,-29}, {6,-28}, {6,-27}, {6,-26}, {6,-25}, {6,-24}, {6,-23}, {6,-22}, {6,-21}, {6,-20}, {6,-19}, {6,-18}, {6,-11}, {6,-10}, {6,-9}, {6,-8}, {6,-6}, {6,26}, {6,27}, {6,28}, {6,29}, {6,30}, {6,31}, {6,32}, {6,33}, {6,34}, {6,35}, {6,36}, {6,37}, {6,38}, {6,39}, {6,40}, {6,41}, {7,-36}, {7,-35}, {7,-34}, {7,-33}, {7,-32}, {7,-31}, {7,-30}, {7,-29}, {7,-28}, {7,-27}, {7,-26}, {7,-25}, {7,-24}, {7,-23}, {7,-22}, {7,-21}, {7,-20}, {7,-19}, {7,-18}, {7,-17}, {7,-13}, {7,-12}, {7,-11}, {7,-10}, {7,-9}, {7,-8}, {7,26}, {7,27}, {7,28}, {7,29}, {7,30}, {7,31}, {7,32}, {7,33}, {7,34}, {7,35}, {7,36}, {7,37}, {7,38}, {7,39}, {7,40}, {8,-35}, {8,-34}, {8,-33}, {8,-32}, {8,-31}, {8,-30}, {8,-29}, {8,-28}, {8,-27}, {8,-26}, {8,-25}, {8,-24}, {8,-23}, {8,-22}, {8,-21}, {8,-20}, {8,-19}, {8,-18}, {8,-17}, {8,-16}, {8,-15}, {8,-14}, {8,-13}, {8,-12}, {8,-11}, {8,-10}, {8,-9}, {8,-8}, {8,26}, {8,27}, {8,28}, {8,29}, {8,30}, {8,31}, {8,32}, {8,33}, {8,34}, {8,35}, {8,36}, {8,37}, {8,38}, {8,39}, {8,40}, {9,-35}, {9,-34}, {9,-33}, {9,-32}, {9,-31}, {9,-30}, {9,-29}, {9,-28}, {9,-27}, {9,-26}, {9,-25}, {9,-24}, {9,-23}, {9,-22}, {9,-21}, {9,-20}, {9,-19}, {9,-18}, {9,-17}, {9,-16}, {9,-15}, {9,-14}, {9,-13}, {9,-12}, {9,-11}, {9,-10}, {9,-9}, {9,-8}, {9,26}, {9,27}, {9,28}, {9,29}, {9,30}, {9,31}, {9,32}, {9,33}, {9,34}, {9,35}, {9,36}, {9,37}, {9,38}, {9,39}, {10,-34}, {10,-33}, {10,-32}, {10,-31}, {10,-30}, {10,-29}, {10,-28}, {10,-27}, {10,-26}, {10,-25}, {10,-24}, {10,-23}, {10,-22}, {10,-21}, {10,-20}, {10,-19}, {10,-18}, {10,-17}, {10,-16}, {10,-15}, {10,-14}, {10,-13}, {10,-12}, {10,-11}, {10,-10}, {10,-9}, {10,-8}, {10,26}, {10,27}, {10,28}, {10,29}, {10,30}, {10,31}, {10,32}, {10,33}, {10,34}, {10,35}, {10,36}, {10,37}, {10,38}, {10,39}, {11,-34}, {11,-33}, {11,-32}, {11,-31}, {11,-30}, {11,-29}, {11,-28}, {11,-27}, {11,-26}, {11,-25}, {11,-24}, {11,-23}, {11,-22}, {11,-21}, {11,-20}, {11,-19}, {11,-18}, {11,-17}, {11,-16}, {11,-15}, {11,-14}, {11,-13}, {11,-12}, {11,-11}, {11,-10}, {11,-9}, {11,-8}, {11,25}, {11,26}, {11,27}, {11,28}, {11,29}, {11,30}, {11,31}, {11,32}, {11,33}, {11,34}, {11,35}, {11,36}, {11,37}, {11,38}, {12,-33}, {12,-32}, {12,-31}, {12,-30}, {12,-29}, {12,-28}, {12,-27}, {12,-26}, {12,-25}, {12,-24}, {12,-23}, {12,-22}, {12,-21}, {12,-20}, {12,-19}, {12,-18}, {12,-17}, {12,-16}, {12,-15}, {12,-14}, {12,-13}, {12,-12}, {12,-11}, {12,-10}, {12,-9}, {12,-8}, {12,25}, {12,26}, {12,27}, {12,28}, {12,29}, {12,30}, {12,31}, {12,32}, {12,33}, {12,34}, {12,35}, {12,36}, {12,37}, {12,38}, {13,-32}, {13,-31}, {13,-30}, {13,-29}, {13,-28}, {13,-27}, {13,-26}, {13,-25}, {13,-24}, {13,-23}, {13,-22}, {13,-21}, {13,-20}, {13,-19}, {13,-18}, {13,-17}, {13,-16}, {13,-15}, {13,-14}, {13,-13}, {13,-12}, {13,-11}, {13,-10}, {13,-9}, {13,-8}, {13,24}, {13,25}, {13,26}, {13,27}, {13,28}, {13,29}, {13,30}, {13,31}, {13,32}, {13,33}, {13,34}, {13,35}, {13,36}, {13,37}, {14,-29}, {14,-28}, {14,-27}, {14,-26}, {14,-25}, {14,-24}, {14,-23}, {14,-22}, {14,-21}, {14,-20}, {14,-19}, {14,-18}, {14,-17}, {14,-16}, {14,-15}, {14,-14}, {14,-13}, {14,-12}, {14,-11}, {14,-10}, {14,-9}, {14,-8}, {14,24}, {14,25}, {14,26}, {14,27}, {14,28}, {14,29}, {14,30}, {14,31}, {14,32}, {14,33}, {14,34}, {14,35}, {14,36}, {14,37}, {15,-27}, {15,-26}, {15,-25}, {15,-24}, {15,-23}, {15,-22}, {15,-21}, {15,-20}, {15,-19}, {15,-18}, {15,-17}, {15,-16}, {15,-15}, {15,-14}, {15,-13}, {15,-12}, {15,-11}, {15,-10}, {15,-9}, {15,-8}, {15,23}, {15,24}, {15,25}, {15,26}, {15,27}, {15,28}, {15,29}, {15,30}, {15,31}, {15,32}, {15,33}, {15,34}, {15,35}, {15,36}, {15,37}, {16,-25}, {16,-24}, {16,-23}, {16,-22}, {16,-21}, {16,-20}, {16,-19}, {16,-18}, {16,-17}, {16,-16}, {16,-15}, {16,-14}, {16,-13}, {16,-12}, {16,-11}, {16,-10}, {16,-9}, {16,-8}, {16,23}, {16,24}, {16,25}, {16,26}, {16,27}, {16,28}, {16,29}, {16,30}, {16,31}, {16,32}, {16,33}, {16,34}, {16,35}, {16,36}, {16,37}, {17,-23}, {17,-22}, {17,-21}, {17,-20}, {17,-19}, {17,-18}, {17,-17}, {17,-16}, {17,-15}, {17,-14}, {17,-13}, {17,-12}, {17,-11}, {17,-10}, {17,-9}, {17,-8}, {17,22}, {17,23}, {17,24}, {17,25}, {17,26}, {17,27}, {17,28}, {17,29}, {17,30}, {17,31}, {17,32}, {17,33}, {17,34}, {17,35}, {17,36}, {18,-21}, {18,-20}, {18,-19}, {18,-18}, {18,-17}, {18,-16}, {18,-15}, {18,-14}, {18,-13}, {18,-12}, {18,-11}, {18,-10}, {18,-9}, {18,-8}, {18,22}, {18,23}, {18,24}, {18,25}, {18,26}, {18,27}, {18,28}, {18,29}, {18,30}, {18,31}, {18,32}, {18,33}, {18,34}, {18,35}, {19,-12}, {19,-11}, {19,-10}, {19,-9}, {19,-8}, {19,22}, {19,23}, {19,24}, {19,25}, {19,26}, {19,27}, {19,28}, {19,29}, {20,-9}, {20,-8}, {20,21}, {20,22}, {20,23}, {20,24}, {20,25}, {20,26}, {20,27}, {21,21}, {21,22}, {21,23}, {21,24}, {21,25}, {22,21}, {22,22}, {22,23}, {22,24}, {23,21}, {23,22}, {30,33}, {30,34}, {30,35}, {30,36}, {31,32}, {31,33}, {31,34}, {31,35}, {31,36}, {32,31}, {32,32}, {32,33}, {32,34}, {32,35}, {33,29}, },
    ["se-asteroid"] = {{-33,-24}, {-33,-23}, {-33,-22}, {-33,-21}, {-32,-26}, {-32,-25}, {-32,-24}, {-32,-23}, {-32,-22}, {-32,-21}, {-31,-26}, {-31,-25}, {-31,-24}, {-31,-23}, {-31,-22}, {-31,-21}, {-30,-27}, {-30,-26}, {-30,-25}, {-30,-24}, {-30,-23}, {-30,-22}, {-30,-21}, {-29,-27}, {-29,-26}, {-29,-25}, {-29,-24}, {-29,-23}, {-29,-22}, {-29,-21}, {-28,-28}, {-28,-27}, {-28,-26}, {-28,-25}, {-28,-24}, {-28,-23}, {-28,-22}, {-28,-21}, {-27,-28}, {-27,-27}, {-27,-26}, {-27,-25}, {-27,-24}, {-27,-23}, {-27,-22}, {-27,-21}, {-27,-20}, {-26,-28}, {-26,-27}, {-26,-26}, {-26,-25}, {-26,-24}, {-26,-23}, {-26,-22}, {-26,-21}, {-26,-20}, {-25,-28}, {-25,-27}, {-25,-26}, {-25,-25}, {-25,-24}, {-25,-23}, {-25,-22}, {-25,-21}, {-25,-20}, {-25,-19}, {-24,-27}, {-24,-26}, {-24,-25}, {-24,-24}, {-24,-23}, {-24,-22}, {-24,-21}, {-24,-20}, {-24,-19}, {-24,-18}, {-23,-23}, {-23,-22}, {-23,-21}, {-23,-20}, {-23,-19}, {-23,-18}, {-22,-21}, {-22,-20}, {-22,-19}, {-21,-21}, {-12,-29}, {-12,-11}, {-12,-10}, {-11,-31}, {-11,-30}, {-11,-29}, {-11,-28}, {-11,-27}, {-11,-14}, {-11,-13}, {-11,-12}, {-11,-11}, {-11,-10}, {-11,-9}, {-11,-8}, {-11,-4}, {-11,-3}, {-10,-31}, {-10,-30}, {-10,-29}, {-10,-28}, {-10,-15}, {-10,-14}, {-10,-13}, {-10,-12}, {-10,-11}, {-10,-10}, {-10,-9}, {-10,-8}, {-10,-7}, {-9,-32}, {-9,-31}, {-9,-30}, {-9,-29}, {-9,-28}, {-9,-16}, {-9,-15}, {-9,-14}, {-9,-13}, {-9,-12}, {-9,-11}, {-9,-10}, {-9,-9}, {-9,-8}, {-9,-7}, {-9,-6}, {-9,2}, {-9,3}, {-9,4}, {-8,-31}, {-8,-30}, {-8,-29}, {-8,-28}, {-8,-16}, {-8,-15}, {-8,-14}, {-8,-13}, {-8,-12}, {-8,-11}, {-8,-10}, {-8,-9}, {-8,-8}, {-8,-7}, {-8,-6}, {-8,-5}, {-8,2}, {-8,3}, {-8,4}, {-7,-31}, {-7,-30}, {-7,-29}, {-7,-16}, {-7,-15}, {-7,-14}, {-7,-13}, {-7,-12}, {-7,-11}, {-7,-10}, {-7,-9}, {-7,-8}, {-7,-7}, {-7,-6}, {-7,-5}, {-7,-4}, {-7,-3}, {-7,-2}, {-7,2}, {-7,3}, {-7,9}, {-7,10}, {-7,11}, {-7,12}, {-6,-16}, {-6,-15}, {-6,-14}, {-6,-13}, {-6,-12}, {-6,-11}, {-6,-10}, {-6,-9}, {-6,-8}, {-6,-7}, {-6,-6}, {-6,-5}, {-6,-4}, {-6,-3}, {-6,7}, {-6,8}, {-6,9}, {-6,10}, {-6,11}, {-6,12}, {-6,13}, {-6,14}, {-5,-16}, {-5,-15}, {-5,-14}, {-5,-13}, {-5,-12}, {-5,-11}, {-5,-10}, {-5,-9}, {-5,-8}, {-5,-7}, {-5,-6}, {-5,-5}, {-5,-4}, {-5,7}, {-5,8}, {-5,9}, {-5,10}, {-5,11}, {-5,12}, {-5,13}, {-5,14}, {-5,15}, {-5,16}, {-4,-15}, {-4,-14}, {-4,-13}, {-4,-12}, {-4,-11}, {-4,-10}, {-4,-9}, {-4,-8}, {-4,-7}, {-4,-6}, {-4,-5}, {-4,-4}, {-4,5}, {-4,6}, {-4,7}, {-4,8}, {-4,9}, {-4,10}, {-4,11}, {-4,12}, {-4,13}, {-4,14}, {-4,15}, {-4,16}, {-4,17}, {-4,18}, {-4,19}, {-3,-15}, {-3,-14}, {-3,-13}, {-3,-12}, {-3,-11}, {-3,-10}, {-3,-9}, {-3,-8}, {-3,-7}, {-3,-6}, {-3,-5}, {-3,4}, {-3,5}, {-3,6}, {-3,7}, {-3,8}, {-3,9}, {-3,10}, {-3,11}, {-3,12}, {-3,13}, {-3,14}, {-3,15}, {-3,16}, {-3,17}, {-3,18}, {-3,19}, {-2,-21}, {-2,-15}, {-2,-14}, {-2,-13}, {-2,-12}, {-2,-11}, {-2,-10}, {-2,-9}, {-2,-8}, {-2,-7}, {-2,-6}, {-2,3}, {-2,4}, {-2,5}, {-2,6}, {-2,7}, {-2,8}, {-2,9}, {-2,10}, {-2,11}, {-2,12}, {-2,13}, {-2,14}, {-2,15}, {-2,16}, {-2,17}, {-2,18}, {-2,19}, {-1,-13}, {-1,-12}, {-1,-11}, {-1,-10}, {-1,-9}, {-1,-8}, {-1,-7}, {-1,4}, {-1,5}, {-1,6}, {-1,7}, {-1,8}, {-1,9}, {-1,10}, {-1,11}, {-1,12}, {-1,13}, {-1,14}, {-1,15}, {-1,16}, {-1,17}, {-1,18}, {-1,19}, {-1,20}, {0,-10}, {0,0}, {0,3}, {0,4}, {0,5}, {0,6}, {0,7}, {0,8}, {0,9}, {0,10}, {0,11}, {0,12}, {0,13}, {0,14}, {0,15}, {0,16}, {0,17}, {0,18}, {0,19}, {0,20}, {1,-14}, {1,3}, {1,4}, {1,5}, {1,6}, {1,7}, {1,8}, {1,9}, {1,10}, {1,11}, {1,12}, {1,13}, {1,14}, {1,15}, {1,16}, {1,17}, {1,18}, {1,19}, {1,20}, {2,-16}, {2,-15}, {2,-14}, {2,-13}, {2,-12}, {2,2}, {2,3}, {2,4}, {2,5}, {2,6}, {2,7}, {2,8}, {2,9}, {2,10}, {2,11}, {2,12}, {2,13}, {2,14}, {2,15}, {2,16}, {2,17}, {2,18}, {2,19}, {2,20}, {2,21}, {3,-16}, {3,-15}, {3,-14}, {3,-13}, {3,-12}, {3,-11}, {3,-10}, {3,1}, {3,2}, {3,3}, {3,4}, {3,5}, {3,6}, {3,7}, {3,8}, {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, {3,14}, {3,15}, {3,16}, {3,17}, {3,18}, {3,19}, {3,20}, {3,21}, {3,22}, {3,23}, {4,-17}, {4,-16}, {4,-15}, {4,-14}, {4,-13}, {4,-12}, {4,-11}, {4,-10}, {4,-1}, {4,0}, {4,1}, {4,2}, {4,3}, {4,4}, {4,5}, {4,6}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, {4,13}, {4,14}, {4,15}, {4,16}, {4,17}, {4,18}, {4,19}, {4,20}, {4,21}, {4,22}, {4,23}, {4,24}, {5,-17}, {5,-16}, {5,-15}, {5,-14}, {5,-13}, {5,-12}, {5,-11}, {5,-3}, {5,-2}, {5,-1}, {5,0}, {5,1}, {5,2}, {5,3}, {5,4}, {5,5}, {5,6}, {5,7}, {5,8}, {5,9}, {5,10}, {5,11}, {5,12}, {5,13}, {5,14}, {5,15}, {5,16}, {5,17}, {5,18}, {5,19}, {5,20}, {5,21}, {5,22}, {5,23}, {5,24}, {6,-17}, {6,-16}, {6,-15}, {6,-14}, {6,-13}, {6,-12}, {6,-7}, {6,-5}, {6,-4}, {6,-3}, {6,-2}, {6,-1}, {6,0}, {6,1}, {6,2}, {6,3}, {6,4}, {6,5}, {6,6}, {6,7}, {6,8}, {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, {6,14}, {6,15}, {6,16}, {6,17}, {6,18}, {6,19}, {6,20}, {6,21}, {6,22}, {6,23}, {6,24}, {6,25}, {7,-16}, {7,-15}, {7,-14}, {7,-7}, {7,-6}, {7,-5}, {7,-4}, {7,-3}, {7,-2}, {7,-1}, {7,0}, {7,1}, {7,2}, {7,3}, {7,4}, {7,5}, {7,6}, {7,7}, {7,8}, {7,9}, {7,10}, {7,11}, {7,12}, {7,13}, {7,14}, {7,15}, {7,16}, {7,17}, {7,18}, {7,19}, {7,20}, {7,21}, {7,22}, {7,23}, {7,24}, {7,25}, {8,-7}, {8,-6}, {8,-5}, {8,-4}, {8,-3}, {8,-2}, {8,-1}, {8,0}, {8,1}, {8,2}, {8,3}, {8,4}, {8,5}, {8,6}, {8,7}, {8,8}, {8,9}, {8,10}, {8,11}, {8,12}, {8,13}, {8,14}, {8,15}, {8,16}, {8,17}, {8,18}, {8,19}, {8,20}, {8,21}, {8,22}, {8,23}, {8,24}, {8,25}, {9,-7}, {9,-6}, {9,-5}, {9,-4}, {9,-3}, {9,-2}, {9,-1}, {9,0}, {9,1}, {9,2}, {9,3}, {9,4}, {9,5}, {9,6}, {9,7}, {9,8}, {9,9}, {9,10}, {9,11}, {9,12}, {9,13}, {9,14}, {9,15}, {9,16}, {9,17}, {9,18}, {9,19}, {9,20}, {9,21}, {9,22}, {9,23}, {9,24}, {9,25}, {10,-7}, {10,-6}, {10,-5}, {10,-4}, {10,-3}, {10,-2}, {10,-1}, {10,0}, {10,1}, {10,2}, {10,3}, {10,4}, {10,5}, {10,6}, {10,7}, {10,8}, {10,9}, {10,10}, {10,11}, {10,12}, {10,13}, {10,14}, {10,15}, {10,16}, {10,17}, {10,18}, {10,19}, {10,20}, {10,21}, {10,22}, {10,23}, {10,24}, {10,25}, {11,-7}, {11,-6}, {11,-5}, {11,-4}, {11,-3}, {11,-2}, {11,-1}, {11,0}, {11,1}, {11,2}, {11,3}, {11,4}, {11,5}, {11,6}, {11,7}, {11,8}, {11,9}, {11,10}, {11,11}, {11,12}, {11,13}, {11,14}, {11,15}, {11,16}, {11,17}, {11,18}, {11,19}, {11,20}, {11,21}, {11,22}, {11,23}, {11,24}, {12,-7}, {12,-6}, {12,-5}, {12,-4}, {12,-3}, {12,-2}, {12,-1}, {12,0}, {12,1}, {12,2}, {12,3}, {12,4}, {12,5}, {12,6}, {12,7}, {12,8}, {12,9}, {12,10}, {12,11}, {12,12}, {12,13}, {12,14}, {12,15}, {12,16}, {12,17}, {12,18}, {12,19}, {12,20}, {12,21}, {12,22}, {12,23}, {12,24}, {13,-7}, {13,-6}, {13,-5}, {13,-4}, {13,-3}, {13,-2}, {13,-1}, {13,0}, {13,1}, {13,2}, {13,3}, {13,4}, {13,5}, {13,6}, {13,7}, {13,8}, {13,9}, {13,10}, {13,11}, {13,12}, {13,13}, {13,14}, {13,15}, {13,16}, {13,17}, {13,18}, {13,19}, {13,20}, {13,21}, {13,22}, {13,23}, {14,-7}, {14,-6}, {14,-5}, {14,-4}, {14,-3}, {14,-2}, {14,-1}, {14,0}, {14,1}, {14,2}, {14,3}, {14,4}, {14,5}, {14,6}, {14,7}, {14,8}, {14,9}, {14,10}, {14,11}, {14,12}, {14,13}, {14,14}, {14,15}, {14,16}, {14,17}, {14,18}, {14,19}, {14,20}, {14,21}, {14,22}, {14,23}, {15,-7}, {15,-6}, {15,-5}, {15,-4}, {15,-3}, {15,-2}, {15,-1}, {15,0}, {15,1}, {15,2}, {15,3}, {15,4}, {15,5}, {15,6}, {15,7}, {15,8}, {15,9}, {15,10}, {15,11}, {15,12}, {15,13}, {15,14}, {15,15}, {15,16}, {15,17}, {15,18}, {15,19}, {15,20}, {15,21}, {15,22}, {16,-7}, {16,-6}, {16,-5}, {16,-4}, {16,-3}, {16,-2}, {16,-1}, {16,0}, {16,1}, {16,2}, {16,3}, {16,4}, {16,5}, {16,6}, {16,7}, {16,8}, {16,9}, {16,10}, {16,11}, {16,12}, {16,13}, {16,14}, {16,15}, {16,16}, {16,17}, {16,18}, {16,19}, {16,20}, {16,21}, {16,22}, {17,-7}, {17,-6}, {17,-5}, {17,-4}, {17,-3}, {17,-2}, {17,-1}, {17,0}, {17,1}, {17,2}, {17,3}, {17,4}, {17,5}, {17,6}, {17,7}, {17,8}, {17,9}, {17,10}, {17,11}, {17,12}, {17,13}, {17,14}, {17,15}, {17,16}, {17,17}, {17,18}, {17,19}, {17,20}, {17,21}, {18,-7}, {18,-6}, {18,-5}, {18,-4}, {18,-3}, {18,-2}, {18,-1}, {18,0}, {18,1}, {18,2}, {18,3}, {18,4}, {18,5}, {18,6}, {18,7}, {18,8}, {18,9}, {18,10}, {18,11}, {18,12}, {18,13}, {18,14}, {18,15}, {18,16}, {18,17}, {18,18}, {18,19}, {18,20}, {18,21}, {19,-7}, {19,-6}, {19,-5}, {19,-4}, {19,-3}, {19,-2}, {19,-1}, {19,0}, {19,1}, {19,2}, {19,3}, {19,4}, {19,5}, {19,6}, {19,7}, {19,8}, {19,9}, {19,10}, {19,11}, {19,12}, {19,13}, {19,14}, {19,15}, {19,16}, {19,17}, {19,18}, {19,19}, {19,20}, {19,21}, {20,-7}, {20,-6}, {20,-5}, {20,-4}, {20,-3}, {20,-2}, {20,-1}, {20,0}, {20,1}, {20,2}, {20,3}, {20,4}, {20,5}, {20,6}, {20,7}, {20,8}, {20,9}, {20,10}, {20,11}, {20,12}, {20,13}, {20,14}, {20,15}, {20,16}, {20,17}, {20,18}, {20,19}, {20,20}, {21,-7}, {21,-6}, {21,-5}, {21,-4}, {21,-3}, {21,-2}, {21,-1}, {21,0}, {21,1}, {21,2}, {21,3}, {21,4}, {21,5}, {21,6}, {21,7}, {21,8}, {21,9}, {21,10}, {21,11}, {21,12}, {21,13}, {21,14}, {21,15}, {21,16}, {21,17}, {21,18}, {21,19}, {21,20}, {22,-6}, {22,-5}, {22,-4}, {22,-3}, {22,-2}, {22,-1}, {22,0}, {22,1}, {22,2}, {22,3}, {22,4}, {22,5}, {22,6}, {22,7}, {22,8}, {22,9}, {22,10}, {22,11}, {22,12}, {22,13}, {22,14}, {22,15}, {22,16}, {22,17}, {22,18}, {22,19}, {22,20}, {23,-5}, {23,-4}, {23,-3}, {23,-2}, {23,-1}, {23,0}, {23,1}, {23,2}, {23,3}, {23,4}, {23,5}, {23,6}, {23,7}, {23,8}, {23,9}, {23,10}, {23,11}, {23,12}, {23,13}, {23,14}, {23,15}, {23,16}, {23,17}, {23,18}, {23,19}, {23,20}, {24,-5}, {24,-4}, {24,-3}, {24,-2}, {24,-1}, {24,0}, {24,1}, {24,2}, {24,3}, {24,4}, {24,5}, {24,6}, {24,7}, {24,8}, {24,9}, {24,10}, {24,11}, {24,12}, {24,13}, {24,14}, {24,15}, {24,16}, {24,17}, {24,18}, {24,19}, {24,20}, {25,-4}, {25,-3}, {25,-2}, {25,-1}, {25,0}, {25,1}, {25,2}, {25,3}, {25,4}, {25,5}, {25,6}, {25,7}, {25,8}, {25,9}, {25,10}, {25,11}, {25,12}, {25,13}, {25,14}, {25,15}, {25,16}, {25,17}, {25,18}, {25,19}, {26,-4}, {26,-3}, {26,-2}, {26,-1}, {26,0}, {26,1}, {26,2}, {26,3}, {26,4}, {26,5}, {26,6}, {26,7}, {26,8}, {26,9}, {26,10}, {26,11}, {26,12}, {26,13}, {26,14}, {26,15}, {26,16}, {26,17}, {26,18}, {26,19}, {27,-3}, {27,-2}, {27,-1}, {27,0}, {27,1}, {27,2}, {27,3}, {27,4}, {27,5}, {27,6}, {27,7}, {27,8}, {27,9}, {27,10}, {27,11}, {27,12}, {27,13}, {27,14}, {27,15}, {27,16}, {27,17}, {28,-2}, {28,-1}, {28,0}, {28,1}, {28,2}, {28,3}, {28,4}, {28,5}, {28,6}, {28,7}, {28,8}, {28,9}, {28,10}, {28,11}, {28,12}, {28,13}, {28,14}, {28,15}, {28,16}, {29,-1}, {29,0}, {29,1}, {29,2}, {29,3}, {29,4}, {29,5}, {29,6}, {29,7}, {29,8}, {29,9}, {29,10}, {29,11}, {29,12}, {29,13}, {29,14}, {29,15}, {30,0}, {30,1}, {30,2}, {30,3}, {30,4}, {30,5}, {30,6}, {30,7}, {30,8}, {30,9}, {30,10}, {30,11}, {30,12}, {30,13}, {31,0}, {31,1}, {31,2}, {31,3}, {31,4}, {31,5}, {31,6}, {31,7}, {31,8}, {31,9}, {31,10}, {31,11}, {31,12}, {32,7}, {32,8}, {32,9}, },
    ["se-spaceship-floor"] = {{-29,7}, {-29,8}, {-29,9}, {-29,10}, {-29,11}, {-29,12}, {-29,13}, {-29,14}, {-28,6}, {-28,7}, {-28,8}, {-28,9}, {-28,10}, {-28,11}, {-28,12}, {-28,13}, {-28,14}, {-27,6}, {-27,7}, {-27,8}, {-27,9}, {-27,10}, {-27,11}, {-27,12}, {-27,13}, {-27,14}, {-26,1}, {-26,2}, {-26,3}, {-26,4}, {-26,5}, {-26,6}, {-26,7}, {-26,8}, {-26,9}, {-26,10}, {-26,11}, {-26,12}, {-26,13}, {-26,14}, {-25,0}, {-25,1}, {-25,2}, {-25,3}, {-25,4}, {-25,5}, {-25,6}, {-25,7}, {-25,8}, {-25,9}, {-25,10}, {-25,11}, {-24,-3}, {-24,-2}, {-24,-1}, {-24,0}, {-24,1}, {-24,2}, {-24,3}, {-24,4}, {-24,5}, {-24,6}, {-24,7}, {-24,8}, {-24,9}, {-24,10}, {-24,11}, {-24,12}, {-24,13}, {-24,14}, {-24,15}, {-24,16}, {-23,-4}, {-23,-3}, {-23,-2}, {-23,-1}, {-23,0}, {-23,1}, {-23,2}, {-23,3}, {-23,4}, {-23,5}, {-23,6}, {-23,7}, {-23,8}, {-23,9}, {-23,10}, {-23,11}, {-23,12}, {-23,13}, {-23,14}, {-23,15}, {-23,16}, {-23,17}, {-22,-7}, {-22,-6}, {-22,-5}, {-22,-4}, {-22,-3}, {-22,-2}, {-22,-1}, {-22,0}, {-22,1}, {-22,2}, {-22,3}, {-22,4}, {-22,5}, {-22,6}, {-22,7}, {-22,8}, {-22,9}, {-22,10}, {-22,11}, {-22,12}, {-22,13}, {-22,14}, {-22,15}, {-22,16}, {-22,17}, {-22,18}, {-21,-12}, {-21,-11}, {-21,-10}, {-21,-9}, {-21,-8}, {-21,-7}, {-21,-6}, {-21,-5}, {-21,-4}, {-21,-3}, {-21,-2}, {-21,-1}, {-21,0}, {-21,1}, {-21,2}, {-21,3}, {-21,4}, {-21,5}, {-21,6}, {-21,7}, {-21,8}, {-21,9}, {-21,10}, {-21,11}, {-21,12}, {-21,13}, {-21,14}, {-21,15}, {-21,16}, {-21,17}, {-21,18}, {-20,-13}, {-20,-12}, {-20,-11}, {-20,-10}, {-20,-9}, {-20,-8}, {-20,-7}, {-20,-6}, {-20,-5}, {-20,-4}, {-20,-3}, {-20,-2}, {-20,-1}, {-20,0}, {-20,1}, {-20,2}, {-20,3}, {-20,4}, {-20,5}, {-20,6}, {-20,7}, {-20,8}, {-20,9}, {-20,10}, {-20,11}, {-20,12}, {-20,13}, {-20,14}, {-20,15}, {-20,16}, {-20,17}, {-19,-14}, {-19,-13}, {-19,-12}, {-19,-11}, {-19,-10}, {-19,-9}, {-19,-8}, {-19,-7}, {-19,-6}, {-19,-5}, {-19,-4}, {-19,-3}, {-19,-2}, {-19,-1}, {-19,0}, {-19,1}, {-19,2}, {-19,3}, {-19,4}, {-19,5}, {-19,6}, {-19,7}, {-19,8}, {-19,9}, {-19,10}, {-19,11}, {-19,12}, {-19,13}, {-19,14}, {-19,15}, {-19,16}, {-19,17}, {-18,-14}, {-18,-13}, {-18,-12}, {-18,-11}, {-18,-10}, {-18,-9}, {-18,-8}, {-18,-7}, {-18,-6}, {-18,-5}, {-18,-4}, {-18,-3}, {-18,-2}, {-18,-1}, {-18,0}, {-18,1}, {-18,2}, {-18,3}, {-18,4}, {-18,5}, {-18,6}, {-18,7}, {-18,8}, {-18,9}, {-18,10}, {-18,11}, {-18,12}, {-18,13}, {-18,14}, {-18,15}, {-18,16}, {-18,17}, {-17,-13}, {-17,-12}, {-17,-11}, {-17,-10}, {-17,-9}, {-17,-8}, {-17,-7}, {-17,-6}, {-17,-5}, {-17,-4}, {-17,-3}, {-17,-2}, {-17,-1}, {-17,0}, {-17,1}, {-17,2}, {-17,3}, {-17,4}, {-17,5}, {-17,6}, {-17,7}, {-17,8}, {-17,9}, {-17,10}, {-17,11}, {-17,12}, {-17,13}, {-17,14}, {-17,15}, {-17,16}, {-17,17}, {-16,-12}, {-16,-11}, {-16,-10}, {-16,-9}, {-16,-8}, {-16,-7}, {-16,-6}, {-16,-5}, {-16,-4}, {-16,-3}, {-16,-2}, {-16,-1}, {-16,0}, {-16,1}, {-16,2}, {-16,3}, {-16,4}, {-16,5}, {-16,6}, {-16,7}, {-16,8}, {-16,9}, {-16,10}, {-16,11}, {-16,12}, {-16,13}, {-16,14}, {-16,15}, {-16,16}, {-16,17}, {-16,18}, {-15,-7}, {-15,-6}, {-15,-5}, {-15,-4}, {-15,-3}, {-15,-2}, {-15,-1}, {-15,0}, {-15,1}, {-15,6}, {-15,7}, {-15,8}, {-15,9}, {-15,10}, {-15,11}, {-15,12}, {-15,13}, {-15,14}, {-15,15}, {-15,16}, {-15,17}, {-15,18}, {-14,-4}, {-14,-3}, {-14,-2}, {-14,-1}, {-14,0}, {-14,6}, {-14,7}, {-14,8}, {-14,9}, {-14,10}, {-14,11}, {-14,12}, {-14,13}, {-14,14}, {-14,15}, {-14,16}, {-14,17}, {-13,-3}, {-13,-2}, {-13,-1}, {-13,0}, {-13,1}, {-13,6}, {-13,7}, {-13,8}, {-13,9}, {-13,10}, {-13,11}, {-13,12}, {-13,13}, {-13,14}, {-13,15}, {-13,16}, {-12,4}, {-12,6}, {-12,7}, {-12,8}, {-12,9}, {-12,10}, {-12,11}, {-11,6}, {-11,7}, {-11,8}, {-11,9}, {-11,10}, {-11,11}, {-10,6}, {-10,7}, {-10,8}, {-10,9}, {-9,6}, {-9,7}, {-9,8}, {-9,9}, {-8,7}, {-8,8}, {-8,9}, },
    ["se-space-platform-scaffold"] = {{-15,2}, {-15,3}, {-15,5}, {-14,1}, {-14,3}, {-14,4}, {-14,5}, {-13,3}, {-13,4}, {-13,5}, {-12,0}, {-12,1}, {-12,2}, {-12,3}, {-12,5}, {-11,1}, {-11,2}, {-11,3}, {-11,4}, {-11,5}, {-11,12}, {-11,13}, {-10,10}, {-10,11}, {-10,12}, {-10,13}, {-10,14}, {-9,-3}, {-9,10}, {-9,11}, {-8,10}, {-8,11}, {-8,12}, {-8,13}, {-6,2}, {-5,3}, },
  },
  under_tiles = {
    ["se-space"] = {{-29,7}, {-29,8}, {-29,9}, {-29,10}, {-29,11}, {-29,12}, {-29,13}, {-29,14}, {-28,6}, {-28,7}, {-28,8}, {-28,9}, {-28,10}, {-28,11}, {-28,12}, {-28,13}, {-28,14}, {-27,6}, {-27,7}, {-27,8}, {-27,9}, {-27,10}, {-27,11}, {-27,12}, {-27,13}, {-27,14}, {-26,1}, {-26,2}, {-26,3}, {-26,4}, {-26,5}, {-26,6}, {-26,7}, {-26,8}, {-26,9}, {-26,10}, {-26,11}, {-26,12}, {-26,13}, {-26,14}, {-25,0}, {-25,1}, {-25,2}, {-25,3}, {-25,4}, {-25,5}, {-25,6}, {-25,7}, {-25,8}, {-25,9}, {-25,10}, {-25,11}, {-24,-3}, {-24,-2}, {-24,-1}, {-24,0}, {-24,1}, {-24,2}, {-24,3}, {-24,4}, {-24,5}, {-24,6}, {-24,7}, {-24,8}, {-24,9}, {-24,10}, {-24,11}, {-24,12}, {-24,13}, {-24,14}, {-24,15}, {-24,16}, {-23,-4}, {-23,-3}, {-23,-2}, {-23,-1}, {-23,0}, {-23,1}, {-23,2}, {-23,3}, {-23,4}, {-23,5}, {-23,6}, {-23,7}, {-23,8}, {-23,9}, {-23,10}, {-23,11}, {-23,12}, {-23,13}, {-23,14}, {-23,15}, {-23,16}, {-23,17}, {-22,-7}, {-22,-6}, {-22,-5}, {-22,-4}, {-22,-3}, {-22,-2}, {-22,-1}, {-22,0}, {-22,1}, {-22,2}, {-22,3}, {-22,4}, {-22,5}, {-22,6}, {-22,7}, {-22,8}, {-22,9}, {-22,10}, {-22,11}, {-22,12}, {-22,13}, {-22,14}, {-22,15}, {-22,16}, {-22,17}, {-22,18}, {-21,-12}, {-21,-11}, {-21,-10}, {-21,-9}, {-21,-8}, {-21,-7}, {-21,-6}, {-21,-5}, {-21,-4}, {-21,-3}, {-21,-2}, {-21,-1}, {-21,0}, {-21,1}, {-21,2}, {-21,3}, {-21,4}, {-21,5}, {-21,6}, {-21,7}, {-21,8}, {-21,9}, {-21,10}, {-21,11}, {-21,12}, {-21,13}, {-21,14}, {-21,15}, {-21,16}, {-21,17}, {-21,18}, {-20,-13}, {-20,-12}, {-20,-11}, {-20,-10}, {-20,-9}, {-20,-8}, {-20,-7}, {-20,-6}, {-20,-5}, {-20,-4}, {-20,-3}, {-20,-2}, {-20,-1}, {-20,0}, {-20,1}, {-20,2}, {-20,3}, {-20,4}, {-20,5}, {-20,6}, {-20,7}, {-20,8}, {-20,9}, {-20,10}, {-20,11}, {-20,12}, {-20,13}, {-20,14}, {-20,15}, {-20,16}, {-20,17}, {-19,-14}, {-19,-13}, {-19,-12}, {-19,-11}, {-19,-10}, {-19,-9}, {-19,-8}, {-19,-7}, {-19,-6}, {-19,-5}, {-19,-4}, {-19,-3}, {-19,-2}, {-19,-1}, {-19,0}, {-19,1}, {-19,2}, {-19,3}, {-19,4}, {-19,5}, {-19,6}, {-19,7}, {-19,8}, {-19,9}, {-19,10}, {-19,11}, {-19,12}, {-19,13}, {-19,14}, {-19,15}, {-19,16}, {-19,17}, {-18,-14}, {-18,-13}, {-18,-12}, {-18,-11}, {-18,-10}, {-18,-9}, {-18,-8}, {-18,-7}, {-18,-6}, {-18,-5}, {-18,-4}, {-18,-3}, {-18,-2}, {-18,-1}, {-18,0}, {-18,1}, {-18,2}, {-18,3}, {-18,4}, {-18,5}, {-18,6}, {-18,7}, {-18,8}, {-18,9}, {-18,10}, {-18,11}, {-18,12}, {-18,13}, {-18,14}, {-18,15}, {-18,16}, {-18,17}, {-17,-13}, {-17,-12}, {-17,-11}, {-17,-10}, {-17,-9}, {-17,-8}, {-17,-7}, {-17,-6}, {-17,-5}, {-17,-4}, {-17,-3}, {-17,-2}, {-17,-1}, {-17,0}, {-17,1}, {-17,2}, {-17,3}, {-17,4}, {-17,5}, {-17,6}, {-17,7}, {-17,8}, {-17,9}, {-17,10}, {-17,11}, {-17,12}, {-17,13}, {-17,14}, {-17,15}, {-17,16}, {-17,17}, {-16,-12}, {-16,-11}, {-16,-10}, {-16,-9}, {-16,-8}, {-16,-7}, {-16,-6}, {-16,-5}, {-16,-4}, {-16,-3}, {-16,-2}, {-16,-1}, {-16,0}, {-16,1}, {-16,2}, {-16,3}, {-16,4}, {-16,5}, {-16,6}, {-16,7}, {-16,8}, {-16,9}, {-16,10}, {-16,11}, {-16,12}, {-16,13}, {-16,14}, {-16,15}, {-16,16}, {-16,17}, {-16,18}, {-15,-7}, {-15,-6}, {-15,-5}, {-15,-4}, {-15,-3}, {-15,-2}, {-15,-1}, {-15,0}, {-15,1}, {-15,7}, {-15,8}, {-15,9}, {-15,10}, {-15,11}, {-15,12}, {-15,13}, {-15,14}, {-15,15}, {-15,16}, {-15,17}, {-15,18}, {-14,-4}, {-14,-3}, {-14,-2}, {-14,-1}, {-14,0}, {-14,7}, {-14,8}, {-14,9}, {-14,10}, {-14,11}, {-14,12}, {-14,13}, {-14,14}, {-14,15}, {-14,16}, {-14,17}, {-13,-3}, {-13,-2}, {-13,-1}, {-13,0}, {-13,1}, {-13,7}, {-13,8}, {-13,9}, {-13,10}, {-13,11}, {-13,12}, {-13,13}, {-13,14}, {-13,15}, {-13,16}, {-12,4}, {-12,7}, {-12,8}, {-12,9}, {-12,10}, {-12,11}, {-11,7}, {-11,8}, {-11,9}, {-11,10}, {-11,11}, {-10,6}, {-10,7}, {-10,8}, {-10,9}, {-9,6}, {-9,7}, {-9,8}, {-9,9}, {-8,7}, {-8,8}, {-8,9}, {-15,2}, {-15,3}, {-15,5}, {-15,6}, {-14,1}, {-14,3}, {-14,4}, {-14,5}, {-14,6}, {-13,3}, {-13,4}, {-13,5}, {-13,6}, {-12,0}, {-12,1}, {-12,2}, {-12,3}, {-12,5}, {-12,6}, {-11,1}, {-11,2}, {-11,3}, {-11,4}, {-11,5}, {-11,6}, {-11,12}, {-11,13}, {-10,10}, {-10,11}, {-10,12}, {-10,13}, {-10,14}, {-9,-3}, {-9,10}, {-9,11}, {-8,10}, {-8,11}, {-8,12}, {-8,13}, {-6,2}, {-5,3}, },
  },
  entities = {
    ["se-rock-big-asteroid"] = {{x=-9.19140625, y=-29.39453125, graphics_variation=7}, {x=-25.421875, y=-24.9140625, graphics_variation=12}, {x=-24.72265625, y=-22.40625, graphics_variation=19}, {x=-24.65234375, y=-20.08203125, graphics_variation=16}, {x=-22.5390625, y=-19.24609375, graphics_variation=15}, {x=-8.65625, y=-13.7890625, graphics_variation=20}, {x=3.07421875, y=-13.6171875, graphics_variation=8}, {x=-7.8203125, y=-11.23828125, graphics_variation=10}, {x=-2.73828125, y=-12.0859375, graphics_variation=17}, {x=4.22265625, y=-11.1640625, graphics_variation=10}, {x=-9.76953125, y=-8.1484375, graphics_variation=17}, {x=-9.890625, y=-10.09765625, graphics_variation=19}, {x=-7.26171875, y=-9.26171875, graphics_variation=14}, {x=-4.94140625, y=-8.75390625, graphics_variation=19}, {x=-7.203125, y=-7.078125, graphics_variation=17}, {x=-5.73046875, y=-4.1796875, graphics_variation=15}, {x=-3.5234375, y=-5.22265625, graphics_variation=5}, {x=8.85546875, y=-5.9453125, graphics_variation=11}, {x=7.57421875, y=-3.98828125, graphics_variation=3}, {x=12.47265625, y=-2.55859375, graphics_variation=15}, {x=14.6796875, y=-3.86328125, graphics_variation=1}, {x=7.69921875, y=-1.97265625, graphics_variation=20}, {x=16.8046875, y=-0.73046875, graphics_variation=9}, {x=6.2265625, y=0.02734375, graphics_variation=13}, {x=-7.52734375, y=2.9765625, graphics_variation=18}, {x=4.25, y=2.0234375, graphics_variation=11}, {x=-1.89453125, y=4.9140625, graphics_variation=3}, {x=1.28515625, y=4.92578125, graphics_variation=19}, {x=3.95703125, y=4.37890625, graphics_variation=11}, {x=9.359375, y=4.71484375, graphics_variation=9}, {x=-2.4375, y=8.1640625, graphics_variation=3}, {x=8.78515625, y=9.28125, graphics_variation=9}, {x=-3.78125, y=10.54296875, graphics_variation=17}, {x=0.90625, y=10.2890625, graphics_variation=8}, {x=-3.84765625, y=15.6953125, graphics_variation=2}, {x=-1.765625, y=17.29296875, graphics_variation=14}, {x=4.734375, y=18.12890625, graphics_variation=10}, {x=5.86328125, y=21.9453125, graphics_variation=18}, },
  },
  blueprint_strings = {
    { -- entities
      xadj = -12, yadj = 2,
      string = "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"
    }
  }
}


return asteroid_belt_ship
