-- Note: Default entity force will be 'capture', if a player character get near and there are no enemies the player will capture the entity.
local galaxy_ship = {
  center = {x = 11, y = 5},
  force_name = "ignore",
	insert_list = {
  -- list of items to put in chests
  --   max, min define the range for number of items
  --   odds will only have it appear 1 in odds times
  --   max, min, and odds all default to 1
    {x=14, y=2,   items={{name = "empty-barrel", max = 100}}},
    {x=16, y=-11, items={{name = "empty-barrel", max = 100}}},
    {x=16, y=2,   items={{name = mod_prefix.."contaminated-space-water-barrel", max = 50}}},
    {x=14, y=-11, items={{name = mod_prefix.."chemical-gel-barrel", max = 20}}},
    {x=25, y=-43, items={{name = "uranium-rounds-magazine", max = 50},
                         {name = mod_prefix.."thruster-suit"},
                         {name = "processed-fuel", max = 200},
                         {name = "explosive-uranium-cannon-shell", max = 20},
                         {name = mod_prefix.."contaminated-scrap", max = 100},
                        }},
    {x=7,  y=-27, items={{name = "pistol"},
                         {name = "submachine-gun"},
                         {name = "uranium-rounds-magazine", max = 50},
                        }},
    {x=-1, y=-21, items={{name = "pistol"},
                         {name = "submachine-gun"},
                         {name = "uranium-rounds-magazine", max = 50},
                        }},
    {x=0,  y=-21, items={{name = "pistol"},
                         {name = "submachine-gun"},
                         {name = "uranium-rounds-magazine", max = 50},
                        }},
    {x=1,  y=-21, items={{name = mod_prefix.."thruster-suit"}}},
    {x=16, y=-21, items={{name = "uranium-rounds-magazine", max = 50},
                         {name = mod_prefix.."thruster-suit"},
                         {name = "processed-fuel", max = 200},
                         {name = mod_prefix.."contaminated-scrap", max = 50},
                        }},
    {x=7,  y=-27, items={{name = mod_prefix.."thruster-suit"},
                         {name = mod_prefix.."naquium-processor", min = 8, max = 8}
                        }},
    {x=-9.5, y=1.5, items={{name = mod_prefix.."thruster-suit"}}},
    {x=8.5,  y=1.5, items={{name = mod_prefix.."thruster-suit"}}},
    {x=-2, y=-13, items={{name = "nuclear-fuel", odds = 3},
                         {name = "uranium-ore", max = 50},
                         {name = mod_prefix.."contaminated-scrap", max = 50},
                        }},
    {x=2,  y=-13, items={{name = "nuclear-fuel", odds = 3},
                         {name = "uranium-ore", max = 50},
                         {name = mod_prefix.."contaminated-scrap", max = 50},
                        }},
    {x=6,  y=-13, items={{name = "nuclear-fuel", odds = 3},
                         {name = "uranium-ore", max = 50},
                         {name = mod_prefix.."contaminated-scrap", max = 50},
                        }},
    {x=6,  y=25,  items={{name = "nuclear-fuel", odds = 3},
                         {name = "uranium-ore", max = 50},
                         {name = mod_prefix.."contaminated-scrap", max = 50},
                        }},
	},
  prebuild = function(surface, ruin_position, ruin)
  end,
  postbuild = function(surface, ruin_position, ruin)
	-- fill all chests with scrap, an an occasional emergency space suit
    local chests = surface.find_entities_filtered({position = ruin_position, radius = 100, name = {
			"logistic-chest-active-provider",
			"logistic-chest-buffer",
			"logistic-chest-passive-provider",
			"logistic-chest-requester",
			"logistic-chest-storage",
			mod_prefix.."cargo-rocket-cargo-pod",
			"cargo-wagon"}})
	for _, chest in pairs(chests) do
		chest.insert({name = mod_prefix.."scrap", count = math.random(1,100)})
		if math.random(1,3) == 1 then
			chest.insert({name = mod_prefix.."contaminated-scrap", count = math.random(1,50)})
		end
		if math.random(1,50) == 1 then
			chest.insert({name = mod_prefix.."thruster-suit", count = 1})
		end
	end

	--game.print("starting armory chests")
	-- fill all armory buffer chests with walls and floors (for bots to fix any damage)
	-- fill storage chests with ammo, or broken ammo (uranium ore or contaminated scrap)

    chests = surface.find_entities_filtered({
		position = {x = ruin_position.x, y = ruin_position.y - 40},
		radius = 7,
		name = {"logistic-chest-buffer", "logistic-chest-storage"}
		})
	for _, chest in pairs(chests) do
		--game.print(chest.name .. " found at " .. chest.position.x .. ", " .. chest.position.y)
		if chest.name == "logistic-chest-storage" then
			local r = math.random(1,16)
			-- mostly scrap, some ore and some survived bullets
			if r <= 6 then
				chest.insert({name = mod_prefix.."contaminated-scrap", count = math.random(1, 100)})
			elseif r <= 12 then
				chest.insert({name = "uranium-ore", count = math.random(1, 50)})
			elseif r <= 16 then
				chest.insert({name = "uranium-rounds-magazine", count = math.random(1, 50)})
			end
		elseif chest.name == "logistic-chest-buffer" then
			chest.insert({name = mod_prefix.."spaceship-wall", count = math.random(1, 50)})
			chest.insert({name = mod_prefix.."spaceship-floor", count = math.random(1, 50)})
		end
	end
	--game.print("done all types of chests")
  end,
  blueprint_strings = {
    { -- tiles
      xadj = 0, yadj = -2,
      string =
      "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"
    },
    { -- entities
      xadj = 0, yadj = -2,
      string =
      "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"
    },
  }
}

return galaxy_ship
